/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.composite;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;

public class MarchingAntsOp
implements BufferedImageOp {
    private int phase;

    public MarchingAntsOp(int phase) {
        this.phase = phase;
    }

    public BufferedImage filter(BufferedImage srcImage, BufferedImage destImage) {
        int offset = this.phase;
        if (destImage == null) {
            destImage = this.createCompatibleDestImage(srcImage, null);
        }
        WritableRaster src = srcImage.getRaster();
        WritableRaster dest = destImage.getRaster();
        int x = src.getMinX();
        int y = src.getMinY();
        int w = src.getWidth();
        int h = src.getHeight();
        int[] srcPix = null;
        int[] srcPix2 = null;
        int[] dstInPix = null;
        int[] dstOutPix = new int[w * 4];
        for (int i = 0; i < h; ++i) {
            srcPix = src.getPixels(x, y, w, 1, srcPix);
            dstInPix = dest.getPixels(x, y, w, 1, dstInPix);
            int lastAlpha = 0;
            int k = 0;
            for (int j = 0; j < w; ++j) {
                int alphaAbove;
                int alpha = srcPix[k + 3];
                int n = alphaAbove = i != 0 ? srcPix2[k + 3] : alpha;
                if (i != 0 && j != 0 && ((alpha ^ lastAlpha) & 0x80) != 0 || ((alpha ^ alphaAbove) & 0x80) != 0) {
                    int v;
                    dstOutPix[k] = v = (offset + i + j) % 10 > 4 ? 0 : 255;
                    dstOutPix[k + 1] = v;
                    dstOutPix[k + 2] = v;
                    dstOutPix[k + 3] = 255;
                } else {
                    dstOutPix[k] = 0;
                    dstOutPix[k + 1] = 0;
                    dstOutPix[k + 2] = 0;
                    dstOutPix[k + 3] = 0;
                }
                lastAlpha = alpha;
                k += 4;
            }
            dest.setPixels(x, y, w, 1, dstOutPix);
            int[] t = srcPix;
            srcPix = srcPix2;
            srcPix2 = t;
            ++y;
        }
        return destImage;
    }

    public Rectangle2D getBounds2D(BufferedImage src) {
        return new Rectangle(0, 0, src.getWidth(), src.getHeight());
    }

    public Point2D getPoint2D(Point2D srcPt, Point2D destPt) {
        if (destPt == null) {
            destPt = new Point2D.Double();
        }
        destPt.setLocation(srcPt.getX(), srcPt.getY());
        return destPt;
    }

    public RenderingHints getRenderingHints() {
        return null;
    }

    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        BufferedImage dest = null;
        if (destCM == null) {
            destCM = src.getColorModel();
        }
        dest = new BufferedImage(destCM, destCM.createCompatibleWritableRaster(src.getWidth(), src.getHeight()), destCM.isAlphaPremultiplied(), null);
        return dest;
    }
}

