/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.beans;

import com.jhlabs.beans.AbstractPropertyEditor;
import com.jhlabs.beans.PropertySheet;
import java.awt.Component;
import java.beans.PropertyDescriptor;
import java.util.Dictionary;
import javax.swing.JLabel;
import javax.swing.JSlider;

public class FloatPropertyEditor
extends AbstractPropertyEditor {
    protected JSlider slider;
    protected float min;
    protected float max;

    public FloatPropertyEditor() {
        this.min = 0.0f;
        this.max = 1.0f;
    }

    public FloatPropertyEditor(String name, String property, float min, float max) {
        super(name, property);
        this.min = min;
        this.max = max;
    }

    public void setPropertyDescriptor(PropertyDescriptor propertyDescriptor) {
        super.setPropertyDescriptor(propertyDescriptor);
        Object o = propertyDescriptor.getValue("min");
        if (o != null && o instanceof Number) {
            this.setMinValue(((Number)o).floatValue());
        }
        if ((o = propertyDescriptor.getValue("max")) != null && o instanceof Number) {
            this.setMaxValue(((Number)o).floatValue());
        }
    }

    public void setMinValue(float min) {
        this.min = min;
    }

    public float getMinValue() {
        return this.min;
    }

    public void setMaxValue(float max) {
        this.max = max;
    }

    public float getMaxValue() {
        return this.max;
    }

    public Component getCustomEditor() {
        this.slider = new JSlider(0, (int)(this.getMinValue() * 100.0f), (int)(this.getMaxValue() * 100.0f), (int)(this.getMinValue() * 100.0f));
        this.slider.setPaintTicks(true);
        this.slider.setMajorTickSpacing((int)((this.getMaxValue() - this.getMinValue()) * 100.0f));
        this.slider.setPaintLabels(true);
        this.slider.setFont(PropertySheet.SMALL_FONT);
        Dictionary table = this.slider.getLabelTable();
        if (table != null) {
            table.put(new Integer(this.slider.getMinimum()), new JLabel(Float.toString(this.min)));
            table.put(new Integer(this.slider.getMaximum()), new JLabel(Float.toString(this.max)));
        }
        this.slider.setLabelTable(table);
        this.slider.addChangeListener(this);
        return this.slider;
    }

    public Object getValue() {
        return new Float((float)this.slider.getValue() / 100.0f);
    }

    public void setValue(Object value) {
        this.slider.setValue((int)(((Float)value).floatValue() * 100.0f));
    }
}

