/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.app;

import com.jhlabs.app.FixedLengthDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;

public class NumericDocument
extends FixedLengthDocument {
    protected boolean allowSign = true;
    protected boolean allowDecimalPoint = true;
    protected boolean allowExponent = true;
    protected boolean allowHex = false;

    public NumericDocument(int maxLength) {
        super(maxLength);
    }

    public NumericDocument(int maxLength, boolean allowSign, boolean allowDecimalPoint, boolean allowExponent) {
        super(maxLength);
        this.allowSign = allowSign;
        this.allowDecimalPoint = allowDecimalPoint;
        this.allowExponent = allowExponent;
    }

    public void setup(int maxLength, boolean allowSign, boolean allowDecimalPoint, boolean allowExponent, boolean allowHex) {
        this.setMaxLength(maxLength);
        this.allowSign = allowSign;
        this.allowDecimalPoint = allowDecimalPoint;
        this.allowExponent = allowExponent;
        this.allowHex = allowHex;
    }

    public void insertString(int offset, String string, AttributeSet a) throws BadLocationException {
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            if (Character.isDigit(c) || this.allowSign && (c == '+' || c == '-') || this.allowDecimalPoint && c == '.' || this.allowExponent && (c == 'e' || c == 'E') || this.allowHex && (c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F')) continue;
            throw new BadLocationException(string, offset);
        }
        super.insertString(offset, string, a);
    }
}

