/*
 * Decompiled with CFR 0.152.
 */
package starwave.util.regexp;

import starwave.util.regexp.NoSuchMatchException;

abstract class State {
    int offset;
    int limit;
    int[] pstart;
    int[] pend;

    State(int offset, int limit) {
        this.offset = offset;
        this.limit = limit;
    }

    int charsLeft() {
        return this.limit - this.offset;
    }

    abstract int getchar();

    abstract int getchar(int var1);

    abstract int indexOf(int var1, int var2);

    abstract int lastIndexOf(int var1, int var2);

    final int getLimit() {
        return this.limit;
    }

    final void ensureGroup(int n) {
        if (this.pstart == null || n >= this.pstart.length) {
            int[] np = new int[n + 4];
            if (this.pstart != null) {
                System.arraycopy(this.pstart, 0, np, 0, this.pstart.length);
            }
            this.pstart = np;
            np = new int[n + 4];
            if (this.pend != null) {
                System.arraycopy(this.pend, 0, np, 0, this.pend.length);
            }
            this.pend = np;
        }
    }

    final void startGroup(int n) {
        this.ensureGroup(n);
        this.pstart[n] = this.offset + 1;
    }

    final void endGroup(int n) {
        this.ensureGroup(n);
        this.pend[n] = this.offset + 1;
    }

    final void validateGroup(int n) {
        if (this.pstart == null || n >= this.pstart.length || this.pstart[n] == 0 || this.pend[n] == 0) {
            throw new NoSuchMatchException(": " + n);
        }
    }

    final void clearGroup(int n) {
        this.validateGroup(n);
        this.pend[n] = 0;
        this.pstart[n] = 0;
    }

    abstract String getGroupString(int var1);

    final int getGroupLength(int n) {
        this.validateGroup(n);
        return this.pend[n] - this.pstart[n];
    }

    final int getGroupStart(int n) {
        this.validateGroup(n);
        return this.pstart[n] - 1;
    }

    final int getGroupEnd(int n) {
        this.validateGroup(n);
        return this.pend[n] - 1;
    }

    public String toString() {
        return "offset = " + this.offset + ", limit = " + this.limit;
    }
}

