/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.widgets.internal;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import net.disy.commons.core.model.ObjectModel;
import net.disy.commons.core.model.listener.IChangeListener;
import net.disy.commons.core.provider.IProvider;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.core.util.Range;
import net.disy.commons.swing.color.SwingColors;
import net.disy.commons.swing.widgets.internal.IBlockRenderingHandler;
import net.disy.commons.swing.widgets.internal.LineCountingRenderingHandler;
import net.disy.commons.swing.widgets.internal.TextBlock;
import net.disy.commons.swing.widgets.internal.TextBlockDelimiter;
import net.disy.commons.swing.widgets.internal.TextBlockFactory;
import net.disy.commons.swing.widgets.internal.TextComponentKeyListener;
import net.disy.commons.swing.widgets.internal.TextContent;
import net.disy.commons.swing.widgets.internal.TextGraphicsRenderingHandler;
import net.disy.commons.swing.widgets.internal.TextPosition;
import net.disy.commons.swing.widgets.internal.TextPositionFindingHandler;
import net.disy.commons.swing.widgets.internal.TextSelection;

public class AutoWrappingTextComponent
extends JComponent {
    private final int width;
    private final TextContent content = new TextContent();
    private final ObjectModel<TextSelection> selectionModel = new ObjectModel();

    public AutoWrappingTextComponent(String text, int width) {
        Ensure.ensureArgumentNotNull(text);
        this.width = width;
        this.setForeground(SwingColors.getTextAreaForegroundColor());
        this.setBackground(SwingColors.getTextAreaBackgroundColor());
        this.content.setTextBlocks(TextBlockFactory.createTextBlocks(text));
        this.setOpaque(true);
        MouseAdapter mouseListener = new MouseAdapter(){
            private TextPosition startPosition;

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!AutoWrappingTextComponent.this.isEnabled()) {
                    return;
                }
                TextPosition position = this.getTextPositionAt(e.getPoint());
                if (position == null) {
                    this.startPosition = null;
                    return;
                }
                if (this.startPosition == null) {
                    return;
                }
                AutoWrappingTextComponent.this.selectionModel.setValue(TextSelection.createSelection(this.startPosition, position));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                TextPosition position;
                if (!AutoWrappingTextComponent.this.isEnabled()) {
                    return;
                }
                AutoWrappingTextComponent.this.clearSelection();
                this.startPosition = position = this.getTextPositionAt(e.getPoint());
                AutoWrappingTextComponent.this.requestFocus();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (!AutoWrappingTextComponent.this.isEnabled()) {
                    return;
                }
                TextPosition position = this.getTextPositionAt(e.getPoint());
                if (position == null) {
                    return;
                }
                if (this.startPosition == null) {
                    return;
                }
                AutoWrappingTextComponent.this.selectionModel.setValue(TextSelection.createSelection(this.startPosition, position));
            }

            private TextPosition getTextPositionAt(Point point) {
                FontMetrics metrics = AutoWrappingTextComponent.this.getFontMetrics(AutoWrappingTextComponent.this.getFont());
                TextPositionFindingHandler finder = new TextPositionFindingHandler(metrics, point);
                AutoWrappingTextComponent.this.render(metrics, AutoWrappingTextComponent.this.getWidth(), finder);
                TextPosition textPosition = finder.getTextPosition();
                if (textPosition == null) {
                    if (point.y < 0) {
                        return new TextPosition(0, 0);
                    }
                    return AutoWrappingTextComponent.this.content.getLastTextPosition();
                }
                return textPosition;
            }
        };
        this.addMouseListener(mouseListener);
        this.addMouseMotionListener(mouseListener);
        this.selectionModel.addChangeListener(new IChangeListener(){

            @Override
            public void stateChanged() {
                AutoWrappingTextComponent.this.repaint();
            }
        });
        this.addKeyListener(new TextComponentKeyListener(this.content, this.selectionModel, new IProvider<Toolkit>(){

            @Override
            public Toolkit getObject() {
                return AutoWrappingTextComponent.this.getToolkit();
            }
        }));
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int lineCount = this.getLineCount(this.width, fontMetrics);
        return new Dimension(this.width, fontMetrics.getHeight() * lineCount);
    }

    private int getLineCount(int layoutWidth, FontMetrics fontMetrics) {
        LineCountingRenderingHandler lineCountingHandler = new LineCountingRenderingHandler();
        this.render(fontMetrics, layoutWidth, lineCountingHandler);
        return lineCountingHandler.getLineCount();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        g.setFont(this.getFont());
        FontMetrics metrics = g.getFontMetrics();
        this.render(metrics, this.getWidth(), new TextGraphicsRenderingHandler(g, this.getForeground()));
    }

    private void render(FontMetrics metrics, int layoutWidth, IBlockRenderingHandler blockRenderer) {
        int spaceWidth = metrics.stringWidth(" ");
        int tabWidth = metrics.stringWidth("        ");
        boolean xOffset = false;
        int x = 0;
        int lineIndex = 0;
        block6: for (int blockIndex = 0; blockIndex < this.content.getBlockCount(); ++blockIndex) {
            boolean fits;
            int spaceLeft = layoutWidth - x;
            TextBlock block = this.content.getBlock(blockIndex);
            int blockWidth = metrics.stringWidth(block.getText());
            boolean bl = fits = spaceLeft >= blockWidth;
            if (!fits && blockIndex > 0) {
                blockRenderer.handleLineEndsAt(blockIndex - 1, this.content.getBlock(blockIndex - 1).getText().length(), x, lineIndex, metrics.getHeight());
                x = 0;
                ++lineIndex;
            }
            Range selectionRange = this.getSelectionRangeIfAny(this.selectionModel.getValue(), blockIndex, block);
            blockRenderer.handleText(blockIndex, block.getText(), x, lineIndex, metrics.getHeight(), selectionRange);
            x += blockWidth;
            TextBlockDelimiter delimiter = block.getDelimiter();
            boolean delimiterSelected = this.isDelimiterSelected(this.selectionModel.getValue(), this.content, blockIndex);
            switch (delimiter) {
                case END_OF_TEXT: {
                    blockRenderer.handleLineEndsAt(blockIndex, block.getText().length(), x, lineIndex, metrics.getHeight());
                    continue block6;
                }
                case NEWLINE: {
                    blockRenderer.handleLineEndsAt(blockIndex, block.getText().length(), x, lineIndex, metrics.getHeight());
                    x = 0;
                    ++lineIndex;
                    continue block6;
                }
                case SPACE: {
                    blockRenderer.handleWhiteSpace(x, x + spaceWidth, lineIndex, new TextPosition(blockIndex, block.getText().length()), metrics.getHeight(), delimiterSelected);
                    x += spaceWidth;
                    continue block6;
                }
                case TAB: {
                    blockRenderer.handleWhiteSpace(x, x + tabWidth, lineIndex, new TextPosition(blockIndex, block.getText().length()), metrics.getHeight(), delimiterSelected);
                    x += tabWidth;
                }
            }
        }
    }

    private Range getSelectionRangeIfAny(TextSelection selection, int blockIndex, TextBlock block) {
        if (selection == null) {
            return null;
        }
        if (selection.getStartPosition().getBlockIndex() > blockIndex) {
            return null;
        }
        if (selection.getEndPosition().getBlockIndex() < blockIndex) {
            return null;
        }
        if (selection.getStartPosition().getBlockIndex() < blockIndex) {
            if (selection.getEndPosition().getBlockIndex() > blockIndex) {
                return new Range(0, block.getText().length());
            }
            return new Range(0, selection.getEndPosition().getIndexInBlock());
        }
        if (selection.getEndPosition().getBlockIndex() > blockIndex) {
            return new Range(selection.getStartPosition().getIndexInBlock(), block.getText().length());
        }
        return new Range(selection.getStartPosition().getIndexInBlock(), selection.getEndPosition().getIndexInBlock());
    }

    private boolean isDelimiterSelected(TextSelection selection, TextContent textContent, int blockIndex) {
        if (selection == null) {
            return false;
        }
        if (selection.getStartPosition().getBlockIndex() > blockIndex) {
            return false;
        }
        if (selection.getEndPosition().getBlockIndex() < blockIndex) {
            return false;
        }
        if (selection.getEndPosition().getBlockIndex() > blockIndex) {
            return true;
        }
        int indexInBlock = selection.getEndPosition().getIndexInBlock();
        return indexInBlock >= textContent.getBlock(blockIndex).getText().length();
    }

    public void setText(String text) {
        this.clearSelection();
        this.content.setTextBlocks(TextBlockFactory.createTextBlocks(text));
        this.invalidate();
        this.repaint();
    }

    private void clearSelection() {
        this.selectionModel.setValue(null);
    }
}

