/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.util;

import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

public class EventDispatchThreadUtilities {
    private EventDispatchThreadUtilities() {
    }

    public static void ensureIsEventDispatchThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Expected to be executed on the event dispatch thread, but was '" + Thread.currentThread().getName() + "'");
        }
    }

    public static void invokeAndWait(Runnable runnable) throws InvocationTargetException {
        EventDispatchThreadUtilities.invokeAndWait(runnable);
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        } else {
            runnable.run();
        }
    }
}

