/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.tree;

import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import net.disy.commons.core.model.AbstractChangeableModel;
import net.disy.commons.core.util.ArrayUtilities;
import net.disy.commons.swing.tree.SmartTreeModel;
import net.disy.commons.swing.tree.SmartTreeModelNode;

public class SmartTreeSelectionModel<T>
extends AbstractChangeableModel {
    private final TreeSelectionModel selectionModel;
    private final SmartTreeModel<T> treeModel;

    public SmartTreeSelectionModel(TreeSelectionModel selectionModel, SmartTreeModel<T> treeModel) {
        this.selectionModel = selectionModel;
        this.treeModel = treeModel;
        selectionModel.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                SmartTreeSelectionModel.this.fireChangeEvent();
            }
        });
    }

    public void setSelectionPath(T[] path) {
        this.selectionModel.setSelectionPath(new TreePath(this.treeModel.getPathInModel(path)));
    }

    public T[] getSelectionPath() {
        TreePath selectionPath = this.selectionModel.getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        return this.treeModel.getPathInSmartTree(ArrayUtilities.transform(selectionPath.getPath(), SmartTreeModelNode.class));
    }

    public T getSelectedNode() {
        T[] selectionPath = this.getSelectionPath();
        return selectionPath == null ? null : (T)selectionPath[selectionPath.length - 1];
    }

    public boolean isSelectionEmpty() {
        return this.selectionModel.isSelectionEmpty();
    }
}

