/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.mousecursor;

import java.awt.Cursor;
import java.awt.Image;
import java.util.HashMap;
import java.util.Map;
import net.disy.commons.swing.mousecursor.CursorCapabilities;
import net.disy.commons.swing.mousecursor.CursorId;
import net.disy.commons.swing.mousecursor.CursorInitializer;
import net.disy.commons.swing.mousecursor.ExtendedCursor;

public class CursorProvider {
    private CursorCapabilities cursorCapabilities;
    private static CursorProvider instance = new CursorProvider();
    private final Map<CursorId, ExtendedCursor> cursorDescriptions = new HashMap<CursorId, ExtendedCursor>();

    private CursorProvider() {
    }

    public static CursorProvider getInstance() {
        return instance;
    }

    public void addCursorDescriptionSet(ExtendedCursor set) {
        if (this.cursorDescriptions.containsKey((Object)set.getCursorId())) {
            throw new IllegalArgumentException("Cursor for id " + (Object)((Object)set.getCursorId()) + " already registered");
        }
        this.cursorDescriptions.put(set.getCursorId(), set);
    }

    public Cursor getCursor(CursorId cursorId) {
        ExtendedCursor set = this.getExtendedCursor(cursorId);
        if (set == null) {
            return Cursor.getDefaultCursor();
        }
        return set.getCursor();
    }

    public Image getCursorImage(CursorId cursorId) {
        ExtendedCursor set = this.getExtendedCursor(cursorId);
        if (set == null) {
            return null;
        }
        return set.getCursorImage();
    }

    public ExtendedCursor getExtendedCursor(CursorId cursorId) {
        ExtendedCursor extendedCursor = this.cursorDescriptions.get((Object)cursorId);
        if (extendedCursor == null) {
            return null;
        }
        if (!extendedCursor.isInitialized()) {
            extendedCursor.initialize(this.getCursorCapabilities());
        }
        return extendedCursor;
    }

    private CursorCapabilities getCursorCapabilities() {
        if (this.cursorCapabilities == null) {
            this.cursorCapabilities = CursorCapabilities.getSystemCapabilities();
        }
        return this.cursorCapabilities;
    }

    public void setCursorCapabilities(CursorCapabilities cursorCapabilities) {
        this.cursorCapabilities = cursorCapabilities;
    }

    static {
        new CursorInitializer().initCursorDescriptions(CursorProvider.getInstance());
    }
}

