/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.image;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.disy.commons.core.io.IOUtilities;

public class ImageLoader {
    public static Image getImageWithoutCaching(InputStream inputStream) throws IOException {
        return ImageLoader.readImage(inputStream);
    }

    public static Image getMemoryImageWithoutCaching(InputStream inputStream) throws IOException {
        try {
            return ImageLoader.createMemoryImage(ImageLoader.readImage(inputStream));
        }
        catch (LoadingException e) {
            throw new IOException("Loading: " + e.getMessage());
        }
    }

    public static Image readImage(InputStream inputStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtilities.copyStream(bufferedInputStream, byteArrayOutputStream);
        return Toolkit.getDefaultToolkit().createImage(byteArrayOutputStream.toByteArray());
    }

    public static Image createMemoryImage(Image image) {
        int h;
        int w;
        DimensionGetter dimensionGetter = new DimensionGetter(image);
        try {
            w = dimensionGetter.getWidth();
            h = dimensionGetter.getHeight();
        }
        catch (Exception e) {
            throw new LoadingException("image missing or corrupted", e);
        }
        int[] pixels = new int[w * h];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, w, h, pixels, 0, w);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException e) {
            throw new LoadingException("interrupted waiting for pixels!", e);
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            throw new LoadingException("image fetch aborted or errored");
        }
        MemoryImageSource memoryImageSource = new MemoryImageSource(w, h, pixels, 0, w);
        return Toolkit.getDefaultToolkit().createImage(memoryImageSource);
    }

    public static class LoadingException
    extends RuntimeException {
        private LoadingException(String message) {
            super(message);
        }

        private LoadingException(String message, Throwable cause) {
            super(message + " :" + cause.getMessage());
        }
    }

    private static final class DimensionGetter
    implements ImageObserver {
        private final Image image;
        private boolean succeeded = false;

        DimensionGetter(Image image) {
            this.image = image;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            if ((infoflags & 0x40) == 64) {
                DimensionGetter dimensionGetter = this;
                synchronized (dimensionGetter) {
                    this.notifyAll();
                }
                return false;
            }
            if (width != -1 && height != -1) {
                DimensionGetter dimensionGetter = this;
                synchronized (dimensionGetter) {
                    this.succeeded = true;
                    this.notifyAll();
                }
                return false;
            }
            return true;
        }

        int getWidth() {
            this.ensureLoaded();
            return this.image.getWidth(this);
        }

        int getHeight() {
            this.ensureLoaded();
            return this.image.getHeight(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ensureLoaded() {
            DimensionGetter dimensionGetter = this;
            synchronized (dimensionGetter) {
                if (this.image.getWidth(this) == -1 || this.image.getHeight(this) == -1) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!this.succeeded) {
                    throw new RuntimeException("error while loading image.");
                }
            }
        }
    }
}

