/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.dialog.foldout;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.disy.commons.swing.dialog.foldout.IFoldOutDialogConfiguration;
import net.disy.commons.swing.dialog.userdialog.UserDialog;
import net.disy.commons.swing.layout.util.ButtonPanelBuilder;

public class FoldOutDialog
extends UserDialog {
    private JButton foldOutButton;
    private boolean isFoldedOut = false;
    private JPanel foldOutPanel;

    public FoldOutDialog(Component parent, IFoldOutDialogConfiguration userDialog) {
        super(parent, userDialog);
        this.isFoldedOut = userDialog.isInitiallyFoldedOut();
    }

    private IFoldOutDialogConfiguration getFoldOutUserDialog() {
        return (IFoldOutDialogConfiguration)this.getConfiguration();
    }

    @Override
    protected JComponent[] createAdditionalButtons() {
        this.foldOutButton = new JButton();
        this.foldOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FoldOutDialog.this.toggleFoldOut();
            }
        });
        this.updateButtonText();
        return new JComponent[]{this.foldOutButton};
    }

    private void toggleFoldOut() {
        this.isFoldedOut = !this.isFoldedOut;
        this.foldOutPanel.setVisible(this.isFoldedOut);
        this.updateButtonText();
        if (this.isFoldedOut) {
            this.getFoldOutUserDialog().getFoldOutPage().requestFocus();
        } else {
            this.getConfiguration().getDialogPage().requestFocus();
        }
        this.getDialog().pack();
    }

    private void updateButtonText() {
        if (this.isFoldedOut) {
            this.foldOutButton.setText(this.getFoldOutUserDialog().getFoldInButtonText());
        } else {
            this.foldOutButton.setText(this.getFoldOutUserDialog().getFoldOutButtonText());
        }
    }

    @Override
    protected JComponent createButtonBar() {
        JComponent foldOutContent = this.getFoldOutUserDialog().getFoldOutPage().getContent();
        JPanel bottomPanel = new JPanel(new BorderLayout());
        this.foldOutPanel = new JPanel(new BorderLayout());
        this.foldOutPanel.setVisible(false);
        this.foldOutPanel.setBorder(BorderFactory.createEmptyBorder(10, 8, 0, 8));
        this.foldOutPanel.add((Component)foldOutContent, "Center");
        JComponent[] createdButtons = this.createButtons();
        if (createdButtons.length > 0 && createdButtons[0] instanceof JButton) {
            this.setDefaultButton((JButton)createdButtons[0]);
        }
        ButtonPanelBuilder buttonPanelBuilder = new ButtonPanelBuilder();
        for (int i = 0; i < createdButtons.length; ++i) {
            buttonPanelBuilder.add(createdButtons[i]);
        }
        bottomPanel.add((Component)buttonPanelBuilder.createPanel(), "North");
        bottomPanel.add((Component)this.foldOutPanel, "Center");
        return bottomPanel;
    }
}

