/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.action.ActionConfiguration;
import net.disy.commons.swing.action.IActionConfiguration;
import net.disy.commons.swing.icon.IconImageIcon;
import net.disy.commons.swing.label.MnemonicLabel;
import net.disy.commons.swing.label.MnemonicLabelParser;
import net.disy.commons.swing.util.GuiUtilities;
import net.disy.commons.swing.util.IEnableable;

public abstract class SmartAction
extends AbstractAction
implements IEnableable {
    private Component explicitParentComponent;

    public SmartAction() {
        this(new ActionConfiguration());
    }

    public SmartAction(String name) {
        this(new ActionConfiguration(name));
    }

    public SmartAction(String name, Icon icon) {
        this(new ActionConfiguration(name, icon));
    }

    public SmartAction(Icon icon) {
        this(null, icon);
    }

    public SmartAction(IActionConfiguration configuration) {
        Ensure.ensureArgumentNotNull(configuration);
        this.setName(configuration.getName());
        this.setIcon(configuration.getIcon());
        this.setToolTipText(configuration.getToolTipText());
    }

    public IActionConfiguration getActionConfiguration() {
        return new ActionConfiguration(this.getName(), this.getIcon(), this.getToolTipText());
    }

    public void setExplicitParentComponent(Component explicitParentComponent) {
        this.explicitParentComponent = explicitParentComponent;
    }

    public void setName(String name) {
        if (name != null) {
            MnemonicLabel mnemonicLabel = MnemonicLabelParser.parse(name);
            this.putValue("Name", mnemonicLabel.getPlainText());
            if (mnemonicLabel.getMnemonicCharacter() != null) {
                this.setMnemonic(mnemonicLabel.getMnemonicCharacter().charValue());
            }
        } else {
            this.putValue("Name", name);
        }
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        Component parentComponent = this.explicitParentComponent == null ? GuiUtilities.getWindowForComponent(e) : this.explicitParentComponent;
        this.execute(parentComponent);
    }

    protected abstract void execute(Component var1);

    public final void setMnemonic(int keyCode) {
        this.putValue("MnemonicKey", new Integer(keyCode));
    }

    public final void setMnemonic(char character) {
        char ch = Character.toUpperCase(character);
        if (!SmartAction.isLetter(ch) && !SmartAction.isDigit(ch)) {
            throw new IllegalArgumentException("Unsupported mnemonic character'" + character + "'.");
        }
        this.setMnemonic((int)ch);
    }

    public final void setAcceleratorKey(KeyStroke keyStroke) {
        this.putValue("AcceleratorKey", keyStroke);
    }

    private static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private static boolean isLetter(char ch) {
        return Character.isLetter(ch);
    }

    public final String getName() {
        return (String)this.getValue("Name");
    }

    public final void setIcon(Icon icon) {
        if (icon instanceof ImageIcon || icon == null) {
            this.putValue("SmallIcon", icon);
            return;
        }
        IconImageIcon imageIcon = new IconImageIcon(icon);
        this.putValue("SmallIcon", imageIcon);
    }

    public final void setToolTipText(String shortDescription) {
        this.putValue("ShortDescription", shortDescription);
    }

    public final String getToolTipText() {
        return (String)this.getValue("ShortDescription");
    }

    public final Icon getIcon() {
        return (Icon)this.getValue("SmallIcon");
    }
}

