/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.core.util;

import java.util.Arrays;
import java.util.Map;
import net.disy.commons.core.util.ContractFailedException;
import net.disy.commons.core.util.ObjectUtilities;
import net.disy.commons.core.util.Range;

public class Ensure {
    public static void ensureNotNull(String message, Object object) {
        Ensure.ensureTrue(message, object != null);
    }

    public static void ensureArgumentNotNull(String message, Object object) throws IllegalArgumentException {
        Ensure.ensureArgumentTrue(message, object != null);
    }

    public static void ensureNotNull(Object object) {
        Ensure.ensureNotNull("Object must not be null", object);
    }

    public static void ensureArgumentNotNull(Object object) throws IllegalArgumentException {
        Ensure.ensureArgumentNotNull("Object must not be null", object);
    }

    public static void ensureFalse(String message, boolean state) {
        Ensure.ensureTrue(message, !state);
    }

    public static void ensureTrue(String message, boolean state) {
        if (!state) {
            throw new ContractFailedException(message);
        }
    }

    public static void ensureArgumentTrue(String message, boolean state) throws IllegalArgumentException {
        if (!state) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void ensureArgumentEquals(String message, Object expected, Object argument) {
        Ensure.ensureArgumentTrue(message, ObjectUtilities.equals(expected, argument));
    }

    public static void ensureArgumentEquals(String message, int expected, int argument) {
        Ensure.ensureArgumentTrue(message, expected == argument);
    }

    public static void ensureArrayIndex(int index, int minIndex, int maxIndex) {
        if (index < minIndex) {
            throw new ArrayIndexOutOfBoundsException(index + " < " + minIndex);
        }
        if (index > maxIndex) {
            throw new ArrayIndexOutOfBoundsException(index + " > " + maxIndex);
        }
    }

    public static void ensureArgumentFalse(String message, boolean argumentState) {
        Ensure.ensureArgumentTrue(message, !argumentState);
    }

    public static void ensureArgumentArrayContentsNotNull(Object[] arguments) {
        if (arguments == null) {
            return;
        }
        String message = "Array contents must not be null";
        for (int i = 0; i < arguments.length; ++i) {
            Ensure.ensureArgumentNotNull("Array contents must not be null at index " + i + " (0.." + (arguments.length - 1) + ')', arguments[i]);
        }
    }

    public static void ensureValueWithin(double value, double minValue, double maxValue) {
        if (value < minValue) {
            throw new IllegalArgumentException(value + " < " + minValue);
        }
        if (value > maxValue) {
            throw new ArrayIndexOutOfBoundsException(value + " > " + maxValue);
        }
    }

    public static void ensureEqual(Object obj1, Object obj2) {
        if (!ObjectUtilities.equals(obj1, obj2)) {
            throw new ContractFailedException("The Objects " + obj1 + " and " + obj2 + " are not equal.");
        }
    }

    public static void ensureArgumentEquals(int expected, int actual) {
        Ensure.ensureArgumentEquals("", expected, actual);
    }

    public static void ensureArgumentInstanceOf(Object value, Class<?> expectedClass) {
        Ensure.ensureArgumentNotNull(value);
        if (!expectedClass.isInstance(value)) {
            throw new IllegalArgumentException("Illegal class '" + value.getClass() + "'");
        }
    }

    public static void ensureClassAssignableFrom(Class<?> providedClass, Class<?> expectedClass) {
        Ensure.ensureArgumentNotNull(providedClass);
        if (!expectedClass.isAssignableFrom(providedClass)) {
            throw new IllegalArgumentException("Illegal class: expected class '" + expectedClass.getName() + "' is not assignable from provided class '" + providedClass + '\'');
        }
    }

    public static void ensureNull(Object object) {
        Ensure.ensureTrue("Object must be null, was " + object, object == null);
    }

    public static void ensureArgumentIndexInBounds(int index, Range range) {
        if (!range.contains(index)) {
            throw new IllegalArgumentException(index + " not within " + range);
        }
    }

    public static void ensureArgumentArrayContains(Object[] array, Object value) {
        Ensure.ensureArgumentTrue("Array does not contain " + value, Arrays.asList(array).contains(value));
    }

    public static void ensureArgumentArrayContains(String message, Object[] array, Object value) {
        Ensure.ensureArgumentTrue(message, Arrays.asList(array).contains(value));
    }

    public static void ensureArgumentNull(String message, Object value) {
        if (value != null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void ensureNull(String message, Object value) {
        if (value != null) {
            throw new ContractFailedException(message);
        }
    }

    public static void ensureEqual(long expected, long actual) {
        Ensure.ensureTrue("expected " + expected + ", was " + actual, expected == actual);
    }

    public static void ensureArgumentNotNullOrTrimmedEmpty(String argumentValue) {
        Ensure.ensureArgumentNotNullOrTrimmedEmpty("Argument", argumentValue);
    }

    public static void ensureArgumentNotNullOrTrimmedEmpty(String argumentName, String argumentValue) {
        if (argumentValue == null) {
            String message = argumentName + " must not be null";
            throw new IllegalArgumentException(message);
        }
        if (argumentValue.trim().length() == 0) {
            String message = argumentName + " must not be trimmed empty";
            throw new IllegalArgumentException(message);
        }
    }

    public static void ensureArgumentNotEmpty(Map<?, ?> map) {
        if (map.isEmpty()) {
            throw new IllegalArgumentException("Map must not be empty.");
        }
    }

    public static <T> void ensureArgumentNotNullOrEmpty(T[] array) {
        Ensure.ensureArgumentNotNull(array);
        if (array.length == 0) {
            throw new IllegalArgumentException("Array must not be empty.");
        }
    }
}

