/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.core.predicate;

import java.util.ArrayList;
import java.util.List;
import net.disy.commons.core.predicate.IPredicate;

public class AggregatedPredicate<T>
implements IPredicate<T> {
    private final List<IPredicate<T>> allPredicates = new ArrayList<IPredicate<T>>();

    public AggregatedPredicate(IPredicate<T> ... predicates) {
        for (IPredicate<T> predicate : predicates) {
            this.addPredicate(predicate);
        }
    }

    @Override
    public boolean evaluate(T value) {
        for (IPredicate<T> predicate : this.allPredicates) {
            if (predicate.evaluate(value)) continue;
            return false;
        }
        return true;
    }

    public void addPredicate(IPredicate<T> predicate) {
        this.allPredicates.add(predicate);
    }
}

