/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.core.number;

public class MinMaxIntValueBuilder {
    private double minValue = Double.NaN;
    private double maxValue = Double.NaN;

    public int getMaximum() {
        if (!this.hasValues()) {
            throw new IllegalStateException("No max value defined.");
        }
        return (int)this.maxValue;
    }

    public int getMaximum(int fallBackValue) {
        if (!this.hasValues()) {
            return fallBackValue;
        }
        return (int)this.maxValue;
    }

    public int getMinimum() {
        if (!this.hasValues()) {
            throw new IllegalStateException("No min value defined.");
        }
        return (int)this.minValue;
    }

    public int getMinimum(int fallBackValue) {
        if (!this.hasValues()) {
            return fallBackValue;
        }
        return (int)this.minValue;
    }

    public boolean hasValues() {
        return !Double.isNaN(this.maxValue);
    }

    public void add(int value) {
        this.minValue = (double)value < this.minValue || Double.isNaN(this.minValue) ? (double)value : this.minValue;
        this.maxValue = (double)value > this.maxValue || Double.isNaN(this.maxValue) ? (double)value : this.maxValue;
    }
}

