/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.core.model;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.disy.commons.core.exception.UnreachableCodeReachedException;
import net.disy.commons.core.model.IChangeableModel;
import net.disy.commons.core.model.listener.IChangeListener;
import net.disy.commons.core.model.listener.ListenerList;
import net.disy.commons.core.model.listener.NotifyChangeListenerClosure;
import net.disy.commons.core.util.ObjectUtilities;

public abstract class SmartChangeableModel
implements Cloneable,
IChangeableModel {
    private transient ListenerList<IChangeListener> listeners = new ListenerList();
    private transient ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    protected Object clone() {
        try {
            SmartChangeableModel clone = (SmartChangeableModel)super.clone();
            clone.listeners = new ListenerList();
            clone.readWriteLock = new ReentrantReadWriteLock();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new UnreachableCodeReachedException(e);
        }
    }

    @Override
    public void addChangeListener(IChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeChangeListener(IChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireChangeEvent() {
        this.listeners.forAllDo(NotifyChangeListenerClosure.getInstance());
    }

    public int getChangeListenerCount() {
        return this.listeners.getSize();
    }

    public final void clearListenerList() {
        this.listeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T getValue(IProperty<T> property) {
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            T t = property.getValue();
            return t;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <T> void setValue(IProperty<T> property, T value) {
        Lock writeLock = this.readWriteLock.writeLock();
        writeLock.lock();
        try {
            if (ObjectUtilities.equals(property.getValue(), value)) {
                return;
            }
            property.setValue(value);
        }
        finally {
            writeLock.unlock();
        }
        this.fireChangeEvent();
    }

    protected static interface IProperty<T> {
        public T getValue();

        public void setValue(T var1);
    }
}

