/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.pattern;

import de.jave.ascii.plate.textareabased.AsciiTextArea;
import de.jave.ascii.plate.textareabased.AsciiTextAreaProperties;
import de.jave.gui.dialog.JDialogFactory;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.pattern.Pattern;
import de.jave.jave.pattern.PatternList;
import de.jave.javeplayer.AsciiPacker;
import de.jave.text.TextTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.List;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.disy.commons.core.message.Message;
import net.disy.commons.core.message.MessageType;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.dialog.message.MessageDialogUtilities;
import net.disy.commons.swing.dialog.message.YesNoCancel;
import net.disy.commons.swing.fontchooser.model.FontModel;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;
import net.disy.commons.swing.layout.util.ButtonPanelBuilder;
import net.disy.commons.swing.layout.util.LayoutUtilities;

public class PatternDialog {
    private static final String TITLE = "Pattern Library";
    private final JDialog dialog;
    private final List list;
    private final PatternList patternList;
    private final AsciiTextArea taPattern;
    private final AsciiTextArea taPreview;
    private final TextField tfAuthor;
    private Pattern currentPattern;

    public PatternDialog(Component parent) {
        this.dialog = JDialogFactory.createJDialog(parent, TITLE, true);
        this.patternList = new PatternList();
        this.patternList.load();
        this.list = new List();
        int size = this.patternList.getPatternCount();
        for (int i = 0; i < size; ++i) {
            this.list.add(this.patternList.getPattern(i).getName());
        }
        this.list.setMultipleMode(false);
        this.list.select(0);
        this.list.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PatternDialog.this.updatePreview();
            }
        });
        this.currentPattern = this.patternList.getPattern(0);
        FontModel fontModel = new FontModel(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        AsciiTextAreaProperties patternTextAreaProperties = new AsciiTextAreaProperties(fontModel);
        this.taPattern = new AsciiTextArea(new Dimension(10, 6), patternTextAreaProperties);
        patternTextAreaProperties.setEditable(false);
        this.tfAuthor = new TextField(15);
        this.tfAuthor.setEditable(false);
        final SmartAction deleteAction = new SmartAction("Delete"){

            @Override
            protected void execute(Component parentComponent) {
                PatternDialog.this.performDeleteSelectedPattern(parentComponent);
            }
        };
        this.list.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PatternDialog.this.updateDeleteActionEnabled(deleteAction);
            }
        });
        this.updateDeleteActionEnabled(deleteAction);
        SmartAction okAction = new SmartAction("&OK"){

            @Override
            protected void execute(Component parentComponent) {
                PatternDialog.this.performOk();
            }
        };
        SmartAction cancelAction = new SmartAction("&Cancel"){

            @Override
            protected void execute(Component parentComponent) {
                PatternDialog.this.performCancel();
            }
        };
        ButtonPanelBuilder buttonPanelBuilder = new ButtonPanelBuilder();
        buttonPanelBuilder.add(okAction);
        buttonPanelBuilder.add(cancelAction);
        JPanel detailsPanel = new JPanel(new GridDialogLayout(2, false));
        detailsPanel.add(new JLabel("Author:"));
        detailsPanel.add(this.tfAuthor);
        GridDialogLayoutData data = new GridDialogLayoutData();
        data.setHorizontalSpan(2);
        detailsPanel.add((Component)new JButton(deleteAction), data);
        AsciiTextAreaProperties previewTextAreaProperties = new AsciiTextAreaProperties(fontModel);
        this.taPreview = new AsciiTextArea(new Dimension(30, 12), new AsciiTextAreaProperties(fontModel));
        previewTextAreaProperties.setEditable(false);
        JPanel patternPanel = new JPanel(new BorderLayout(LayoutUtilities.getComponentSpacing(), 1));
        patternPanel.add((Component)new JLabel("Pattern:"), "North");
        patternPanel.add((Component)this.list, "West");
        patternPanel.add((Component)this.taPattern.getContent(), "Center");
        patternPanel.add((Component)detailsPanel, "East");
        JPanel previewPanel = new JPanel(new BorderLayout());
        previewPanel.add((Component)new JLabel("Preview:"), "North");
        previewPanel.add((Component)this.taPreview.getContent(), "Center");
        this.dialog.getContentPane().setLayout(new BorderLayout(LayoutUtilities.getComponentSpacing(), LayoutUtilities.getComponentSpacing()));
        this.dialog.getContentPane().add((Component)patternPanel, "North");
        this.dialog.getContentPane().add((Component)previewPanel, "Center");
        this.dialog.getContentPane().add((Component)buttonPanelBuilder.createPanel(), "South");
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PatternDialog.this.performCancel();
            }
        });
        this.updatePreview();
    }

    private void performCancel() {
        this.currentPattern = null;
        this.performOk();
    }

    private void updateDeleteActionEnabled(SmartAction deleteAction) {
        deleteAction.setEnabled(this.list.getSelectedIndex() != -1);
    }

    public void addPattern(Pattern newPattern) {
        this.patternList.add(newPattern);
        this.patternList.save();
        this.updateList();
        this.updatePreview();
    }

    private void updateList() {
        this.list.removeAll();
        int size = this.patternList.getPatternCount();
        for (int i = 0; i < size; ++i) {
            this.list.add(this.patternList.getPattern(i).getName());
        }
        this.list.select(size - 1);
    }

    private void updatePreview() {
        int height;
        int width;
        int index = this.list.getSelectedIndex();
        this.currentPattern = this.patternList.getPattern(index);
        char[][] ch = AsciiPacker.decode(this.currentPattern.getCode());
        this.taPattern.setText(TextTools.toString(ch));
        this.tfAuthor.setText(this.currentPattern.getAuthor());
        int patternWidth = ch.length;
        int patternHeight = ch[0].length;
        for (width = patternWidth; width < 50; width += patternWidth) {
        }
        for (height = patternHeight; height < 12; height += patternHeight) {
        }
        char[][] cp = new char[height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                cp[y][x] = ch[y % patternWidth][x % patternHeight];
            }
        }
        this.taPreview.setText(TextTools.toString(cp));
    }

    private void performOk() {
        this.dialog.setVisible(false);
    }

    private void performDeleteSelectedPattern(Component parentComponent) {
        int index = this.list.getSelectedIndex();
        this.currentPattern = this.patternList.getPattern(index);
        String question = "Do you really want to delete\nthe Pattern \"" + this.currentPattern.getName() + "\" ?";
        YesNoCancel answer = MessageDialogUtilities.showYesNoCancelDialog(parentComponent, new Message("Delete pattern", question, MessageType.WARNING));
        if (answer != YesNoCancel.YES) {
            return;
        }
        this.patternList.delete(index);
        this.patternList.save();
        this.updateList();
        this.list.select(index - 1);
        this.updatePreview();
    }

    public Dialog getDialog() {
        return this.dialog;
    }

    public Pattern getSelectedPattern() {
        return this.currentPattern;
    }

    public boolean isCanceled() {
        return this.currentPattern == null;
    }

    public void show() {
        this.dialog.setVisible(true);
    }
}

