/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.figlet.export;

import de.jave.jave.LineAlgorithm;
import de.jave.jave.figlet.export.FigletExportModel;
import de.jave.lib.CharacterPlate;
import de.jave.text.TextTools;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;

public class FigletFileExporter {
    private static final int[][] UMLAUTS = new int[][]{{196, 65}, {214, 79}, {220, 85}, {228, 97}, {246, 111}, {252, 117}, {223, 32}};

    public static void export(FigletExportModel model, File file) {
        int i;
        char hardblank;
        char endmark;
        CharacterPlate plate = model.getCharacterPlate();
        char[][] raster = model.getRaster();
        boolean[] charUsed = new boolean[128];
        CharacterPlate[] figChars = new CharacterPlate[255];
        int figCharWidth = model.getCharacterWidth();
        int figCharHeight = model.getCharacterHeight();
        int figCharDescent = model.getCharacterDescent();
        int figCharVSpacing = model.getVerticalSpacing();
        int figCharHSpacing = model.getHorizontalSpacing();
        for (int y = 0; y < raster.length; ++y) {
            for (int x = 0; x < raster[0].length; ++x) {
                if (raster[y][x] == '\u0000') continue;
                figChars[raster[y][x]] = plate.getCopy(new Rectangle(x * figCharHSpacing + x * figCharWidth, y * figCharVSpacing + y * figCharHeight, figCharWidth, figCharHeight));
                char[][] ch = figChars[raster[y][x]].getContent();
                for (int yy = 0; yy < figCharHeight; ++yy) {
                    for (int xx = 0; xx < figCharWidth; ++xx) {
                        if (ch[yy][xx] > '\u0080') continue;
                        charUsed[ch[yy][xx]] = true;
                    }
                }
            }
        }
        for (endmark = '#'; endmark < '\u0080' && charUsed[endmark]; endmark = (char)((char)(endmark + 1))) {
        }
        for (hardblank = (char)(endmark + 1); hardblank < '\u0080' && charUsed[hardblank]; hardblank = (char)(hardblank + '\u0001')) {
        }
        for (i = 0; i < 26; ++i) {
            if (figChars[i + 65] == null) {
                figChars[i + 65] = figChars[i + 97].getClone();
                continue;
            }
            if (figChars[i + 97] != null) continue;
            figChars[i + 97] = figChars[i + 65].getClone();
        }
        for (i = 0; i < UMLAUTS.length; ++i) {
            if (figChars[UMLAUTS[i][0]] != null) continue;
            figChars[FigletFileExporter.UMLAUTS[i][0]] = figChars[UMLAUTS[i][1]].getClone();
        }
        for (i = 32; i < 127; ++i) {
            if (figChars[i] != null) continue;
            figChars[i] = new CharacterPlate(figCharWidth, figCharHeight);
        }
        if (figChars[32].isEmpty()) {
            LineAlgorithm.drawLineBresenham(figChars[32], 0, 0, 0, figCharHeight - 1, hardblank);
        }
        for (i = 0; i < 255; ++i) {
            if (figChars[i] == null) continue;
            Insets insets = figChars[i].getEmptyInsets();
            if (insets.right > 0) {
                --insets.right;
            }
            int w = figCharWidth - insets.right + 2;
            figChars[i].setSize(w, figCharHeight);
            if (i != 32 && figChars[i].isEmpty()) {
                figChars[i].set(0, 0, (char)i);
            }
            LineAlgorithm.drawLineBresenham(figChars[i], w - 2, 0, w - 2, figCharHeight - 1, endmark);
            figChars[i].setForce(w - 1, figCharHeight - 1, endmark);
        }
        boolean printDirection = false;
        int baseLine = figCharHeight - figCharDescent;
        int maxLength = figCharWidth + 2;
        String comment = model.getComment();
        Dimension dim = TextTools.getDimensionOf(comment);
        int commentLines = dim.height;
        boolean codetagCount = false;
        try {
            int i2;
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            bw.write("flf2a" + hardblank + ' ' + figCharHeight + ' ' + baseLine + ' ' + maxLength + ' ' + model.getOldLayout() + ' ' + commentLines + ' ' + 0 + ' ' + model.getFullLayout() + ' ' + 0);
            bw.newLine();
            if (commentLines > 0) {
                bw.write(comment);
                bw.newLine();
            }
            for (i2 = 32; i2 < 127; ++i2) {
                bw.write(figChars[i2].toString());
                bw.newLine();
            }
            for (i2 = 0; i2 < UMLAUTS.length; ++i2) {
                bw.write(figChars[UMLAUTS[i2][0]].toString());
                bw.newLine();
            }
            bw.close();
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace(System.err);
            System.err.println("Error saving File: " + e);
        }
    }
}

