/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.algorithm.camel;

import de.jave.image.GImage;
import de.jave.image.greyscale.GGreyscaleImage;
import de.jave.image.greyscale.GreyscaleImageFactory;
import de.jave.image.monochrome.GMonochromeImage;
import de.jave.jave.algorithm.GeneralAlgorithm;
import de.jave.jave.algorithm.camel.CamelRun;
import de.jave.jave.algorithm.camel.CamelizeImageOptions;
import de.jave.jave.algorithm.camel.CamelizeTextOptions;
import de.jave.jave.algorithm.camel.WordsToShapeResult;
import de.jave.lib.CharacterPlate;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.PixelGrabber;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class Camelizer {
    private final String[] textWords;
    private final String textPure;
    private final String textPreserveSpaces;
    private GGreyscaleImage imageRawInternal;
    private GImage imagePreview;

    public Camelizer(String text) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == ' ' || ch == '\n') continue;
            sb.append(ch);
        }
        this.textPure = sb.toString();
        sb.setLength(0);
        boolean lastCharSpace = false;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == ' ') {
                if (!lastCharSpace) {
                    sb.append('\u00a0');
                }
                lastCharSpace = true;
                continue;
            }
            if (ch == '\n') {
                if (!lastCharSpace) {
                    sb.append('\u00a0');
                }
                lastCharSpace = true;
                continue;
            }
            sb.append(ch);
            lastCharSpace = false;
        }
        this.textPreserveSpaces = sb.toString();
        StringTokenizer st = new StringTokenizer(this.textPreserveSpaces, String.valueOf('\u00a0'), false);
        int count = st.countTokens();
        this.textWords = new String[count];
        for (int i = 0; i < count; ++i) {
            this.textWords[i] = st.nextToken();
        }
    }

    public void setRawImage(GGreyscaleImage image) {
        this.imageRawInternal = image.getWidth() > 180 ? image.getYScaledInstance(0.5) : image.getXScaledInstance(2.0);
    }

    public GImage getPreviewImage() {
        return this.imagePreview;
    }

    public boolean checkReady() {
        return this.imageRawInternal != null;
    }

    public CharacterPlate camelize(CamelizeImageOptions imageOptions, CamelizeTextOptions textOptions) {
        switch (textOptions.getPreserveMode()) {
            case PRESERVE_NONE: {
                return this.camelizePreserveNone(imageOptions);
            }
            case PRESERVE_WHITESPACE: {
                return this.camelizePreserveWhitespace(imageOptions);
            }
            case PRESERVE_WORDS: {
                return this.camelizePreserveWords(imageOptions, textOptions.getFillCharacter());
            }
        }
        throw new IllegalArgumentException();
    }

    private CharacterPlate camelizePreserveWords(CamelizeImageOptions imageOptions, char fillCharacter) {
        GMonochromeImage imageShape;
        WordsToShapeResult result;
        int charCount = this.textPure.length();
        do {
            imageShape = Camelizer.getShapeImage(this.imageRawInternal, imageOptions, charCount);
            result = Camelizer.wordsToShape(this.textWords, imageShape, fillCharacter);
            charCount *= 2;
        } while (result.getDifference() < 0);
        charCount /= 2;
        for (int step = (charCount /= 2) / 4; (result = Camelizer.wordsToShape(this.textWords, imageShape = Camelizer.getShapeImage(this.imageRawInternal, imageOptions, charCount), fillCharacter)).getDifference() != 0 && step != 0; step /= 2) {
            if (result.getDifference() > 0) {
                charCount -= step;
                continue;
            }
            charCount += step;
        }
        if (result.getDifference() < 0) {
            imageShape = Camelizer.getShapeImage(this.imageRawInternal, imageOptions, ++charCount);
            result = Camelizer.wordsToShape(this.textWords, imageShape, fillCharacter);
        }
        this.imagePreview = imageShape.scaleY2();
        return result.getPlate();
    }

    private CharacterPlate camelizePreserveWhitespace(CamelizeImageOptions imageOptions) {
        int charCount = this.textPreserveSpaces.length();
        GMonochromeImage imageShape = Camelizer.getShapeImage(this.imageRawInternal, imageOptions, charCount);
        CharacterPlate cp = Camelizer.textToShape(this.textPreserveSpaces, imageShape);
        this.imagePreview = imageShape.scaleY2();
        return cp;
    }

    private CharacterPlate camelizePreserveNone(CamelizeImageOptions imageOptions) {
        int charCount = this.textPure.length();
        GMonochromeImage imageShape = Camelizer.getShapeImage(this.imageRawInternal, imageOptions, charCount);
        CharacterPlate cp = Camelizer.textToShape(this.textPure, imageShape);
        this.imagePreview = imageShape.scaleY2();
        return cp;
    }

    private static CharacterPlate textToShape(String sourceText, GMonochromeImage shapeImage) {
        int charCount = sourceText.length();
        int w = shapeImage.getWidth();
        int h = shapeImage.getHeight();
        CharacterPlate result = new CharacterPlate(w, h);
        int i = 0;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                if (shapeImage.get(x, y) != 0 || i >= charCount) continue;
                result.set(x, y, sourceText.charAt(i++));
            }
        }
        GeneralAlgorithm.replace(result, '\u00a0', ' ');
        return result;
    }

    private static WordsToShapeResult wordsToShape(String[] words, GMonochromeImage shapeImage, char fillChar) {
        int i;
        boolean fill = true;
        int w = shapeImage.getWidth();
        int h = shapeImage.getHeight();
        int wordCount = words.length;
        ArrayList<CamelRun> runs = new ArrayList<CamelRun>();
        CamelRun run = Camelizer.getNextRun(0, 0, w, h, shapeImage);
        while (run != null) {
            runs.add(run);
            run = Camelizer.getNextRun(run.getEndX() + 1, run.getY(), w, h, shapeImage);
        }
        int difference = 0;
        int wordIndex = 0;
        for (i = 0; i < runs.size(); ++i) {
            run = (CamelRun)runs.get(i);
            if (wordIndex >= wordCount) {
                difference += run.getLength();
                continue;
            }
            int length = run.getLength();
            if (words[wordIndex].length() > length) continue;
            run.setText(words[wordIndex]);
            length -= words[wordIndex].length();
            ++wordIndex;
            while (wordIndex < wordCount && words[wordIndex].length() + 1 <= length) {
                run.setText(run.getText() + fillChar + words[wordIndex]);
                length -= words[wordIndex].length() + 1;
                ++wordIndex;
            }
        }
        for (i = wordIndex; i < wordCount; ++i) {
            difference -= words[i].length();
        }
        CharacterPlate cp = new CharacterPlate(w, h);
        for (int i2 = 0; i2 < runs.size(); ++i2) {
            run = (CamelRun)runs.get(i2);
            if (run.getText() != null) {
                cp.paste(Camelizer.stretch(run.getText(), run.getLength(), fillChar), run.getStartX(), run.getY());
                continue;
            }
            for (int j = run.getStartX(); j <= run.getEndX(); ++j) {
                cp.setForce(j, run.getY(), fillChar);
            }
        }
        return new WordsToShapeResult(cp, difference);
    }

    private static final String stretch(String text, int length, char fillChar) {
        int diff = length - text.length();
        if (diff == 0) {
            return text;
        }
        int i1 = text.indexOf(fillChar);
        if (i1 == -1) {
            return Camelizer.spaces(diff / 2, fillChar) + text + Camelizer.spaces(diff - diff / 2, fillChar);
        }
        while (diff > 0) {
            text = text.substring(0, i1) + fillChar + text.substring(i1);
            --diff;
            if ((i1 = text.indexOf(fillChar, i1 + 2)) != -1) continue;
            i1 = text.indexOf(fillChar);
        }
        return text;
    }

    private static final String spaces(int length, char fillChar) {
        char[] ch = new char[length];
        for (int i = 0; i < length; ++i) {
            ch[i] = fillChar;
        }
        return new String(ch);
    }

    private static CamelRun getNextRun(int x, int y, int w, int h, GMonochromeImage shapeImage) {
        if (x >= w) {
            return Camelizer.getNextRun(0, y + 1, w, h, shapeImage);
        }
        if (y >= h) {
            return null;
        }
        while (x < w && shapeImage.get(x, y) != 0) {
            ++x;
        }
        if (x == w) {
            return Camelizer.getNextRun(0, y + 1, w, h, shapeImage);
        }
        int startX = x;
        while (x + 1 < w && shapeImage.get(x + 1, y) == 0) {
            ++x;
        }
        return new CamelRun(startX, x, y);
    }

    public static GGreyscaleImage loadImage(Image imageRaw, Component comp) {
        int imageWidth = imageRaw.getWidth(comp);
        int imageHeight = imageRaw.getHeight(comp);
        if (imageHeight > 300 || imageWidth > 400) {
            int newWidth = 0;
            int newHeight = 0;
            if (imageHeight > 300) {
                newHeight = 300;
                newWidth = newHeight * imageWidth / imageHeight;
            } else {
                newWidth = 400;
                newHeight = newWidth * imageHeight / imageWidth;
            }
            imageWidth = newWidth;
            imageHeight = newHeight;
            imageRaw = imageRaw.getScaledInstance(newWidth, newHeight, 2);
            MediaTracker tracker = new MediaTracker(comp);
            tracker.addImage(imageRaw, 0);
            try {
                tracker.waitForID(0);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        int[] pixels = new int[imageWidth * imageHeight];
        PixelGrabber pg = new PixelGrabber(imageRaw, 0, 0, imageWidth, imageHeight, pixels, 0, imageWidth);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Internal Error: " + e.toString());
        }
        return new GreyscaleImageFactory().createGreyscaleImage(pixels, imageWidth, imageHeight);
    }

    private static GMonochromeImage getShapeImage(GGreyscaleImage imageRaw, CamelizeImageOptions imageOptions, int charCount) {
        GGreyscaleImage image;
        if (imageOptions.isNegative()) {
            image = imageRaw.getClone();
            image.invert();
        } else {
            image = imageRaw;
        }
        int w = image.getWidth();
        int h = image.getHeight();
        int startThreshold = 128 - (int)(96.0 * imageOptions.getBrightness());
        int startWidth = (int)Math.ceil((double)w * Math.sqrt((double)charCount / (double)image.countPixelsWithMaxValue(startThreshold)));
        int startHeight = h * startWidth / w;
        GGreyscaleImage g3 = null;
        g3 = image.getScaledInstance(startWidth, startHeight);
        int count = g3.countPixelsWithMaxValue(startThreshold);
        while (count < charCount) {
            startHeight = h * ++startWidth / w;
            g3 = image.getScaledInstance(startWidth, startHeight);
            count = g3.countPixelsWithMaxValue(startThreshold);
        }
        if (count > charCount) {
            int step = 64;
            boolean done = false;
            while (!done) {
                if (count == charCount || step == 0) {
                    done = true;
                    continue;
                }
                if (count < charCount) {
                    count = g3.countPixelsWithMaxValue(startThreshold += step);
                    step /= 2;
                    continue;
                }
                if (count <= charCount) continue;
                count = g3.countPixelsWithMaxValue(startThreshold -= step);
                step /= 2;
            }
            if (count < charCount) {
                ++startThreshold;
            }
        }
        return g3.getThresholdedInstance(startThreshold);
    }
}

