/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.algorithm;

import de.jave.jave.JaveSelection;
import de.jave.jave.algorithm.GeneralAlgorithm;
import de.jave.jave.algorithm.JaveAlgorithm;
import de.jave.lib.area.BooleanArea;

public class FlipDynamicAction
extends JaveAlgorithm {
    private static FlipDynamicAction instance;

    private FlipDynamicAction() {
    }

    public static synchronized FlipDynamicAction getInstance() {
        if (instance == null) {
            instance = new FlipDynamicAction();
        }
        return instance;
    }

    @Override
    public String getUndoRedoName() {
        return "flip";
    }

    @Override
    public String getMenuItemLabel() {
        return "Flip dynamic";
    }

    @Override
    public JaveSelection apply(JaveSelection plate) {
        int y;
        int h = plate.getHeight();
        int w = plate.getWidth();
        char[][] ch = plate.getContent().getContent();
        BooleanArea mask = plate.getMask();
        if (mask != null) {
            boolean[][] m = mask.getContent();
            for (y = 0; y < h / 2; ++y) {
                boolean[] t = m[y];
                m[y] = m[h - y - 1];
                m[h - y - 1] = t;
            }
        }
        for (int y2 = 0; y2 < h / 2; ++y2) {
            char[] t = ch[y2];
            ch[y2] = ch[h - y2 - 1];
            ch[h - y2 - 1] = t;
        }
        for (int x = 0; x < w; ++x) {
            for (y = 0; y < h; ++y) {
                if (ch[y][x] < ' ' || ch[y][x] > '~') continue;
                ch[y][x] = GeneralAlgorithm.getFlip().charAt(ch[y][x] - 32);
            }
        }
        return plate;
    }
}

