/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.actions.quickstart;

import de.jave.gui.listpanel.IClickHandler;
import de.jave.gui.listpanel.MouseActiveListPanelBuilder;
import de.jave.jave.JavEApplication;
import de.jave.jave.actions.quickstart.AnimationEditorQuickStartItem;
import de.jave.jave.actions.quickstart.FigletEditorQuickStartItem;
import de.jave.jave.actions.quickstart.IQuickStartItem;
import de.jave.jave.actions.quickstart.Image2AsciiQuickStartItem;
import de.jave.jave.actions.quickstart.QuickStartIcons;
import de.jave.jave.actions.quickstart.TextEditorQuickStartItem;
import de.jave.jave.actions.quickstart.WatermarkQuickStartItem;
import de.jave.jave.preferences.JaveApplicationPreferences;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.disy.commons.core.message.IBasicMessage;
import net.disy.commons.core.model.ObjectModel;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.dialog.userdialog.DefaultDialogConfiguration;
import net.disy.commons.swing.dialog.userdialog.UserDialog;
import net.disy.commons.swing.dialog.userdialog.buttons.DialogButtonConfigurationFactory;
import net.disy.commons.swing.dialog.userdialog.page.AbstractDialogPage;
import net.disy.commons.swing.dialog.userdialog.page.IDialogPage;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;
import net.disy.commons.swing.widgets.AutoWrappingLabel;

public final class QuickStartAction
extends SmartAction {
    private final JavEApplication application;

    public QuickStartAction(JavEApplication application) {
        super("Quick Start...", QuickStartIcons.ACTION_ICON);
        this.setToolTipText("Show Quick Start Dialog");
        Ensure.ensureArgumentNotNull(application);
        this.application = application;
    }

    @Override
    protected void execute(Component parentComponent) {
        this.performQuickStart(parentComponent);
    }

    public void performQuickStart(Component parentComponent) {
        final IQuickStartItem[] items = new IQuickStartItem[]{new TextEditorQuickStartItem(), new Image2AsciiQuickStartItem(), new FigletEditorQuickStartItem(), new WatermarkQuickStartItem(), new AnimationEditorQuickStartItem()};
        final ObjectModel selectionModel = new ObjectModel();
        AbstractDialogPage page = new AbstractDialogPage("Below is a list of the most popular features in JavE. Please select what you want to do."){

            @Override
            public IBasicMessage createCurrentMessage() {
                return this.getDefaultMessage();
            }

            @Override
            public JComponent createContent() {
                MouseActiveListPanelBuilder<IQuickStartItem> builder = new MouseActiveListPanelBuilder<IQuickStartItem>(new IClickHandler<IQuickStartItem>(){

                    @Override
                    public void handleClick(IQuickStartItem item) {
                        selectionModel.setValue(item);
                        this.fireRequestFinish();
                    }
                });
                for (IQuickStartItem item : items) {
                    builder.add(this.createItemPanel(item), item);
                }
                return builder.createComponent();
            }

            private JComponent createItemPanel(IQuickStartItem item) {
                JLabel nameLabel = new JLabel(item.getName());
                nameLabel.setFont(new Font("SansSerif", 1, 13));
                JPanel rightPanel = new JPanel(new GridDialogLayout(1, false));
                rightPanel.add(nameLabel);
                AutoWrappingLabel descriptionLabel = new AutoWrappingLabel(item.getDescription());
                descriptionLabel.setEnabled(false);
                rightPanel.add((Component)descriptionLabel.getContent(), GridDialogLayoutData.FILL_BOTH);
                JPanel panel = new JPanel(new GridDialogLayout(2, false));
                panel.add(new JLabel(item.getIcon()));
                panel.add((Component)rightPanel, GridDialogLayoutData.FILL_BOTH);
                return panel;
            }

            @Override
            public String getTitle() {
                return "Quick Start";
            }
        };
        UserDialog dialog = new UserDialog(parentComponent, new DefaultDialogConfiguration<IDialogPage>((IDialogPage)page, DialogButtonConfigurationFactory.createCloseOnly()){

            @Override
            public Icon getLargeDialogIcon() {
                return QuickStartIcons.LARGE_DIALOG_ICON;
            }

            @Override
            public JComponent createOptionalButtonPanelLeftComponent() {
                return QuickStartAction.createShowQuickStartCheckBox(QuickStartAction.this.application.getApplicationPreferences());
            }
        });
        dialog.show();
        IQuickStartItem item = (IQuickStartItem)selectionModel.getValue();
        if (item == null) {
            return;
        }
        item.perform(this.application);
    }

    public static JCheckBox createShowQuickStartCheckBox(final JaveApplicationPreferences preferences) {
        final JCheckBox checkBox = new JCheckBox("Show Quick Start dialog on startup", preferences.isShowQuickStartOnStartup());
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                preferences.setShowQuickStartOnStartup(checkBox.isSelected());
            }
        });
        return checkBox;
    }
}

