/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.actions.preferences;

import de.jave.jave.actions.preferences.IJavePreferencesPanel;
import de.jave.jave.preferences.JaveApplicationPreferences;
import de.jave.jave.preferences.PlatePreferences;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;
import net.disy.commons.swing.layout.grid.GridDialogLayoutDataFactory;

public class TextEditorPreferencesPanel
implements IJavePreferencesPanel {
    private final JComponent content;
    private final JaveApplicationPreferences preferences;
    private final PlatePreferences platePreferences;
    private final JCheckBox autoResizeCheckBox;
    private final SpinnerNumberModel defaultWidthModel;
    private final SpinnerNumberModel defaultHeightModel;

    public TextEditorPreferencesPanel(JaveApplicationPreferences preferences, PlatePreferences platePreferences) {
        Ensure.ensureArgumentNotNull(preferences);
        Ensure.ensureArgumentNotNull(platePreferences);
        this.preferences = preferences;
        this.platePreferences = platePreferences;
        this.defaultWidthModel = new SpinnerNumberModel(preferences.getDefaultDocumentSize().width, 10, 100, 1);
        this.defaultHeightModel = new SpinnerNumberModel(preferences.getDefaultDocumentSize().height, 10, 100, 1);
        this.autoResizeCheckBox = new JCheckBox("Auto expand when dropping selection", platePreferences.isAutoResizeOnDropForTextEditor());
        JPanel panel = new JPanel(new GridDialogLayout(2, false));
        panel.add((Component)new JLabel("Default document width:"), GridDialogLayoutData.RIGHT);
        panel.add(new JSpinner(this.defaultWidthModel));
        panel.add((Component)new JLabel("Default document height:"), GridDialogLayoutData.RIGHT);
        panel.add(new JSpinner(this.defaultHeightModel));
        panel.add((Component)this.autoResizeCheckBox, GridDialogLayoutDataFactory.createHorizontalSpanData(2));
        this.content = panel;
    }

    @Override
    public JComponent getContent() {
        return this.content;
    }

    @Override
    public String getTitle() {
        return "Text Editor";
    }

    @Override
    public void savePreferences() {
        this.preferences.setDefaultDocumentSize(new Dimension(this.defaultWidthModel.getNumber().intValue(), this.defaultHeightModel.getNumber().intValue()));
        this.platePreferences.setAutoResizeOnDropForTextEditor(this.autoResizeCheckBox.isSelected());
    }
}

