/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.actions;

import de.jave.image2ascii.IImage2AsciiResultTaker;
import de.jave.jave.JavEApplication;
import de.jave.jave.actions.CamelizerAction;
import de.jave.jave.actions.ClipartLibraryAction;
import de.jave.jave.actions.CopyAction;
import de.jave.jave.actions.CutAction;
import de.jave.jave.actions.Image2AsciiAction;
import de.jave.jave.actions.MathematicalExpressionsAction;
import de.jave.jave.actions.NewAnimationAction;
import de.jave.jave.actions.PasteAsNewDocumentAction;
import de.jave.jave.actions.PasteAsNewSelectionAction;
import de.jave.jave.actions.ResizeDocumentAction;
import de.jave.jave.actions.SaveAction;
import de.jave.jave.actions.SaveAllAction;
import de.jave.jave.actions.SaveAsAction;
import de.jave.jave.actions.ShowFigletEditorAction;
import de.jave.jave.actions.TextBoxAction;
import de.jave.jave.actions.export.ExportTextAction;
import de.jave.jave.actions.quickstart.QuickStartAction;
import de.jave.jave.icon.JaveIcons;
import de.jave.jave.plate.JaveMainPanel;
import de.jave.jave.preferences.AnimationExportPreferences;
import de.jave.jave.preferences.ColorScheme;
import de.jave.jave.preferences.PlatePreferences;
import de.jave.jave.watermark.WatermarkImageFile;
import de.jave.lib.CharacterPlate;
import de.jave.preferences.JavePreferences;
import java.awt.Component;
import javax.swing.KeyStroke;
import net.disy.commons.core.io.FileModel;
import net.disy.commons.core.model.BooleanModel;
import net.disy.commons.core.model.ObjectModel;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.action.SmartToggleAction;
import net.disy.commons.swing.fontchooser.model.FontModel;

public class JaveActions {
    private final SmartAction newDocumentAction;
    private final SmartAction browseAction;
    private final SmartAction openAction;
    private final SmartAction aboutAction;
    private final CamelizerAction camelizerAction;
    private final SmartAction fractalAction;
    private final SmartAction newAnimationAction;
    private final Image2AsciiAction image2AsciiAction;
    private final SmartToggleAction toolOptionsDialogToggleAction;
    private final SmartToggleAction gridToggleAction;
    private final SmartToggleAction markIllegalToggleAction;
    private final SmartToggleAction connectedLinesViewToggleAction;
    private final SmartToggleAction rulerToggleAction;
    private final ShowFigletEditorAction figletAction;
    private final ResizeDocumentAction resizeAction;
    private final ClipartLibraryAction clipartLibraryAction;
    private final SmartAction mathematicalExpressionsAction;
    private final SmartAction textBoxAction;
    private final SmartAction saveAction;
    private final SmartAction saveAllAction;
    private final SmartAction saveAsAction;
    private final SmartAction quickStartAction;
    private final SmartAction exportAction;
    private final SmartAction copyAction;
    private final SmartAction cutAction;
    private final SmartAction pasteAsNewSelectionAction;
    private final SmartAction pasteAsNewDocumentAction;

    public JaveActions(final @Deprecated JavEApplication jave, JavePreferences preferences, BooleanModel toolOptionsDialogVisibilityModel, PlatePreferences plateViewOptions, FontModel displayFontModel, ObjectModel<ColorScheme> defaultColorSchemeModel) {
        Ensure.ensureArgumentNotNull(displayFontModel);
        Ensure.ensureArgumentNotNull(defaultColorSchemeModel);
        Ensure.ensureArgumentNotNull(preferences);
        FileModel currentDirectoryModel = jave.getApplicationPreferences().getCurrectDirectoryModel();
        JaveMainPanel mainPanel = jave.getMainPanel();
        this.copyAction = new CopyAction(mainPanel);
        this.cutAction = new CutAction(mainPanel);
        this.pasteAsNewSelectionAction = new PasteAsNewSelectionAction(mainPanel, jave);
        this.pasteAsNewDocumentAction = new PasteAsNewDocumentAction(mainPanel, jave);
        this.exportAction = new ExportTextAction(mainPanel, currentDirectoryModel, displayFontModel);
        this.quickStartAction = new QuickStartAction(jave);
        this.saveAction = new SaveAction(jave, mainPanel);
        this.resizeAction = new ResizeDocumentAction(jave);
        this.newDocumentAction = new SmartAction("New Document", JaveIcons.NEW_DOCUMENT_ICON){

            @Override
            protected void execute(Component parentComponent) {
                jave.doNew();
            }
        };
        this.newDocumentAction.setToolTipText("Create a new Document");
        this.newDocumentAction.setAcceleratorKey(KeyStroke.getKeyStroke(78, 128));
        this.image2AsciiAction = new Image2AsciiAction(new IImage2AsciiResultTaker(){

            @Override
            public void takeImage2AsciiResult(CharacterPlate characterPlate, WatermarkImageFile imageFile) {
                jave.pasteAsNewDocument(characterPlate);
                if (imageFile != null) {
                    jave.setWatermarkImage(imageFile);
                }
            }
        }, mainPanel, currentDirectoryModel, displayFontModel, defaultColorSchemeModel, new AnimationExportPreferences(preferences));
        this.figletAction = new ShowFigletEditorAction(jave, mainPanel, preferences);
        this.browseAction = new SmartAction("Browse...", JaveIcons.BROWSE_ICON){

            @Override
            protected void execute(Component parentComponent) {
                jave.doBrowse();
            }
        };
        this.browseAction.setToolTipText("Browse ASCII Files");
        this.browseAction.setAcceleratorKey(KeyStroke.getKeyStroke(66, 128));
        this.openAction = new SmartAction("Open...", JaveIcons.OPEN_ICON){

            @Override
            protected void execute(Component parentComponent) {
                jave.doOpen(parentComponent);
            }
        };
        this.openAction.setToolTipText("Open an ASCII File");
        this.openAction.setAcceleratorKey(KeyStroke.getKeyStroke(79, 128));
        this.aboutAction = new SmartAction("About JavE", JaveIcons.JAVE_ICON){

            @Override
            protected void execute(Component parentComponent) {
                jave.showAboutDialog();
            }
        };
        this.aboutAction.setToolTipText("About JavE");
        this.camelizerAction = new CamelizerAction(mainPanel, currentDirectoryModel);
        this.fractalAction = new SmartAction("Fractals", JaveIcons.FRACTAL_ICON){

            @Override
            protected void execute(Component parentComponent) {
                jave.doFractal();
            }
        };
        this.newAnimationAction = new NewAnimationAction(jave);
        this.toolOptionsDialogToggleAction = new SmartToggleAction(toolOptionsDialogVisibilityModel, "Tool Options Dialog", JaveIcons.TOOL_DIALOG_VISIBLE_ICON);
        this.toolOptionsDialogToggleAction.setToolTipText("Show/Hide Tool Options Dialog");
        this.gridToggleAction = new SmartToggleAction(plateViewOptions.getGridVisibilityModel(), "Grid", JaveIcons.GRID_VISIBLE_ICON);
        this.gridToggleAction.setAcceleratorKey(KeyStroke.getKeyStroke(71, 128));
        this.markIllegalToggleAction = new SmartToggleAction(plateViewOptions.getMarkIllegalModel(), "Mark illegal characters", JaveIcons.PURE_ASCII_ICON);
        this.connectedLinesViewToggleAction = new SmartToggleAction(plateViewOptions.getConnectedLinesViewModel(), "Connected Lines View", JaveIcons.CONNECTED_LINES_VIEW_ICON);
        this.rulerToggleAction = new SmartToggleAction(plateViewOptions.getRulerModel(), "Rulers", JaveIcons.RULER_ICON);
        this.clipartLibraryAction = new ClipartLibraryAction(jave, mainPanel);
        this.mathematicalExpressionsAction = new MathematicalExpressionsAction(jave, mainPanel);
        this.textBoxAction = new TextBoxAction(jave, mainPanel);
        this.saveAllAction = new SaveAllAction(jave, mainPanel);
        this.saveAsAction = new SaveAsAction(jave, mainPanel);
    }

    public SmartAction getExportAction() {
        return this.exportAction;
    }

    public SmartAction getNewDocumentAction() {
        return this.newDocumentAction;
    }

    public SmartAction getBrowseAction() {
        return this.browseAction;
    }

    public SmartAction getOpenAction() {
        return this.openAction;
    }

    public SmartAction getAboutAction() {
        return this.aboutAction;
    }

    public CamelizerAction getCamelizerAction() {
        return this.camelizerAction;
    }

    public SmartAction getNewAnimationAction() {
        return this.newAnimationAction;
    }

    public SmartAction getFractalAction() {
        return this.fractalAction;
    }

    public SmartToggleAction getToolOptionsDialogToggleAction() {
        return this.toolOptionsDialogToggleAction;
    }

    public SmartToggleAction getGridToggleAction() {
        return this.gridToggleAction;
    }

    public SmartToggleAction getMarkIllegalToggleAction() {
        return this.markIllegalToggleAction;
    }

    public SmartToggleAction getConnectedLinesViewToggleAction() {
        return this.connectedLinesViewToggleAction;
    }

    public SmartToggleAction getRulerToggleAction() {
        return this.rulerToggleAction;
    }

    public Image2AsciiAction getImage2AsciiAction() {
        return this.image2AsciiAction;
    }

    public ShowFigletEditorAction getFigletAction() {
        return this.figletAction;
    }

    public ResizeDocumentAction getResizeAction() {
        return this.resizeAction;
    }

    public ClipartLibraryAction getClipartLibraryAction() {
        return this.clipartLibraryAction;
    }

    public SmartAction getMathematicalExpressionsAction() {
        return this.mathematicalExpressionsAction;
    }

    public SmartAction getTextBoxAction() {
        return this.textBoxAction;
    }

    public SmartAction getSaveAction() {
        return this.saveAction;
    }

    public SmartAction getSaveAllAction() {
        return this.saveAllAction;
    }

    public SmartAction getSaveAsAction() {
        return this.saveAsAction;
    }

    public SmartAction getQuickStartAction() {
        return this.quickStartAction;
    }

    public SmartAction getCopyAction() {
        return this.copyAction;
    }

    public SmartAction getCutAction() {
        return this.cutAction;
    }

    public SmartAction getPasteAsNewSelectionAction() {
        return this.pasteAsNewSelectionAction;
    }

    public SmartAction getPasteAsNewDocumentAction() {
        return this.pasteAsNewDocumentAction;
    }
}

