/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.GenericTool;
import de.jave.jave.JavEApplication;
import de.jave.jave.Point2d;
import de.jave.jave.algorithm.fill.FillAlgorithm;
import de.jave.jave.algorithm.fill.FillMatchMode;
import de.jave.jave.icon.JaveIcons;
import de.jave.jave.pixelplate.PixelPlate;
import de.jave.jave.plate.JaveMainPanel;
import de.jave.jave.preferences.ColorScheme;
import de.jave.jave.rendering.PixelPlateRenderer;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import net.disy.commons.swing.mousecursor.CursorId;
import net.disy.commons.swing.mousecursor.CursorProvider;

public class RectangleToolGeneric
extends GenericTool {
    private Point point1;
    private Point point2;
    private JCheckBox cbFill;

    public RectangleToolGeneric(JaveMainPanel mainPanel, JavEApplication asciiPainter) {
        super(mainPanel, asciiPainter);
    }

    @Override
    public String getName() {
        return "Rectangle Generic";
    }

    @Override
    public Icon getIcon() {
        return JaveIcons.TOOL_RECTANGLE_GENERIC_ICON;
    }

    @Override
    public JComponent getAdditionalOptionsComponent() {
        if (this.cbFill == null) {
            this.cbFill = new JCheckBox("Fill", false);
        }
        return this.cbFill;
    }

    @Override
    public void mousePressed(Point point, Point location, MouseEvent evt) {
        if (location == null) {
            return;
        }
        this.point1 = point;
        this.point2 = point;
        this.markPlate = new PixelPlate(location.x - 10, location.y - 10, 20, 20);
        pixelPlateOptionsPanel.configure(this.markPlate);
        this.markPlate.setCharacter(this.getMouseChar());
        this.repaintCursor();
    }

    @Override
    public void mouseDragged(Point point, Point location, MouseEvent evt) {
        if (this.point1 == null || this.point2 == null || this.markPlate == null) {
            return;
        }
        this.point2 = point;
        this.repaintCursor();
    }

    @Override
    public void mouseReleased(Point point, Point location, MouseEvent evt) {
        if (this.point1 == null || this.point2 == null) {
            return;
        }
        this.point1 = null;
        this.point2 = null;
        if (this.markPlate != null) {
            this.setMixMode(this.isMix());
            this.markPlate.pasteResultInto(this.getPlate().getContent());
            this.saveCurrentState("rectangle");
            this.repaintAll();
            this.markPlate = null;
        }
    }

    @Override
    public void keyPressed(int code, KeyEvent evt) {
        if (this.markPlate == null) {
            return;
        }
        if (code == 27 && this.point1 != null) {
            this.point1 = null;
            this.point2 = null;
            this.markPlate = null;
            this.repaintCursor();
        }
    }

    @Override
    public void paintCursorFeature(Graphics2D g, Point plateOrigin, ColorScheme colorScheme) {
        if (this.point1 == null) {
            return;
        }
        g.setColor(colorScheme.getColorToolHelping());
        g.drawRect(this.point1.x - 2, this.point1.y - 2, 5, 5);
        if (this.point2 == null) {
            return;
        }
        g.drawRect(this.point2.x - 2, this.point2.y - 2, 5, 5);
        Point point3 = RectangleToolGeneric.getQuadraticPointFor(this.point1, this.point2, shiftDown);
        Point2d p1 = this.getPlate().getRealLocationForScreenPoint(this.point1);
        Point2d p2 = this.getPlate().getRealLocationForScreenPoint(point3);
        this.markPlate.clear();
        boolean fill = this.cbFill.isSelected();
        if (fill && !this.isLineMode()) {
            this.markPlate.fillRectangle(p1, p2);
        } else {
            this.markPlate.drawRectangle(p1, p2);
        }
        this.markPlate.convert();
        if (fill && this.isLineMode() && Math.abs(p2.getX() - p1.getX()) >= 1.0 && Math.abs(p2.getY() - p1.getY()) >= 1.0) {
            FillAlgorithm.fillSolid(this.markPlate.getCharacterPlate(), (int)((p1.getX() + p2.getX()) / 2.0) - this.markPlate.getOriginX(), (int)((p1.getY() + p2.getY()) / 2.0) - this.markPlate.getOriginY(), '\u00a0', FillMatchMode.EQUAL_CHARACTER);
        }
        PixelPlateRenderer.paint(g, this.getPlate(), colorScheme, this.debug, this.markPlate, plateOrigin);
    }

    @Override
    public void takeToHand() {
        this.setCursor(CursorProvider.getInstance().getCursor(CursorId.CROSSHAIR_SELECTION));
        this.point1 = null;
        this.point2 = null;
    }

    @Override
    public void putAside(boolean nextToolIsSelectionTool) {
        this.point1 = null;
        this.point2 = null;
    }
}

