/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.ICharacterDrawable;
import de.jave.jave.LineAlgorithm;
import java.awt.Point;

public class EllipseAlgorithm {
    public static void drawEllipse(ICharacterDrawable plate, Point centerLocation, int radiusX, int radiusY, char ch) {
        EllipseAlgorithm.drawEllipse(plate, centerLocation.x, centerLocation.y, radiusX, radiusY, ch);
    }

    public static void drawEllipse(ICharacterDrawable plate, int oX, int oY, int radiusX, int radiusY, char ch) {
        if (radiusX == 0) {
            LineAlgorithm.drawLineBresenham(plate, oX, oY - radiusY, oX, oY + radiusY, ch);
            return;
        }
        if (radiusY == 0) {
            LineAlgorithm.drawLineBresenham(plate, oX - radiusX, oY, oX + radiusX, oY + radiusY, ch);
            return;
        }
        if (radiusY <= radiusX) {
            int x = 0;
            int y = radiusY;
            int xE = 0;
            int yE = radiusX * radiusX;
            int e = -yE / 2;
            int c = yE / radiusY;
            do {
                if (e <= 0) {
                    do {
                        plate.set(oX + x, oY + y, ch);
                        plate.set(oX - x, oY + y, ch);
                        plate.set(oX + x, oY - y, ch);
                        plate.set(oX - x, oY - y, ch);
                        ++x;
                    } while ((e += (xE += radiusY)) <= 0);
                } else {
                    plate.set(oX + x, oY + y, ch);
                    plate.set(oX - x, oY + y, ch);
                    plate.set(oX + x, oY - y, ch);
                    plate.set(oX - x, oY - y, ch);
                }
                e -= (yE -= c);
            } while (--y != 0);
            plate.set(oX + x, oY, ch);
            plate.set(oX - x, oY, ch);
        } else {
            int x = 0;
            int y = radiusX;
            int xE = 0;
            int yE = radiusY * radiusY;
            int e = -yE / 2;
            int c = yE / radiusX;
            do {
                if (e <= 0) {
                    do {
                        plate.set(oX + y, oY + x, ch);
                        plate.set(oX - y, oY + x, ch);
                        plate.set(oX + y, oY - x, ch);
                        plate.set(oX - y, oY - x, ch);
                        ++x;
                    } while ((e += (xE += radiusX)) <= 0);
                } else {
                    plate.set(oX + y, oY + x, ch);
                    plate.set(oX - y, oY + x, ch);
                    plate.set(oX + y, oY - x, ch);
                    plate.set(oX - y, oY - x, ch);
                }
                e -= (yE -= c);
            } while (--y != 0);
            plate.set(oX, oY + x, ch);
            plate.set(oX, oY - x, ch);
        }
    }
}

