/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.ascii.plate.CharacterMetrics;
import de.jave.jave.EraserTool;
import de.jave.jave.JavEApplication;
import de.jave.jave.MixCharactersPanel;
import de.jave.jave.icon.JaveIcons;
import de.jave.jave.plate.JaveMainPanel;
import de.jave.jave.preferences.ColorScheme;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.disy.commons.core.message.Message;
import net.disy.commons.core.message.MessageType;
import net.disy.commons.swing.dialog.message.MessageDialogFactory;

public class CloneTool
extends EraserTool {
    private int dx;
    private int dy;
    private Point cloneLocation;
    private boolean positionLocked = false;

    public CloneTool(JaveMainPanel plate, JavEApplication asciiPainter) {
        super(plate, asciiPainter);
    }

    @Override
    public JComponent createOptionsComponent() {
        JPanel optionsPanel = (JPanel)super.createOptionsComponent();
        optionsPanel.add(new MixCharactersPanel(this.getMixCharactersModel()).getContent());
        return optionsPanel;
    }

    @Override
    public String getName() {
        return "Clone Tool";
    }

    @Override
    public Icon getIcon() {
        return JaveIcons.TOOL_CLONE_BRUSH_ICON;
    }

    @Override
    public String getUndoRedoActionName() {
        return "clone";
    }

    @Override
    public void paintCursorFeature(Graphics2D g, Point plateOrigin, ColorScheme colorScheme) {
        char[][] brush = this.getBrush();
        if (this.cursorLocation == null) {
            return;
        }
        g.setColor(colorScheme.getColorTool());
        this.paintBrushBorder(g, brush, this.cursorLocation.x, this.cursorLocation.y);
        g.setColor(colorScheme.getColorToolHelping());
        int x0 = 0;
        int y0 = 0;
        if (!this.positionLocked && this.cloneLocation != null) {
            x0 = this.cloneLocation.x;
            y0 = this.cloneLocation.y;
        } else if (this.positionLocked) {
            x0 = this.cursorLocation.x - this.dx;
            y0 = this.cursorLocation.y - this.dy;
        } else {
            return;
        }
        this.paintBrushBorder(g, brush, x0, y0);
        g.setColor(colorScheme.getColorTool());
        int h = brush.length;
        int w = brush[0].length;
        int cx = (w - 1) / 2;
        int cy = (h - 1) / 2;
        Point p0 = this.getScreenPointFor(this.cursorLocation.x - cx, this.cursorLocation.y - cy);
        g.setColor(colorScheme.getColorToolDarker());
        CharacterMetrics characterMetrics = this.getPlate().getCharacterMetrics();
        int characterWidth = characterMetrics.getWidth();
        int ascent = characterMetrics.getAscent();
        int characterHeight = characterMetrics.getHeight();
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                char pixel = brush[y][x];
                if (pixel <= '\u0000') continue;
                int xx = x0 - cx + x;
                int yy = y0 - cy + y;
                if (!this.getPlate().isInside(xx, yy)) continue;
                g.drawString(String.valueOf(this.getPlate().getChar(xx, yy)), p0.x + x * characterWidth, p0.y + y * characterHeight + ascent);
            }
        }
    }

    @Override
    protected void paint(int x0, int y0) {
        if (this.cursorLocation == null || this.cloneLocation == null) {
            return;
        }
        char[][] brush = this.getBrush();
        int h = brush.length;
        int w = brush[0].length;
        int cx = (w - 1) / 2;
        int cy = (h - 1) / 2;
        this.setMixMode(this.isMix());
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                char pixel = brush[y][x];
                if (pixel <= '\u0000') continue;
                int xx = x0 - cx + x;
                int yy = y0 - cy + y;
                if (!this.getPlate().isInside(xx - this.dx, yy - this.dy)) continue;
                this.getPlate().setChar(xx, yy, this.getPlate().getChar(xx - this.dx, yy - this.dy));
            }
        }
        this.getPlate().repaint(50L);
    }

    @Override
    public void mousePressed(Point point, Point location, MouseEvent evt) {
        if (evt.isShiftDown() || evt.isMetaDown()) {
            this.positionLocked = false;
            this.cloneLocation = location;
            this.dx = 0;
            this.dy = 0;
            this.repaintCursor();
            return;
        }
        this.cursorLocation = location;
        if (this.cloneLocation == null) {
            this.explanationDialog();
            return;
        }
        if (!this.positionLocked) {
            this.positionLocked = true;
            this.dx = this.cursorLocation.x - this.cloneLocation.x;
            this.dy = this.cursorLocation.y - this.cloneLocation.y;
        }
        this.paint(location);
    }

    protected void explanationDialog() {
        MessageDialogFactory.showMessageDialog(this.jave.getFrame(), new Message("JavE - Clone Tool", "You must specify a clone source by right-clicking\nor clicking on the image with the shift key down\nbefore you can use the clone brush.", MessageType.INFORMATION));
    }
}

