/*
 * Decompiled with CFR 0.152.
 */
package de.jave.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import net.disy.commons.core.exception.UnreachableCodeReachedException;
import net.disy.commons.core.io.IOUtilities;

public class IOTools {
    private IOTools() {
    }

    public static URL toUrl(String name) {
        URL url = null;
        try {
            url = new URL(name);
        }
        catch (MalformedURLException e1) {
            url = IOTools.toURL(new File(name));
        }
        return url;
    }

    public static String toURLString(File file) {
        return IOTools.toURL(file).toExternalForm();
    }

    public static URL toURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new UnreachableCodeReachedException(e);
        }
    }

    public static boolean isZipped(File file) {
        return IOTools.isZipped(IOTools.toURL(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isZipped(URL url) {
        boolean bl;
        DataInputStream inputStream = null;
        try {
            inputStream = new DataInputStream(url.openStream());
            bl = inputStream.readByte() == 80 && inputStream.readByte() == 75 && inputStream.readByte() == 3 && inputStream.readByte() == 4;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                IOUtilities.close(inputStream);
                throw throwable;
            }
            IOUtilities.close(inputStream);
            return bl2;
        }
        IOUtilities.close(inputStream);
        return bl;
    }

    public static BufferedReader openPossiblyZipped(URL url) throws IOException {
        BufferedReader dis = null;
        if (IOTools.isZipped(url)) {
            try {
                DataInputStream datis = new DataInputStream(url.openStream());
                ZipInputStream zis = new ZipInputStream(datis);
                zis.getNextEntry();
                dis = new BufferedReader(new InputStreamReader(zis));
            }
            catch (ZipException e) {
                System.err.println("ZipException " + e);
                return null;
            }
        } else {
            dis = new BufferedReader(new InputStreamReader(url.openStream()));
        }
        return dis;
    }

    public static boolean move(String source, String destination) {
        return IOTools.move(new File(source), new File(destination));
    }

    public static boolean move(File source, File destination) {
        File destDir = new File(new File(destination.getParent()).getAbsolutePath());
        if (!destDir.exists() && !destDir.mkdirs()) {
            return false;
        }
        return source.renameTo(destination);
    }

    public static boolean copy(String sourceFileName, String destinationFileName) {
        return IOTools.copy(new File(sourceFileName), new File(destinationFileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(File sourceFile, File destinationFile) {
        int bufferSize = 262144;
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            int size;
            byte[] buf = new byte[262144];
            bis = new BufferedInputStream(new FileInputStream(sourceFile));
            bos = new BufferedOutputStream(new FileOutputStream(destinationFile));
            while ((size = bis.read(buf)) > -1) {
                ((BufferedOutputStream)bos).write(buf, 0, size);
            }
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException ioe) {}
        }
        return true;
    }
}

