/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii.tablecreation;

import de.jave.gui.io.AbstractSourceFilePanelConfiguration;
import de.jave.gui.io.IFileChooserConfiguration;
import de.jave.gui.io.ImageIOUtilities;
import de.jave.gui.io.SourceFilePanel;
import de.jave.image.greyscale.GreyscaleImageFactory;
import de.jave.image2ascii.AsciiGreyscaleTableWriter;
import de.jave.image2ascii.DynamicalGreyScaleTableCreator;
import de.jave.image2ascii.tablecreation.FieldBoundsFinder;
import de.jave.image2ascii.tablecreation.GreyScaleImageFieldComponent;
import de.jave.image2ascii.tablecreation.GreyScaleImageFieldData;
import de.jave.image2ascii.tablecreation.GreyScaleTableFromImageExtractor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.disy.commons.core.io.FileModel;
import net.disy.commons.core.message.Message;
import net.disy.commons.core.message.MessageType;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.dialog.message.MessageDialogFactory;
import net.disy.commons.swing.fontchooser.view.FontChooserDialog;
import net.disy.commons.swing.layout.util.ButtonPanelBuilder;
import net.disy.commons.swing.layout.util.LayoutUtilities;

public class GreyscaleTableConverter {
    private final JFrame frame;
    private final GreyScaleImageFieldData data = new GreyScaleImageFieldData();
    private GreyScaleImageFieldComponent component;
    private final SmartAction saveAction;
    private final SmartAction autoBoundsAction;
    private final SmartAction dynamicallyFromFontAction;
    private final FileModel imageFileModel = new FileModel();

    public GreyscaleTableConverter() {
        this.component = new GreyScaleImageFieldComponent(this.data);
        this.saveAction = new SmartAction("Save"){

            @Override
            protected void execute(Component parentComponent) {
                GreyscaleTableConverter.this.doSave();
            }
        };
        this.saveAction.setEnabled(false);
        this.autoBoundsAction = new SmartAction("Automatic Bounds"){

            @Override
            protected void execute(Component parentComponent) {
                GreyscaleTableConverter.this.data.setFieldBounds(new FieldBoundsFinder().computeFieldBounds(GreyscaleTableConverter.this.data.getImage()));
                GreyscaleTableConverter.this.computeGreyScaleTable();
            }
        };
        this.autoBoundsAction.setEnabled(false);
        this.dynamicallyFromFontAction = new SmartAction("Dynamically from font..."){

            @Override
            protected void execute(Component parentComponent) {
                FontChooserDialog dialog = new FontChooserDialog(parentComponent);
                dialog.show();
                Font font = dialog.getFont();
                if (font == null) {
                    return;
                }
                GreyscaleTableConverter.this.data.setGreyScaleTable(DynamicalGreyScaleTableCreator.createGreyscaleTable(font));
            }
        };
        this.dynamicallyFromFontAction.setEnabled(false);
        ButtonPanelBuilder builder = new ButtonPanelBuilder();
        builder.add(this.saveAction);
        builder.add(this.autoBoundsAction);
        builder.add(this.dynamicallyFromFontAction);
        JPanel buttonPanel = builder.createPanel();
        JScrollPane scrollPane = new JScrollPane(this.component);
        scrollPane.setPreferredSize(new Dimension(640, 400));
        this.frame = new JFrame();
        this.frame.setDefaultCloseOperation(3);
        this.frame.getContentPane().setLayout(new BorderLayout(LayoutUtilities.getComponentSpacing(), LayoutUtilities.getComponentSpacing()));
        FileModel currentDirectoryModel = new FileModel();
        final IFileChooserConfiguration fileChooserConfiguration = ImageIOUtilities.createImageOpenFileChooserConfiguration(currentDirectoryModel);
        AbstractSourceFilePanelConfiguration configuration = new AbstractSourceFilePanelConfiguration(){

            @Override
            public IFileChooserConfiguration getFileChooserConfiguration() {
                return fileChooserConfiguration;
            }

            @Override
            public String getLabel() {
                return "Image File:";
            }
        };
        SourceFilePanel sourceFilePanel = new SourceFilePanel(this.imageFileModel, configuration){

            @Override
            protected boolean performOpenFile(Component parentComponent, File file) {
                BufferedImage rawImage;
                try {
                    rawImage = ImageIO.read(file);
                }
                catch (IOException e) {
                    MessageDialogFactory.showMessageDialog(parentComponent, new Message("Unable to load image file.", e));
                    return false;
                }
                if (rawImage == null) {
                    MessageDialogFactory.showMessageDialog(parentComponent, new Message("Unable to load image file.", MessageType.ERROR));
                    return false;
                }
                GreyscaleTableConverter.this.frame.setTitle(file.getAbsolutePath());
                int width = rawImage.getWidth();
                int height = rawImage.getHeight();
                int[] pixels = new int[width * height];
                PixelGrabber pg = new PixelGrabber(rawImage, 0, 0, width, height, pixels, 0, width);
                try {
                    pg.grabPixels();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Internal Error: " + e.toString());
                }
                if ((pg.getStatus() & 0x80) != 0) {
                    throw new RuntimeException("Internal Error: Image fetch aborted or errored.");
                }
                GreyscaleTableConverter.this.data.setImage(new GreyscaleImageFactory().createGreyscaleImage(pixels, width, height));
                GreyscaleTableConverter.this.data.setGreyScaleTable(null);
                GreyscaleTableConverter.this.component.invalidate();
                GreyscaleTableConverter.this.frame.pack();
                System.out.println(width + "x" + height);
                GreyscaleTableConverter.this.data.setFieldBounds(new FieldBoundsFinder().computeFieldBounds(GreyscaleTableConverter.this.data.getImage()));
                GreyscaleTableConverter.this.computeGreyScaleTable();
                return true;
            }
        };
        this.frame.getContentPane().add((Component)sourceFilePanel.createPanel(), "North");
        this.frame.getContentPane().add((Component)scrollPane, "Center");
        this.frame.getContentPane().add((Component)buttonPanel, "South");
        this.component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (GreyscaleTableConverter.this.data.getFieldBounds() != null) {
                    int x = evt.getX();
                    int y = evt.getY();
                    if (GreyscaleTableConverter.this.data.getFieldBounds().getLeftOuterHandleRectangle().contains(x, y)) {
                        GreyscaleTableConverter.this.data.getFieldBounds().growLeft();
                        GreyscaleTableConverter.this.computeGreyScaleTable();
                    } else if (GreyscaleTableConverter.this.data.getFieldBounds().getLeftInnerHandleRectangle().contains(x, y)) {
                        GreyscaleTableConverter.this.data.getFieldBounds().shrinkLeft();
                        GreyscaleTableConverter.this.computeGreyScaleTable();
                    } else if (GreyscaleTableConverter.this.data.getFieldBounds().getRightOuterHandleRectangle().contains(x, y)) {
                        GreyscaleTableConverter.this.data.getFieldBounds().growRight();
                        GreyscaleTableConverter.this.computeGreyScaleTable();
                    } else if (GreyscaleTableConverter.this.data.getFieldBounds().getLeftInnerHandleRectangle().contains(x, y)) {
                        GreyscaleTableConverter.this.data.getFieldBounds().shrinkRight();
                        GreyscaleTableConverter.this.computeGreyScaleTable();
                    } else if (GreyscaleTableConverter.this.data.getFieldBounds().getTopInnerHandleRectangle().contains(x, y)) {
                        GreyscaleTableConverter.this.data.getFieldBounds().growTop();
                        GreyscaleTableConverter.this.computeGreyScaleTable();
                    } else if (GreyscaleTableConverter.this.data.getFieldBounds().getTopOuterHandleRectangle().contains(x, y)) {
                        GreyscaleTableConverter.this.data.getFieldBounds().shrinkTop();
                        GreyscaleTableConverter.this.computeGreyScaleTable();
                    } else if (GreyscaleTableConverter.this.data.getFieldBounds().getBottomOuterHandleRectangle().contains(x, y)) {
                        GreyscaleTableConverter.this.data.getFieldBounds().growBottom();
                        GreyscaleTableConverter.this.computeGreyScaleTable();
                    } else if (GreyscaleTableConverter.this.data.getFieldBounds().getBottomInnerHandleRectangle().contains(x, y)) {
                        GreyscaleTableConverter.this.data.getFieldBounds().shrinkBottom();
                        GreyscaleTableConverter.this.computeGreyScaleTable();
                    }
                }
            }
        });
    }

    public void show() {
        this.frame.pack();
        this.frame.setVisible(true);
        this.component.requestFocus();
    }

    public Dimension getPreferredSize() {
        if (this.data.getImage() != null) {
            return this.data.getImage().getSize();
        }
        return new Dimension(200, 100);
    }

    private void computeGreyScaleTable() {
        this.data.setGreyScaleTable(new GreyScaleTableFromImageExtractor().computeTables(this.data.getImage(), this.data.getFieldBounds()));
        this.saveAction.setEnabled(true);
        this.autoBoundsAction.setEnabled(true);
        this.dynamicallyFromFontAction.setEnabled(true);
        this.component.repaint();
    }

    private void doSave() {
        File imageFile = (File)this.imageFileModel.getValue();
        File parentFile = imageFile.getParentFile();
        String name = imageFile.getName();
        String newName = name.substring(0, name.length() - 4) + ".jgt";
        File outputFile = new File(parentFile, newName);
        try {
            AsciiGreyscaleTableWriter.write(this.data.getGreyScaleTable(), outputFile);
            System.out.println("Result saved to file " + outputFile.getAbsolutePath());
        }
        catch (IOException e) {
            System.err.println(e);
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        new GreyscaleTableConverter().show();
    }
}

