/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii.algorithm;

import de.jave.image.IValueRaster;
import de.jave.image.greyscale.GGreyscaleImage;
import de.jave.image.monochrome.GMonochromeImage;
import de.jave.image.monochrome.algorithm.EdgeReduction;
import de.jave.image2ascii.AsciiGreyscaleTable;
import de.jave.image2ascii.Image2AsciiAlgorithm;
import de.jave.image2ascii.algorithm.AlgorithmEdgeDetectOptionsModel;
import de.jave.image2ascii.algorithm.dialog.Image2AsciiAlgorithmEdgeDetectOptionsPanel;
import de.jave.jave.filter.Filter;
import de.jave.jave.filter.FilterMode;
import de.jave.jave.pixelplate.PixelPlate;
import de.jave.jave.pixelplate.PixelPlateMode;
import de.jave.lib.CharacterPlate;
import javax.swing.Icon;
import net.disy.commons.core.model.IChangeableModel;
import net.disy.commons.core.progress.ICancelable;
import net.disy.commons.core.progress.IProgressMonitor;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.component.IDisposableComponentContainer;

public class Image2AsciiAlgorithmEdgeDetect
extends Image2AsciiAlgorithm {
    private final AlgorithmEdgeDetectOptionsModel optionsModel = new AlgorithmEdgeDetectOptionsModel();

    @Override
    public IChangeableModel getOptionsModel() {
        return this.optionsModel;
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public void setSpecialChars(String specialCharacters) {
    }

    @Override
    public void setGreyscaleTable(AsciiGreyscaleTable greyscaleTable) {
    }

    @Override
    public String getName() {
        return "Edge Detection";
    }

    @Override
    public IDisposableComponentContainer createAdjustmentComponent() {
        return new Image2AsciiAlgorithmEdgeDetectOptionsPanel(this.optionsModel);
    }

    private boolean isHires() {
        return this.optionsModel.isHires();
    }

    @Override
    public int getVerticalPixelsPerChar() {
        if (this.isHires()) {
            return 4;
        }
        return 1;
    }

    @Override
    public int getHorizontalPixelsPerChar() {
        return this.isHires() ? 3 : 1;
    }

    @Override
    public boolean isMonochromeImageRequired() {
        return false;
    }

    @Override
    public CharacterPlate convert(IValueRaster raster, IProgressMonitor progressMonitor, ICancelable cancelable) throws InterruptedException {
        Ensure.ensureArgumentInstanceOf(raster, GGreyscaleImage.class);
        progressMonitor.beginTask("Converting...", 9);
        GGreyscaleImage originalImage = (GGreyscaleImage)raster;
        GGreyscaleImage laplaceFilteredImage = originalImage.filterLaplace();
        progressMonitor.worked(1);
        laplaceFilteredImage.invert();
        progressMonitor.worked(1);
        laplaceFilteredImage.applyHysteresisThreshold(160, 210, cancelable);
        GMonochromeImage thresholdedImage = laplaceFilteredImage.getThresholdedInstance();
        progressMonitor.worked(1);
        new EdgeReduction().perform(thresholdedImage);
        progressMonitor.worked(1);
        GMonochromeImage monochromeImage = (GMonochromeImage)thresholdedImage.getClone();
        progressMonitor.worked(1);
        monochromeImage.edgeDespecle();
        progressMonitor.worked(1);
        int width = monochromeImage.getWidth();
        int height = monochromeImage.getHeight();
        if (this.isHires()) {
            return this.convertHires(progressMonitor, monochromeImage, width, height);
        }
        return this.convertLowRes(progressMonitor, monochromeImage, width, height);
    }

    private CharacterPlate convertLowRes(IProgressMonitor progressMonitor, GMonochromeImage monochromeImage, int width, int height) {
        int[][] ps = monochromeImage.getPixels();
        char[][] ch = new char[height][width];
        progressMonitor.worked(1);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                ch[y][x] = ps[x][y] < 128 ? 35 : 32;
            }
        }
        Filter.init();
        progressMonitor.worked(1);
        Filter.filter(new CharacterPlate(ch), FilterMode.SOFT);
        progressMonitor.worked(1);
        return new CharacterPlate(ch);
    }

    private CharacterPlate convertHires(IProgressMonitor progressMonitor, GMonochromeImage monochromeImage, int width, int height) {
        PixelPlate plate = new PixelPlate(0, 0, width / 3, height / 4);
        plate.setMode(PixelPlateMode.PIXEL);
        int normalizingFactor = monochromeImage.getNormalizingFactor();
        double threshold = 128.0 / (double)normalizingFactor;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (!((double)monochromeImage.get(x, y) < threshold)) continue;
                plate.set(x, y);
            }
        }
        progressMonitor.worked(1);
        plate.convert();
        progressMonitor.worked(1);
        char[][] ch = plate.getResult().getContent();
        for (int y = 0; y < ch.length; ++y) {
            for (int x = 0; x < ch[0].length; ++x) {
                if (ch[y][x] != '\u0000') continue;
                ch[y][x] = 32;
            }
        }
        progressMonitor.worked(1);
        return new CharacterPlate(ch);
    }
}

