/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui;

import de.jave.internet.SwingBrowserLauncher;
import de.jave.lib.gui.GuiUtilities;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JComponent;

public class GHyperlink
extends JComponent
implements MouseListener {
    private URL url;
    private String label;
    private boolean pressed;
    public static final Color COLOR_LINK = Color.blue;
    public static final Color COLOR_LINK_PRESSED = new Color(0, 0, 160);
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    private int alignment = 0;

    public GHyperlink() {
        this((URL)null, "", 0);
    }

    public GHyperlink(int alignment) {
        this((URL)null, "", alignment);
    }

    public GHyperlink(String url) {
        this(url, 0);
    }

    public GHyperlink(String url, int alignment) {
        this.alignment = alignment;
        this.setURL(url);
        this.addMouseListener(this);
        this.pressed = false;
    }

    public void setURL(String url) {
        if (url == null || url.length() == 0) {
            this.url = null;
            this.label = "";
        } else {
            try {
                this.url = new URL(url);
                this.label = this.url.toExternalForm();
            }
            catch (MalformedURLException e) {
                this.label = e.toString();
            }
        }
        this.invalidate();
        Container parent = this.getParent();
        if (parent != null) {
            ((Component)parent).validate();
        }
        this.repaint();
    }

    public void setURL(String url, String label) {
        this.label = label;
        if (url == null || url.length() == 0) {
            this.url = null;
        } else {
            try {
                this.url = new URL(url);
            }
            catch (MalformedURLException e) {
                this.label = e.toString();
            }
        }
        this.invalidate();
        Container parent = this.getParent();
        if (parent != null) {
            ((Component)parent).validate();
        }
        this.repaint();
    }

    public GHyperlink(String url, String label) {
        this(url, label, 0);
    }

    public GHyperlink(String url, String label, int alignment) {
        this.alignment = alignment;
        this.label = label;
        this.setURL(url, label);
        this.addMouseListener(this);
        this.pressed = false;
    }

    public GHyperlink(URL url) {
        this(url, url.toExternalForm());
    }

    public GHyperlink(URL url, int alignment) {
        this(url, url.toExternalForm(), alignment);
    }

    public GHyperlink(URL url, String label) {
        this(url, label, 0);
    }

    public GHyperlink(URL url, String label, int alignment) {
        this.alignment = alignment;
        this.label = label;
        this.url = url;
        this.addMouseListener(this);
        this.pressed = false;
    }

    @Override
    public Dimension getPreferredSize() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int sw = fm.stringWidth(this.label);
        return new Dimension(sw + 3, 15);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    protected void paintComponent(Graphics g) {
        Dimension d;
        if (this.label == null || this.label.length() == 0) {
            return;
        }
        if (this.pressed) {
            g.setColor(COLOR_LINK_PRESSED);
        } else {
            g.setColor(COLOR_LINK);
        }
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int sw = fm.stringWidth(this.label);
        int x = 0;
        if (this.alignment == 0) {
            x = 1;
        } else if (this.alignment == 2) {
            d = this.getSize();
            x = d.width - sw;
        } else if (this.alignment == 1) {
            d = this.getSize();
            x = (d.width - sw) / 2;
        }
        int y = 11;
        Dimension d2 = this.getSize();
        g.drawString(this.label, x, y += (d2.height - 15 + 1) / 2);
        g.drawLine(x, y + 1, x + sw - 1, y + 1);
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (this.url != null) {
            this.pressed = true;
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        if (this.pressed) {
            this.pressed = false;
            this.repaint();
            Applet applet = GuiUtilities.getParentApplet(this);
            if (applet != null) {
                applet.getAppletContext().showDocument(this.url, "_blank");
            } else {
                try {
                    SwingBrowserLauncher.performLaunchBrowser((Component)GuiUtilities.getWindowForComponent(evt), this.url);
                }
                catch (SecurityException e) {
                    System.err.println(e);
                    return;
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        this.setCursor(Cursor.getDefaultCursor());
        if (this.pressed) {
            this.pressed = false;
            this.repaint();
        }
    }
}

