/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gfx;

import de.jave.gfx.DepthComparable;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Vector;

public class GfxUtilities {
    protected static final int TOP = 8;
    protected static final int BOTTOM = 4;
    protected static final int LEFT = 2;
    protected static final int RIGHT = 1;

    private GfxUtilities() {
    }

    public static double distance(Point p1, Point p2) {
        return Math.sqrt(Math.pow(p1.x - p2.x, 2.0) + Math.pow(p1.y - p2.y, 2.0));
    }

    public static double distance2(Point p1, Point p2) {
        return Math.pow(p1.x - p2.x, 2.0) + Math.pow(p1.y - p2.y, 2.0);
    }

    public static void drawDottedRectangle(Graphics g, Color color1, Color color2, Rectangle r) {
        GfxUtilities.drawDottedRectangle(g, color1, color2, r.x, r.y, r.width, r.height);
    }

    public static void drawDottedRectangle(Graphics g, Color color1, Color color2, int x, int y, int width, int height) {
        g.setColor(color1);
        g.drawRect(x, y, width, height);
        g.setColor(color2);
        GfxUtilities.drawDottedRectangle(g, x, y, width, height);
    }

    public static void drawDottedRectangle(Graphics g, Rectangle r) {
        GfxUtilities.drawDottedRectangle(g, r.x, r.y, r.width, r.height);
    }

    public static void drawDottedRectangle(Graphics g, int x, int y, int width, int height) {
        GfxUtilities.drawBrokenHorizontalLine(g, x, x + width, y, 1, 0);
        GfxUtilities.drawBrokenHorizontalLine(g, x, x + width, y + height, 1, 0);
        GfxUtilities.drawBrokenVerticalLine(g, x, y, y + height, 1, 0);
        GfxUtilities.drawBrokenVerticalLine(g, x + width, y, y + height, 1, 0);
    }

    public static void drawDottedLine(Graphics g, int x1, int y1, int x2, int y2) {
        GfxUtilities.drawBrokenLine(g, x1, y1, x2, y2, 1);
    }

    public static void drawDottedLine(Graphics g, Point p1, Point p2) {
        GfxUtilities.drawBrokenLine(g, p1, p2, 1);
    }

    public static void drawBrokenLine(Graphics g, Point p1, Point p2, int strokeLength) {
        GfxUtilities.drawBrokenLine(g, p1.x, p1.y, p2.x, p2.y, strokeLength);
    }

    public static void drawBrokenLine(Graphics g, int x1, int y1, int x2, int y2, int strokeLength) {
        GfxUtilities.drawBrokenLine(g, x1, y1, x2, y2, strokeLength, 0);
    }

    public static void drawBrokenLine(Graphics g, int x1, int y1, int x2, int y2, int strokeLength, int offset) {
        if (y2 == y1) {
            GfxUtilities.drawBrokenHorizontalLine(g, x1, x2, y1, strokeLength, offset);
            return;
        }
        if (x2 == x1) {
            GfxUtilities.drawBrokenVerticalLine(g, x1, y1, y2, strokeLength, offset);
            return;
        }
        double length = Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0));
        double dx = (double)(x2 - x1) / length * (double)strokeLength;
        double dy = (double)(y2 - y1) / length * (double)strokeLength;
        double cx = dx;
        double cy = dy;
        if (cx > 0.0) {
            cx -= 1.0;
        }
        if (cy > 0.0) {
            cy -= 1.0;
        }
        if (cx < 0.0) {
            cx += 1.0;
        }
        if (cy < 0.0) {
            cy += 1.0;
        }
        double l2 = length * length;
        double i = (double)offset / (double)strokeLength;
        while (Math.pow(i * dx + cx, 2.0) + Math.pow(i * dy + cy, 2.0) <= l2) {
            g.drawLine(x1 + (int)(i * dx), y1 + (int)(i * dy), x1 + (int)(i * dx + cx), y1 + (int)(i * dy + cy));
            i += 2.0;
        }
    }

    public static void drawBrokenHorizontalLine(Graphics g, int x1, int x2, int y1, int strokeLength, int offset) {
        int count = 0;
        int x = 0;
        for (x = x1; x <= x2; ++x) {
            int pos = (x + strokeLength * 2 - offset) % (strokeLength * 2);
            if (pos < strokeLength) {
                ++count;
                continue;
            }
            if (count <= 0) continue;
            g.drawLine(x - count, y1, x - 1, y1);
            count = 0;
        }
        if (count > 0) {
            g.drawLine(x - count, y1, x - 1, y1);
        }
    }

    public static void drawBrokenVerticalLine(Graphics g, int x1, int y1, int y2, int strokeLength, int offset) {
        int count = 0;
        int y = 0;
        for (y = y1; y <= y2; ++y) {
            int pos = (y + strokeLength * 2 - offset) % (strokeLength * 2);
            if (pos < strokeLength) {
                ++count;
                continue;
            }
            if (count <= 0) continue;
            g.drawLine(x1, y - count, x1, y - 1);
            count = 0;
        }
        if (count > 0) {
            g.drawLine(x1, y - count, x1, y - 1);
        }
    }

    public static void drawBrokenRectangle(Graphics g, Color color1, Color color2, Rectangle r) {
        GfxUtilities.drawBrokenRectangle(g, color1, color2, r.x, r.y, r.width, r.height);
    }

    public static void drawBrokenRectangle(Graphics g, Color color1, Color color2, int x, int y, int width, int height) {
        GfxUtilities.drawBrokenRectangle(g, color1, color2, x, y, width, height, 0);
    }

    public static void drawBrokenRectangle(Graphics g, Color color1, Color color2, int x, int y, int width, int height, int offset) {
        g.setColor(color1);
        g.drawRect(x, y, width, height);
        g.setColor(color2);
        GfxUtilities.drawBrokenRectangle(g, x, y, width, height, offset);
    }

    public static void drawBrokenRectangle(Graphics g, Rectangle r) {
        GfxUtilities.drawBrokenRectangle(g, r.x, r.y, r.width, r.height);
    }

    public static void drawBrokenRectangle(Graphics g, int x, int y, int width, int height) {
        GfxUtilities.drawBrokenRectangle(g, x, y, width, height, 0);
    }

    public static void drawBrokenRectangle(Graphics g, int x, int y, int width, int height, int offset) {
        GfxUtilities.drawBrokenHorizontalLine(g, x, x + width, y, 3, offset);
        GfxUtilities.drawBrokenHorizontalLine(g, x, x + width, y + height, 3, offset);
        GfxUtilities.drawBrokenVerticalLine(g, x, y, y + height, 3, offset);
        GfxUtilities.drawBrokenVerticalLine(g, x + width, y, y + height, 3, offset);
    }

    public static void drawBrokenLine(Graphics g, Point p1, Point p2) {
        GfxUtilities.drawBrokenLine(g, p1, p2, 3);
    }

    public static void drawBrokenLine(Graphics g, int x1, int y1, int x2, int y2) {
        GfxUtilities.drawBrokenLine(g, x1, y1, x2, y2, 3);
    }

    public static void paintArrow(Graphics g, Point p1, Point p2) {
        GfxUtilities.paintArrow(g, p1.x, p1.y, p2.x, p2.y);
    }

    public static void paintArrow(Graphics g, int x1, int y1, int x2, int y2) {
        double vx = x1 - x2;
        double vy = y1 - y2;
        double scale = Math.sqrt(vx * vx + vy * vy);
        double nx = -(vy /= scale) * 3.0;
        double ny = (vx /= scale) * 3.0;
        g.drawLine(x2, y2, x2 + (int)((vx *= 8.0) + nx), y2 + (int)((vy *= 8.0) + ny));
        g.drawLine(x2, y2, x2 + (int)(vx - nx), y2 + (int)(vy - ny));
    }

    public static void paintArrowFilled(Graphics g, Point p1, Point p2) {
        GfxUtilities.paintArrowFilled(g, p1.x, p1.y, p2.x, p2.y);
    }

    public static void paintArrowFilled(Graphics g, int x1, int y1, int x2, int y2) {
        double vx = x1 - x2;
        double vy = y1 - y2;
        double scale = Math.sqrt(vx * vx + vy * vy);
        double nx = -(vy /= scale) * 4.0;
        double ny = (vx /= scale) * 4.0;
        Polygon pol = new Polygon();
        pol.addPoint(x2, y2);
        pol.addPoint(x2 + (int)((vx *= 10.0) + nx), y2 + (int)((vy *= 10.0) + ny));
        pol.addPoint(x2 + (int)(vx - nx), y2 + (int)(vy - ny));
        g.fillPolygon(pol);
    }

    public static void paintArrowInheritance(Graphics g, Point p1, Point p2) {
        double vx = p1.x - p2.x;
        double vy = p1.y - p2.y;
        double scale = Math.sqrt(vx * vx + vy * vy);
        double nx = -(vy /= scale) * 7.0;
        double ny = (vx /= scale) * 7.0;
        int d1x = (int)((vx *= 14.0) + nx) + p2.x;
        int d1y = (int)((vy *= 14.0) + ny) + p2.y;
        int d2x = (int)(vx - nx) + p2.x;
        int d2y = (int)(vy - ny) + p2.y;
        g.drawLine(p2.x, p2.y, d1x, d1y);
        g.drawLine(p2.x, p2.y, d2x, d2y);
        g.drawLine(d1x, d1y, d2x, d2y);
        g.drawLine(p2.x + (int)vx, p2.y + (int)vy, p1.x, p1.y);
    }

    public static void paintArrowImplementation(Graphics g, Point p1, Point p2) {
        double vx = p1.x - p2.x;
        double vy = p1.y - p2.y;
        double scale = Math.sqrt(vx * vx + vy * vy);
        double nx = -(vy /= scale) * 7.0;
        double ny = (vx /= scale) * 7.0;
        g.drawLine(p2.x, p2.y, (int)((vx *= 14.0) + nx) + p2.x, (int)((vy *= 14.0) + ny) + p2.y);
        g.drawLine(p2.x, p2.y, (int)(vx - nx) + p2.x, (int)(vy - ny) + p2.y);
        GfxUtilities.drawBrokenLine(g, new Point(p2.x + (int)(vx / 7.0), p2.y + (int)(vy / 7.0)), p1, 5);
    }

    public static void quickSortDepth(Vector r) {
        GfxUtilities.qSort(r, 0, r.size() - 1);
    }

    private static void qSort(Vector a, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            DepthComparable mid = (DepthComparable)a.elementAt((lo0 + hi0) / 2);
            while (lo <= hi) {
                while (lo < hi0 && ((DepthComparable)a.elementAt(lo)).compareDepthTo(mid) > 0) {
                    ++lo;
                }
                while (hi > lo0 && ((DepthComparable)a.elementAt(hi)).compareDepthTo(mid) < 0) {
                    --hi;
                }
                if (lo > hi) continue;
                DepthComparable cache = (DepthComparable)a.elementAt(lo);
                a.setElementAt(a.elementAt(hi), lo);
                a.setElementAt(cache, hi);
                cache = null;
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                GfxUtilities.qSort(a, lo0, hi);
            }
            if (lo < hi0) {
                GfxUtilities.qSort(a, lo, hi0);
            }
        }
    }

    public static final boolean clipLine(Point p1, Point p2, Rectangle clip) {
        int yMin = clip.y;
        int yMax = clip.y + clip.height;
        int xMin = clip.x;
        int xMax = clip.x + clip.width;
        int i1 = GfxUtilities.computeOutCode(p1, xMin, xMax, yMin, yMax);
        int i2 = GfxUtilities.computeOutCode(p2, xMin, xMax, yMin, yMax);
        int x = 0;
        int y = 0;
        while (i1 != 0 || i2 != 0) {
            int out;
            if ((i1 & i2) != 0) {
                return false;
            }
            int n = out = i1 != 0 ? i1 : i2;
            if ((out & 8) > 0) {
                x = p1.x + (p2.x - p1.x) * (yMin - p1.y) / (p2.y - p1.y);
                y = yMin;
            } else if ((out & 4) > 0) {
                x = p1.x + (p2.x - p1.x) * (yMax - p1.y) / (p2.y - p1.y);
                y = yMax;
            } else if ((out & 1) > 0) {
                y = p1.y + (p2.y - p1.y) * (xMax - p1.x) / (p2.x - p1.x);
                x = xMax;
            } else if ((out & 2) > 0) {
                y = p1.y + (p2.y - p1.y) * (xMin - p1.x) / (p2.x - p1.x);
                x = xMin;
            }
            if (out == i1) {
                p1.x = x;
                p1.y = y;
                i1 = GfxUtilities.computeOutCode(p1, xMin, xMax, yMin, yMax);
                continue;
            }
            p2.x = x;
            p2.y = y;
            i2 = GfxUtilities.computeOutCode(p2, xMin, xMax, yMin, yMax);
        }
        return true;
    }

    protected static final int computeOutCode(Point p, int xMin, int xMax, int yMin, int yMax) {
        int out = 0;
        if (p.y < yMin) {
            out = 8;
        } else if (p.y > yMax) {
            out = 4;
        }
        if (p.x < xMin) {
            out += 2;
        } else if (p.x > xMax) {
            ++out;
        }
        return out;
    }

    public static final void drawArc(Graphics g, int oX, int oY, int radius, double angle, double arcAngle) {
        GfxUtilities.drawArc(g, oX, oY, radius, radius, angle, arcAngle);
    }

    public static final void drawArc(Graphics g, int oX, int oY, int radiusX, int radiusY, double angle, double arcAngle) {
        double endAngle;
        double startAngle;
        if ((double)radiusX == 0.0 || (double)radiusY == 0.0) {
            GfxUtilities.set(g, oX, oY, oX, oX, oY, oY);
            return;
        }
        if (arcAngle < 0.0) {
            angle += arcAngle;
            arcAngle = -arcAngle;
        }
        if ((angle %= 360.0) + arcAngle >= 270.0 && angle <= 360.0 || angle + arcAngle >= 630.0 && angle <= 720.0) {
            startAngle = angle - 270.0;
            endAngle = (angle + arcAngle) % 360.0;
            endAngle = endAngle < 270.0 ? 90.0 : (endAngle %= 270.0);
            if (startAngle < 0.0) {
                startAngle = 0.0;
            }
            if (endAngle < 0.0) {
                endAngle = 0.0;
            }
            if (startAngle > 90.0) {
                startAngle = 90.0;
            }
            if (endAngle > 90.0) {
                endAngle = 90.0;
            }
            if (endAngle < startAngle) {
                GfxUtilities.drawArcSE(g, oX, oY, radiusX, radiusY, 0.0, endAngle);
                GfxUtilities.drawArcSE(g, oX, oY, radiusX, radiusY, startAngle, 90.0);
            } else {
                GfxUtilities.drawArcSE(g, oX, oY, radiusX, radiusY, startAngle, endAngle);
            }
        }
        if (angle + arcAngle >= 180.0 && angle <= 270.0 || angle + arcAngle >= 540.0 && angle <= 630.0) {
            startAngle = angle - 180.0;
            endAngle = (angle + arcAngle) % 360.0;
            endAngle = endAngle < 180.0 ? 90.0 : (endAngle %= 180.0);
            if (startAngle < 0.0 || startAngle > 90.0) {
                startAngle = 0.0;
            }
            if (endAngle < 0.0) {
                endAngle = 0.0;
            }
            if (endAngle > 90.0) {
                endAngle = 90.0;
            }
            if (endAngle < startAngle) {
                GfxUtilities.drawArcSW(g, oX, oY, radiusX, radiusY, 0.0, endAngle);
                GfxUtilities.drawArcSW(g, oX, oY, radiusX, radiusY, startAngle, 90.0);
            } else {
                GfxUtilities.drawArcSW(g, oX, oY, radiusX, radiusY, startAngle, endAngle);
            }
        }
        if (angle + arcAngle >= 90.0 && angle <= 180.0 || angle + arcAngle >= 450.0 && angle <= 540.0) {
            startAngle = angle - 90.0;
            if (angle < 90.0) {
                startAngle = 0.0;
            } else if (angle > 180.0) {
                startAngle = 0.0;
            }
            endAngle = (angle + arcAngle) % 360.0;
            endAngle = endAngle > 180.0 ? 90.0 : (endAngle < 90.0 ? 90.0 : (endAngle %= 90.0));
            if (endAngle < startAngle) {
                GfxUtilities.drawArcNW(g, oX, oY, radiusX, radiusY, 0.0, endAngle);
                GfxUtilities.drawArcNW(g, oX, oY, radiusX, radiusY, startAngle, 90.0);
            } else {
                GfxUtilities.drawArcNW(g, oX, oY, radiusX, radiusY, startAngle, endAngle);
            }
        }
        if (angle + arcAngle >= 0.0 && angle <= 90.0 || angle + arcAngle >= 360.0 && angle <= 450.0) {
            startAngle = angle;
            endAngle = (angle + arcAngle) % 360.0;
            if (startAngle > 90.0) {
                startAngle = 0.0;
            }
            if (endAngle > 90.0) {
                endAngle = 90.0;
            }
            if (endAngle < startAngle) {
                GfxUtilities.drawArcNE(g, oX, oY, radiusX, radiusY, 0.0, endAngle);
                GfxUtilities.drawArcNE(g, oX, oY, radiusX, radiusY, startAngle, 90.0);
            } else {
                GfxUtilities.drawArcNE(g, oX, oY, radiusX, radiusY, startAngle, endAngle);
            }
        }
    }

    protected static final void drawArcSE(Graphics g, int oX, int oY, int radiusX, int radiusY, double startAngle, double endAngle) {
        int minX = oX;
        int maxX = oX + radiusX;
        int minY = oY;
        int maxY = oY + radiusY;
        if (startAngle > 0.0) {
            minX = oX + (int)((double)radiusX * Math.sin(startAngle / 180.0 * Math.PI));
            maxY = oY + (int)((double)radiusY * Math.cos(startAngle / 180.0 * Math.PI));
        }
        if (endAngle < 90.0) {
            maxX = oX + (int)((double)radiusX * Math.sin(endAngle / 180.0 * Math.PI));
            minY = oY + (int)((double)radiusY * Math.cos(endAngle / 180.0 * Math.PI));
        }
        Rectangle clip = g.getClipBounds();
        if (clip.x > minX) {
            minX = clip.x;
        }
        if (clip.x + clip.width < maxX) {
            maxX = clip.x + clip.width;
        }
        if (clip.y > minY) {
            minY = clip.y;
        }
        if (clip.y + clip.height < maxY) {
            maxY = clip.y + clip.height;
        }
        if (maxX < minX || maxY < minY) {
            return;
        }
        if (radiusY <= radiusX) {
            int x = 0;
            int y = radiusY;
            int xE = 0;
            int yE = radiusX * radiusX;
            int e = -yE / 2;
            int c = yE / radiusY;
            do {
                if (e <= 0) {
                    do {
                        GfxUtilities.set(g, oX + x, oY + y, minX, maxX, minY, maxY);
                        ++x;
                    } while ((e += (xE += radiusY)) <= 0);
                } else {
                    GfxUtilities.set(g, oX + x, oY + y, minX, maxX, minY, maxY);
                }
                e -= (yE -= c);
            } while (--y != 0);
            GfxUtilities.set(g, oX + x, oY, minX, maxX, minY, maxY);
        } else {
            int x = 0;
            int y = radiusX;
            int xE = 0;
            int yE = radiusY * radiusY;
            int e = -yE / 2;
            int c = yE / radiusX;
            do {
                if (e <= 0) {
                    do {
                        GfxUtilities.set(g, oX + y, oY + x, minX, maxX, minY, maxY);
                        ++x;
                    } while ((e += (xE += radiusX)) <= 0);
                } else {
                    GfxUtilities.set(g, oX + y, oY + x, minX, maxX, minY, maxY);
                }
                e -= (yE -= c);
            } while (--y != 0);
            GfxUtilities.set(g, oX, oY + x, minX, maxX, minY, maxY);
        }
    }

    protected static final void drawArcSW(Graphics g, int oX, int oY, int radiusX, int radiusY, double startAngle, double endAngle) {
        int minX = oX - radiusX;
        int maxX = oX;
        int minY = oY;
        int maxY = oY + radiusY;
        if (startAngle > 0.0) {
            minX = oX - (int)((double)radiusX * Math.cos(startAngle / 180.0 * Math.PI));
            minY = oY + (int)((double)radiusY * Math.sin(startAngle / 180.0 * Math.PI));
        }
        if (endAngle < 90.0) {
            maxX = oX - (int)((double)radiusX * Math.cos(endAngle / 180.0 * Math.PI));
            maxY = oY + (int)((double)radiusY * Math.sin(endAngle / 180.0 * Math.PI));
        }
        Rectangle clip = g.getClipBounds();
        if (clip.x > minX) {
            minX = clip.x;
        }
        if (clip.x + clip.width < maxX) {
            maxX = clip.x + clip.width;
        }
        if (clip.y > minY) {
            minY = clip.y;
        }
        if (clip.y + clip.height < maxY) {
            maxY = clip.y + clip.height;
        }
        if (maxX < minX || maxY < minY) {
            return;
        }
        if (radiusY <= radiusX) {
            int x = 0;
            int y = radiusY;
            int xE = 0;
            int yE = radiusX * radiusX;
            int e = -yE / 2;
            int c = yE / radiusY;
            do {
                if (e <= 0) {
                    do {
                        GfxUtilities.set(g, oX - x, oY + y, minX, maxX, minY, maxY);
                        ++x;
                    } while ((e += (xE += radiusY)) <= 0);
                } else {
                    GfxUtilities.set(g, oX - x, oY + y, minX, maxX, minY, maxY);
                }
                e -= (yE -= c);
            } while (--y != 0);
            GfxUtilities.set(g, oX - x, oY, minX, maxX, minY, maxY);
        } else {
            int x = 0;
            int y = radiusX;
            int xE = 0;
            int yE = radiusY * radiusY;
            int e = -yE / 2;
            int c = yE / radiusX;
            do {
                if (e <= 0) {
                    do {
                        GfxUtilities.set(g, oX - y, oY + x, minX, maxX, minY, maxY);
                        ++x;
                    } while ((e += (xE += radiusX)) <= 0);
                } else {
                    GfxUtilities.set(g, oX - y, oY + x, minX, maxX, minY, maxY);
                }
                e -= (yE -= c);
            } while (--y != 0);
            GfxUtilities.set(g, oX, oY + x, minX, maxX, minY, maxY);
        }
    }

    protected static final void drawArcNW(Graphics g, int oX, int oY, int radiusX, int radiusY, double startAngle, double endAngle) {
        int minX = oX - radiusX;
        int maxX = oX;
        int minY = oY - radiusY;
        int maxY = oY;
        if (startAngle > 0.0) {
            maxX = oX - (int)((double)radiusX * Math.sin(startAngle / 180.0 * Math.PI));
            minY = oY - (int)((double)radiusY * Math.cos(startAngle / 180.0 * Math.PI));
        }
        if (endAngle < 90.0) {
            minX = oX - (int)((double)radiusX * Math.sin(endAngle / 180.0 * Math.PI));
            maxY = oY - (int)((double)radiusY * Math.cos(endAngle / 180.0 * Math.PI));
        }
        Rectangle clip = g.getClipBounds();
        if (clip.x > minX) {
            minX = clip.x;
        }
        if (clip.x + clip.width < maxX) {
            maxX = clip.x + clip.width;
        }
        if (clip.y > minY) {
            minY = clip.y;
        }
        if (clip.y + clip.height < maxY) {
            maxY = clip.y + clip.height;
        }
        if (maxX < minX || maxY < minY) {
            return;
        }
        if (radiusY <= radiusX) {
            int x = 0;
            int y = radiusY;
            int xE = 0;
            int yE = radiusX * radiusX;
            int e = -yE / 2;
            int c = yE / radiusY;
            do {
                if (e <= 0) {
                    do {
                        GfxUtilities.set(g, oX - x, oY - y, minX, maxX, minY, maxY);
                        ++x;
                    } while ((e += (xE += radiusY)) <= 0);
                } else {
                    GfxUtilities.set(g, oX - x, oY - y, minX, maxX, minY, maxY);
                }
                e -= (yE -= c);
            } while (--y != 0);
        } else {
            int x = 0;
            int y = radiusX;
            int xE = 0;
            int yE = radiusY * radiusY;
            int e = -yE / 2;
            int c = yE / radiusX;
            do {
                if (e <= 0) {
                    do {
                        GfxUtilities.set(g, oX - y, oY - x, minX, maxX, minY, maxY);
                        ++x;
                    } while ((e += (xE += radiusX)) <= 0);
                } else {
                    GfxUtilities.set(g, oX - y, oY - x, minX, maxX, minY, maxY);
                }
                e -= (yE -= c);
            } while (--y != 0);
            GfxUtilities.set(g, oX, oY - x, minX, maxX, minY, maxY);
        }
    }

    protected static final void drawArcNE(Graphics g, int oX, int oY, int radiusX, int radiusY, double startAngle, double endAngle) {
        int minX = oX;
        int maxX = oX + radiusX;
        int minY = oY - radiusY;
        int maxY = oY;
        if (startAngle > 0.0) {
            maxX = oX + (int)((double)radiusX * Math.cos(startAngle / 180.0 * Math.PI));
            maxY = oY - (int)((double)radiusY * Math.sin(startAngle / 180.0 * Math.PI));
        }
        if (endAngle < 90.0) {
            minX = oX + (int)((double)radiusX * Math.cos(endAngle / 180.0 * Math.PI));
            minY = oY - (int)((double)radiusY * Math.sin(endAngle / 180.0 * Math.PI));
        }
        Rectangle clip = g.getClipBounds();
        if (clip.x > minX) {
            minX = clip.x;
        }
        if (clip.x + clip.width < maxX) {
            maxX = clip.x + clip.width;
        }
        if (clip.y > minY) {
            minY = clip.y;
        }
        if (clip.y + clip.height < maxY) {
            maxY = clip.y + clip.height;
        }
        if (maxX < minX || maxY < minY) {
            return;
        }
        if (radiusY <= radiusX) {
            int x = 0;
            int y = radiusY;
            int xE = 0;
            int yE = radiusX * radiusX;
            int e = -yE / 2;
            int c = yE / radiusY;
            do {
                if (e <= 0) {
                    do {
                        GfxUtilities.set(g, oX + x, oY - y, minX, maxX, minY, maxY);
                        ++x;
                    } while ((e += (xE += radiusY)) <= 0);
                } else {
                    GfxUtilities.set(g, oX + x, oY - y, minX, maxX, minY, maxY);
                }
                e -= (yE -= c);
            } while (--y != 0);
        } else {
            int x = 0;
            int y = radiusX;
            int xE = 0;
            int yE = radiusY * radiusY;
            int e = -yE / 2;
            int c = yE / radiusX;
            do {
                if (e <= 0) {
                    do {
                        GfxUtilities.set(g, oX + y, oY - x, minX, maxX, minY, maxY);
                        ++x;
                    } while ((e += (xE += radiusX)) <= 0);
                } else {
                    GfxUtilities.set(g, oX + y, oY - x, minX, maxX, minY, maxY);
                }
                e -= (yE -= c);
            } while (--y != 0);
            GfxUtilities.set(g, oX, oY - x, minX, maxX, minY, maxY);
        }
    }

    protected static final void set(Graphics g, int x, int y, int minX, int maxX, int minY, int maxY) {
        if (x < minX && y < minY || y > maxY && x > maxX || x < minX - 1 || x > maxX + 1 || y < minY - 1 || y > maxY + 1) {
            return;
        }
        g.drawLine(x, y, x, y);
    }
}

