/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet.swing.action;

import de.jave.figlet.engine.IFigDriver;
import de.jave.figlet.file.FigFileName;
import de.jave.figlet.file.IFigFileLibrary;
import de.jave.figlet.swing.action.CharacterRanking;
import de.jave.figlet.swing.action.FigLetFontSample;
import de.jave.figlet.swing.action.FontSampleInputDialogPage;
import de.jave.figlet.swing.action.RankedItem;
import de.jave.figlet.swing.ui.FigletIcons;
import de.jave.figlet.util.FigException;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import net.disy.commons.core.progress.ICancelable;
import net.disy.commons.core.progress.IInterruptableRunnableWithProgress;
import net.disy.commons.core.progress.IProgressMonitor;
import net.disy.commons.core.progress.ProgressUtilities;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.dialog.progress.ProgressMonitorDialog;
import net.disy.commons.swing.dialog.userdialog.DefaultDialogConfiguration;
import net.disy.commons.swing.dialog.userdialog.UserDialog;

public final class SearchFontBySampleAction
extends SmartAction {
    private static final String SAMPLE_TEXT = "abcdefghijklmnopqrstuvwxyz1234567890 a b c d e f g h i j k l m n o p q r s t u v w x y z ABCDEFGHIJKLMNOPQRSTUVWXYZ A B C D E F G H I J K L M N O P Q R S T U V W X Y Z";
    private final IFigDriver figDriver;
    private final File tmpFolder;

    public SearchFontBySampleAction(File tmpFolder, IFigDriver figDriver) {
        super(FigletIcons.DYNAMICALY_GENERATED_FONT_CATEGORY_ICON);
        Ensure.ensureArgumentNotNull(tmpFolder);
        Ensure.ensureArgumentNotNull(figDriver);
        this.tmpFolder = tmpFolder;
        this.figDriver = figDriver;
    }

    @Override
    protected void execute(Component parentComponent) {
        FontSampleInputDialogPage dialogPage = new FontSampleInputDialogPage();
        UserDialog userDialog = new UserDialog(parentComponent, new DefaultDialogConfiguration<FontSampleInputDialogPage>(dialogPage));
        userDialog.show();
        if (userDialog.isCanceled()) {
            return;
        }
        String searchSample = dialogPage.getSampleText();
        final CharacterRanking ranking = CharacterRanking.compile(searchSample);
        IFigFileLibrary fileLibrary = this.figDriver.getFileLibrary();
        final String[] fontNames = fileLibrary.getAllFontNames();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(parentComponent, "Create Samples");
        try {
            dialog.run(new IInterruptableRunnableWithProgress(){

                @Override
                public void run(IProgressMonitor monitor, ICancelable cancelable) throws InterruptedException, InvocationTargetException {
                    long time0 = System.currentTimeMillis();
                    SearchFontBySampleAction.this.createFontSamplesIfNeccessary(monitor, fontNames, cancelable);
                    monitor.beginTask("Comparing font samples", fontNames.length);
                    ArrayList<RankedItem<String>> rankedItems = new ArrayList<RankedItem<String>>();
                    for (String fontName : fontNames) {
                        ProgressUtilities.checkInterrupted(cancelable);
                        monitor.subTask(fontName);
                        try {
                            FigLetFontSample sample = FigLetFontSample.load(SearchFontBySampleAction.this.getSampleFile(fontName));
                            double rank = ranking.rank(sample);
                            rankedItems.add(new RankedItem<String>(rank, fontName));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        monitor.worked(1);
                    }
                    Collections.sort(rankedItems);
                    for (RankedItem rankedItem : rankedItems) {
                        System.err.println(rankedItem.getRank() + " " + (String)rankedItem.getValue());
                    }
                    long time1 = System.currentTimeMillis();
                    System.err.println(time1 - time0 + "ms");
                }
            });
        }
        catch (InterruptedException e) {
            return;
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
        }
    }

    private void createFontSamplesIfNeccessary(IProgressMonitor monitor, String[] fontNames, ICancelable cancelable) throws InterruptedException {
        monitor.beginTask("Creating font samples", fontNames.length);
        for (String fontName : fontNames) {
            ProgressUtilities.checkInterrupted(cancelable);
            monitor.subTask(fontName);
            try {
                File file = this.getSampleFile(fontName);
                if (!file.exists() || file.lastModified() < this.figDriver.getFileLibrary().getFileResource().getLastModified(new FigFileName(fontName))) {
                    FigLetFontSample sample = this.createFontSample(fontName);
                    sample.write(file);
                }
            }
            catch (FigException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            monitor.worked(1);
        }
    }

    private FigLetFontSample createFontSample(String fontName) throws FigException {
        String sampleText = this.figDriver.figletize(SAMPLE_TEXT, fontName);
        char[] characters = CharacterRanking.getContainedCharacters(sampleText);
        FigLetFontSample fontSample = new FigLetFontSample(characters, sampleText);
        return fontSample;
    }

    private File getSampleFile(String fontName) {
        File file = new File(this.tmpFolder, fontName + ".flfsample");
        return file;
    }
}

