/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet.file;

import de.jave.figlet.file.ClasspathFigFileResource;
import de.jave.figlet.file.FigFileName;
import de.jave.figlet.file.FigFontCategorization;
import de.jave.figlet.file.IFigFileLibrary;
import de.jave.figlet.file.IFigFileResource;
import de.jave.figlet.file.IFigFontCategorization;
import de.jave.figlet.file.IFigFontCategory;
import de.jave.figlet.io.FigCategoriesFileParser;
import de.jave.figlet.util.FigException;
import de.jave.lib.Toolbox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import net.disy.commons.core.util.Ensure;

public class FigFileLibrary
implements IFigFileLibrary {
    private IFigFileResource fileResource;
    private static final String FONT_DEFAULT = "standard";
    private String[] fontNames;
    private String defaultFontName;
    private String[] controlNames;
    private IFigFontCategorization categorization;

    private FigFileLibrary(IFigFileResource fileResource) {
        Ensure.ensureArgumentNotNull(fileResource);
        this.fileResource = fileResource;
    }

    private static FigFileName[] removeDuplicatesAndSort(FigFileName[] filenames) {
        HashSet<String> fontSet = new HashSet<String>();
        ArrayList<FigFileName> fileNameList = new ArrayList<FigFileName>();
        for (int i = 0; i < filenames.length; ++i) {
            if (fontSet.contains(filenames[i].getName())) continue;
            fontSet.add(filenames[i].getName());
            fileNameList.add(filenames[i]);
        }
        FigFileName[] resultFileNames = fileNameList.toArray(new FigFileName[fileNameList.size()]);
        Arrays.sort(resultFileNames, new Comparator(){

            public int compare(Object o1, Object o2) {
                String name1 = ((FigFileName)o1).getName().toLowerCase();
                String name2 = ((FigFileName)o1).getName().toLowerCase();
                return name1.compareTo(name2);
            }
        });
        return resultFileNames;
    }

    @Override
    public void initialize() throws FigException {
        this.fontNames = new String[0];
        this.controlNames = new String[0];
        FigFileName[] figletFileNames = this.fileResource.loadFigletFileNames();
        if (figletFileNames == null) {
            throw new FigException("Unable to load index file containing a list of all font/control files (" + this.fileResource.getRourceBaseDescription() + ")", 1);
        }
        figletFileNames = FigFileLibrary.removeDuplicatesAndSort(figletFileNames);
        int fontCount = 0;
        int controlCount = 0;
        for (int i = 0; i < figletFileNames.length; ++i) {
            if (figletFileNames[i].isFont()) {
                ++fontCount;
                continue;
            }
            if (!figletFileNames[i].isControlFile()) continue;
            ++controlCount;
        }
        if (fontCount == 0) {
            throw new FigException("Figlet font list empty (" + this.fileResource.getRourceBaseDescription() + ")", 3);
        }
        this.fontNames = new String[fontCount];
        this.controlNames = new String[controlCount];
        int i1 = 0;
        int i2 = 0;
        for (int i = 0; i < figletFileNames.length; ++i) {
            if (figletFileNames[i].isFont()) {
                this.fontNames[i1] = figletFileNames[i].getPrintName();
                if (i1 == 0 || this.fontNames[i1].equals(FONT_DEFAULT)) {
                    this.defaultFontName = this.fontNames[i1];
                }
                ++i1;
                continue;
            }
            if (!figletFileNames[i].isControlFile()) continue;
            this.controlNames[i2++] = figletFileNames[i].getPrintName();
        }
        Toolbox.quickSort(this.fontNames);
        Toolbox.quickSort(this.controlNames);
        try {
            this.categorization = new FigCategoriesFileParser().loadCategoriesFile(this.fontNames, this.fileResource, "categoriestree.txt");
        }
        catch (Exception e) {
            System.err.println("Error loading categoriestree.txt:" + e);
            try {
                this.categorization = new FigCategoriesFileParser().loadCategoriesFile(this.fontNames, this.fileResource, "categories.txt");
            }
            catch (Exception e2) {
                this.categorization = FigFontCategorization.createFallBackCategorization(this.fontNames);
                throw new FigException("No figlet font categories file found or wrong format (" + this.fileResource.getRourceBaseDescription() + ")", e, 4);
            }
        }
    }

    @Override
    public String[] getAllFontNames() {
        return this.fontNames;
    }

    @Override
    public String getDefaultFontName() {
        return this.defaultFontName;
    }

    @Override
    public IFigFontCategory getFontCategory(String categoryName) {
        return this.categorization.getChildCategory(categoryName);
    }

    public static void main(String[] args) throws FigException {
        ClasspathFigFileResource fileResource = new ClasspathFigFileResource();
        FigFileLibrary fm = FigFileLibrary.loadFileLibrary(fileResource);
        IFigFontCategory[] categories = fm.getFontCategorization().getAllNonEmptyCategories();
        for (int i = 0; i < categories.length; ++i) {
            IFigFontCategory cat = categories[i];
            System.err.println("# " + cat.getName());
            String[] names = cat.getFontNames();
            for (int j = 0; j < names.length; ++j) {
                System.err.println("   " + names[j]);
            }
        }
    }

    public static FigFileLibrary loadFileLibrary(IFigFileResource fileResource) throws FigException {
        FigFileLibrary fileLibrary = new FigFileLibrary(fileResource);
        fileLibrary.initialize();
        return fileLibrary;
    }

    @Override
    public IFigFileResource getFileResource() {
        return this.fileResource;
    }

    @Override
    public IFigFontCategorization getFontCategorization() {
        return this.categorization;
    }
}

