/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet.engine.primitives;

import de.jave.text.QuickString;

public class FigCharacter {
    private QuickString[] lines;
    private int characterCode;

    public FigCharacter(int characterCode, String[] lines) {
        this.characterCode = characterCode;
        this.lines = new QuickString[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            this.lines[i] = lines[i] == null ? new QuickString() : new QuickString(lines[i]);
        }
    }

    public QuickString getLine(int lineIndex) {
        return this.lines[lineIndex];
    }

    public int getHeight() {
        return this.lines.length;
    }

    public void dump() {
        System.out.println(this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int lineIndex = 0; lineIndex < this.getHeight(); ++lineIndex) {
            if (lineIndex > 0) {
                sb.append('\n');
            }
            sb.append(this.getLine(lineIndex));
        }
        return sb.toString();
    }

    public int getCharacterCode() {
        return this.characterCode;
    }

    public int getWidth() {
        int width = 0;
        for (int i = 0; i < this.lines.length; ++i) {
            int lineWidth = this.getRawWidth(this.lines[i]);
            if (lineWidth <= width) continue;
            width = lineWidth;
        }
        return width;
    }

    private int getRawWidth(QuickString string) {
        int width = string.length();
        int index = 0;
        while (index < string.length() && string.charAt(index) == '\u007f') {
            ++index;
            --width;
        }
        for (index = string.length() - 1; width > 0 && index >= 0 && string.charAt(index) == '\u007f'; --index, --width) {
        }
        return width;
    }
}

