/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet.engine;

import de.jave.figlet.engine.DefaultConversionContext;
import de.jave.figlet.engine.FigFontCache;
import de.jave.figlet.engine.FigmlToken;
import de.jave.figlet.engine.FigmlTokenizer;
import de.jave.figlet.engine.IFigConversionContext;
import de.jave.figlet.engine.IFigDriver;
import de.jave.figlet.engine.IFigFontLoader;
import de.jave.figlet.engine.IFigFontProvider;
import de.jave.figlet.engine.controlfile.FigControlFile;
import de.jave.figlet.engine.controlfile.FigControlFileList;
import de.jave.figlet.engine.layout.HorizontalAlignment;
import de.jave.figlet.engine.layout.VerticalAlignment;
import de.jave.figlet.engine.layouter.DefaultFigLayouter;
import de.jave.figlet.engine.layouter.IFigLayouter;
import de.jave.figlet.engine.output.AsciiOutputConverter;
import de.jave.figlet.engine.output.OutputFormat;
import de.jave.figlet.engine.primitives.FigFont;
import de.jave.figlet.engine.primitives.FigFragment;
import de.jave.figlet.engine.primitives.FigLayout;
import de.jave.figlet.engine.processing.FigletJobFactory;
import de.jave.figlet.engine.processing.IFigletJob;
import de.jave.figlet.file.FigFileLibrary;
import de.jave.figlet.file.FigFileName;
import de.jave.figlet.file.IFigFileLibrary;
import de.jave.figlet.file.IFigFileResource;
import de.jave.figlet.io.FigFontFileParser;
import de.jave.figlet.util.FigException;
import de.jave.lib.job.IWarningCollector;
import de.jave.lib.job.NullWarningCollector;
import de.jave.lib.net.HtmlUtilities;
import de.jave.text.QuickString;
import de.jave.text.TextTools;
import java.io.File;

public class FigDriver
implements IFigDriver {
    private final FigFileLibrary fileLibrary;
    public static final String PROGRAM_NAME = "FigletFIGML 0.1";
    public static final int LINE_LENGTH_DEFAULT = 80;
    private final IFigFontProvider cache;
    private FigFont font;
    private FigControlFileList controlFiles;
    private VerticalAlignment vAlign = VerticalAlignment.BOTTOM;
    private HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
    private IWarningCollector warner = new NullWarningCollector();

    public FigDriver(final IFigFileResource resource) throws FigException {
        this.fileLibrary = FigFileLibrary.loadFileLibrary(resource);
        IFigFontLoader fontLoader = new IFigFontLoader(){

            @Override
            public FigFont loadFont(String fontName) throws FigException {
                return new FigFontFileParser().load(new FigFileName(fontName), resource);
            }

            @Override
            public long getLastModificationTime(String fontName) throws FigException {
                return resource.getLastModified(new FigFileName(fontName));
            }
        };
        this.cache = new FigFontCache(fontLoader);
    }

    public IWarningCollector getWarningCollector() {
        return this.warner;
    }

    @Deprecated
    public void setFont(String name) throws FigException {
        FigFont f = this.getFont(name);
        this.font = f != null ? f : this.cache.getFont(this.fileLibrary.getDefaultFontName());
    }

    public void forceFontReload(String name, File file) throws FigException {
        FigFont f;
        try {
            f = new FigFontFileParser().readFont(new FigFileName(file.getAbsolutePath()), file);
        }
        catch (Exception e) {
            throw new FigException("Unable to load font from '" + file.getAbsolutePath() + "'", e);
        }
        this.font = f != null ? f : this.cache.getFont(this.fileLibrary.getDefaultFontName());
    }

    public String getFontComment(String name) throws FigException {
        FigFont f = this.getFont(name);
        if (f != null) {
            return f.getComments();
        }
        return "No such Font: '" + name + ".flf'";
    }

    public String getFontInfo(String name) throws FigException {
        FigFont f = this.getFont(name);
        if (f != null) {
            return f.getInfo();
        }
        return "No such Font: '" + name + ".flf'";
    }

    @Override
    public FigFont getFont(String name) throws FigException {
        return this.cache.getFont(name);
    }

    public String[] getFontInfos(String name) throws FigException {
        FigFont f = this.getFont(name);
        if (f != null) {
            return f.getInfos();
        }
        return null;
    }

    public int getFontHeight(String name) throws FigException {
        FigFont f = this.getFont(name);
        if (f != null) {
            return f.getHeight();
        }
        return 1;
    }

    public int getFontUnderLength(String name) throws FigException {
        FigFont f = this.getFont(name);
        if (f != null) {
            return f.getUnderLength();
        }
        return 0;
    }

    private void addControlFile(String name) {
        DefaultConversionContext context;
        FigControlFile fc;
        boolean succeed;
        if (this.controlFiles == null) {
            this.controlFiles = new FigControlFileList();
        }
        if (!(succeed = (fc = new FigControlFile(name)).load(context = new DefaultConversionContext(this.warner)))) {
            context.addWarning("Unable to load control file " + name + " - ignored.");
            return;
        }
        this.controlFiles.add(fc);
    }

    private void removeControlFile(String name) {
        boolean succeed = this.controlFiles.remove(name);
        if (!succeed) {
            this.warning("Trying to close control file " + name + " that has not been loaded - ignored.");
        }
    }

    private void removeAllControlFiles() {
        this.controlFiles = null;
    }

    private void setVAlignment(String a) {
        if ((a = a.toLowerCase()).equals("bottom")) {
            this.vAlign = VerticalAlignment.BOTTOM;
        } else if (a.equals("top")) {
            this.vAlign = VerticalAlignment.TOP;
        } else if (a.equals("center")) {
            this.vAlign = VerticalAlignment.CENTER;
        } else {
            System.err.println("Unbekannte Option f\u00fcr vertikales Alignment: " + a);
            this.vAlign = VerticalAlignment.BOTTOM;
        }
    }

    private void setHAlignment(String a) {
        if ((a = a.toLowerCase()).equals("left")) {
            this.horizontalAlignment = HorizontalAlignment.LEFT;
        } else if (a.equals("right")) {
            this.horizontalAlignment = HorizontalAlignment.RIGHT;
        } else if (a.equals("center")) {
            this.horizontalAlignment = HorizontalAlignment.CENTER;
        } else {
            System.err.println("Unbekannte Option f\u00fcr horizontales Alignment: " + a);
            this.horizontalAlignment = HorizontalAlignment.LEFT;
        }
    }

    private FigFragment figletizeRaw(String word, int maxLineLength, IFigLayouter layouter, IFigConversionContext context) {
        word = HtmlUtilities.decodeEntities(word);
        if (this.font == null) {
            System.err.println("FONT==NULL!!!!!");
        }
        FigFragment result = null;
        for (int i = 0; i < word.length(); ++i) {
            int ch;
            int buchstabe = ch = word.charAt(i);
            if (this.controlFiles != null) {
                buchstabe = this.controlFiles.map((char)ch, context);
            }
            result = result == null ? layouter.createFragment(this.font, this.font.getLayout(), buchstabe) : layouter.appendHorizontal(result, layouter.createFragment(this.font, this.font.getLayout(), buchstabe));
        }
        result.setVerticalAlignment(this.vAlign);
        result.setHorizontalAlignment(this.horizontalAlignment);
        if (result.getWidth() > maxLineLength) {
            this.warning("The word \"" + word + "\"exceeds the maximum length of a single line.");
        }
        return result;
    }

    public void warning(String s) {
        if (this.warner != null) {
            this.warner.addWarning(s);
        }
    }

    private String FIGMLParse(String figSource, String options, IFigConversionContext context) throws FigException {
        int i1;
        int format = 0;
        for (int i = 0; i < OutputFormat.FORMAT_STR.length; ++i) {
            i1 = options.indexOf(OutputFormat.FORMAT_STR[i]);
            if (i1 == -1) continue;
            format = i;
            options = options.substring(i1 + OutputFormat.FORMAT_STR[i].length()).trim();
            break;
        }
        int maxLineLength = 80;
        try {
            maxLineLength = Integer.parseInt(options);
        }
        catch (NumberFormatException e) {
            this.warning("Illegal option for length of line: '" + options + "'");
        }
        DefaultFigLayouter layouter = new DefaultFigLayouter(maxLineLength);
        i1 = figSource.indexOf("\n");
        while (i1 != -1) {
            figSource = i1 == figSource.length() ? figSource.substring(0, figSource.length() - 1) : (i1 == 0 ? figSource.substring(1) : (figSource.charAt(i1 - 1) == '>' ? figSource.substring(0, i1) + figSource.substring(i1 + 1) : figSource.substring(0, i1) + " " + figSource.substring(i1 + 1)));
            i1 = figSource.indexOf("\n", i1);
        }
        figSource = figSource.replace('\t', ' ');
        figSource = figSource.replace('\f', ' ');
        figSource = figSource.replace('\r', ' ');
        i1 = figSource.indexOf("  ");
        while (i1 != -1) {
            figSource = figSource.substring(0, i1) + figSource.substring(i1 + 1);
            i1 = figSource.indexOf("  ");
        }
        i1 = figSource.indexOf(" <br>");
        while (i1 != -1) {
            figSource = figSource.substring(0, i1) + figSource.substring(i1 + 1);
            i1 = figSource.indexOf(" <br>");
        }
        FigFragment resultFragment = null;
        FigFragment lineFragment = null;
        FigmlTokenizer tim = new FigmlTokenizer(figSource);
        FigmlToken token = tim.nextToken();
        while (token != null) {
            FigFragment a;
            if (token.getType() == 6) {
                this.setFont(token.getText());
            } else if (token.getType() == 7) {
                this.addControlFile(token.getText());
            } else if (token.getType() == 8) {
                this.removeControlFile(token.getText());
            } else if (token.getType() == 9) {
                this.removeAllControlFiles();
            } else if (token.getType() == 4) {
                this.setVAlignment(token.getText());
            } else if (token.getType() == 5) {
                this.setHAlignment(token.getText());
            } else if (token.getType() == 1) {
                if (lineFragment == null) {
                    lineFragment = new FigFragment(this.font.getFIGCharacter(32), this.font.getLayout(), this.font.getUnderLength(), maxLineLength);
                }
                resultFragment = resultFragment == null ? (FigFragment)lineFragment.clone() : layouter.appendVertical(resultFragment, lineFragment);
                lineFragment = null;
            } else if (token.getType() == 11) {
                if (lineFragment == null) {
                    lineFragment = new FigFragment(this.font.getFIGCharacter(32), this.font.getLayout(), this.font.getUnderLength(), maxLineLength);
                }
                resultFragment = resultFragment == null ? (FigFragment)lineFragment.clone() : layouter.appendVertical(resultFragment, lineFragment);
                a = this.figletizeRaw(token.getText(), maxLineLength, layouter, context);
                if (a.getWidth() == 1) {
                    a.ensureUnsmushability();
                }
                a.setVerticalAlignment(VerticalAlignment.CENTER);
                a.setHorizontalAlignment(HorizontalAlignment.CENTER);
                lineFragment = a;
                a = this.figletizeRaw(token.getText(), maxLineLength, layouter, context);
                if (a.getWidth() == 1) {
                    a.ensureUnsmushability();
                }
                while (a.getWidth() + lineFragment.getWidth() < maxLineLength) {
                    lineFragment = layouter.appendHorizontal(lineFragment, a);
                }
                resultFragment = resultFragment == null ? lineFragment : layouter.appendVertical(resultFragment, lineFragment);
                lineFragment = null;
            } else if (token.getType() == 0) {
                a = this.figletizeRaw(token.getText(), maxLineLength, layouter, context);
                a.setVerticalAlignment(this.vAlign);
                a.setHorizontalAlignment(this.horizontalAlignment);
                if (lineFragment == null) {
                    lineFragment = a;
                } else {
                    FigFragment test = (FigFragment)lineFragment.clone();
                    if ((test = layouter.appendHorizontal(test, a)).getWidth() > maxLineLength) {
                        resultFragment = resultFragment == null ? lineFragment : layouter.appendVertical(resultFragment, lineFragment);
                        lineFragment = a;
                    } else {
                        lineFragment = test;
                        lineFragment.setVerticalAlignment(this.vAlign);
                        lineFragment.setHorizontalAlignment(this.horizontalAlignment);
                    }
                }
            } else {
                System.out.println("Token noch unbekannt - ignoriert");
            }
            token = tim.nextToken();
        }
        if (lineFragment == null && resultFragment == null) {
            resultFragment = new FigFragment(this.font.getFIGCharacter(32), this.font.getLayout(), this.font.getUnderLength(), maxLineLength);
        } else if (resultFragment == null && lineFragment != null) {
            resultFragment = lineFragment;
        } else if (resultFragment != null && lineFragment != null) {
            resultFragment = layouter.appendVertical(resultFragment, lineFragment);
        }
        return AsciiOutputConverter.getAs(resultFragment, format);
    }

    private void reset() {
        try {
            this.setFont(this.getFileLibrary().getDefaultFontName());
        }
        catch (FigException e) {
            e.printStackTrace();
        }
        this.removeAllControlFiles();
        this.vAlign = VerticalAlignment.BOTTOM;
        this.horizontalAlignment = HorizontalAlignment.LEFT;
    }

    @Override
    public String figml(String input) throws FigException {
        DefaultConversionContext context = new DefaultConversionContext(this.warner);
        if (input.startsWith("<raw ")) {
            int i1 = input.indexOf(62);
            if (i1 < 5) {
                return "";
            }
            String fontName = input.substring(5, i1);
            this.reset();
            this.setFont(fontName);
            String source = input.substring(i1 + 1);
            if (source.length() == 0) {
                return "";
            }
            FigFragment fragment = null;
            for (int i = 0; i < source.length(); ++i) {
                char ch;
                char character = ch = source.charAt(i);
                DefaultFigLayouter layouter = new DefaultFigLayouter(100);
                fragment = fragment != null ? layouter.appendHorizontal(fragment, layouter.createFragment(this.font, this.font.getLayout(), character)) : layouter.createFragment(this.font, this.font.getLayout(), character);
            }
            return AsciiOutputConverter.getAs(fragment, -1);
        }
        StringBuffer output = new StringBuffer();
        int i1 = input.indexOf("<figlet");
        while (i1 != -1) {
            int i4;
            output.append(input.substring(0, i1));
            int i2 = input.indexOf(">", i1 + 5);
            if (i2 == -1) {
                // empty if block
            }
            String options = input.substring(i1 + 7, i2).trim().toLowerCase();
            int i3 = input.indexOf("</fig");
            if (i3 == -1) {
                i3 = input.length() - 5;
            }
            if ((i4 = input.indexOf(">", i3)) == -1) {
                i4 = i3;
            }
            String figSource = input.substring(i2 + 1, i3);
            this.reset();
            String figResult = this.FIGMLParse(figSource, options, context);
            output.append(figResult);
            input = input.substring(i4 + 1);
            i1 = input.indexOf("<figlet");
        }
        output.append(input);
        return output.toString();
    }

    @Override
    public IFigFileLibrary getFileLibrary() {
        return this.fileLibrary;
    }

    @Override
    public String figletize(String text, String fontName) throws FigException {
        try {
            return this.figletize(FigletJobFactory.createJob(text, fontName));
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error figletizing with font '" + fontName + "'", e);
        }
    }

    private FigFragment convertLine(String text, FigLayout layout, IFigLayouter layouter, FigFont font, IFigConversionContext context) {
        if (text.length() == 0) {
            return new FigFragment(new QuickString[0], new FigLayout[0], new FigLayout[0], 0, 0, new FigLayout[0], new FigLayout[0], 0, -1, layout.getPrintDirection());
        }
        FigFragment result = null;
        for (int i = 0; i < text.length(); ++i) {
            int ch;
            int characterCode = ch = text.charAt(i);
            if (this.controlFiles != null) {
                characterCode = this.controlFiles.map((char)ch, context);
            }
            result = result == null ? layouter.createFragment(font, layout, characterCode) : layouter.appendHorizontal(result, layouter.createFragment(font, layout, characterCode));
        }
        return result;
    }

    public void setWarningCollector(IWarningCollector warner) {
        this.warner = warner;
    }

    @Override
    public String figletize(IFigletJob job) throws FigException {
        FigFont font = job.getFont(this);
        FigLayout layout = job.getLayout();
        if (layout == null) {
            layout = font.getLayout();
        }
        DefaultFigLayouter layouter = new DefaultFigLayouter(-1);
        DefaultConversionContext context = new DefaultConversionContext(this.warner);
        String[] lines = TextTools.toStringArray(job.getText());
        FigFragment result = null;
        for (int i = 0; i < lines.length; ++i) {
            FigFragment convertedLine = this.convertLine(lines[i], layout, layouter, font, context);
            convertedLine.setHorizontalAlignment(job.getHorizontalAlignment());
            result = result == null ? convertedLine : layouter.appendVertical(result, convertedLine);
        }
        return result == null ? "" : AsciiOutputConverter.getAs(result, 0);
    }
}

