/*
 * Decompiled with CFR 0.152.
 */
package jode.expr;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Collection;
import jode.AssertError;
import jode.bytecode.ClassInfo;
import jode.bytecode.FieldInfo;
import jode.bytecode.InnerClassInfo;
import jode.bytecode.Reference;
import jode.bytecode.TypeSignature;
import jode.decompiler.ClassAnalyzer;
import jode.decompiler.FieldAnalyzer;
import jode.decompiler.MethodAnalyzer;
import jode.decompiler.Options;
import jode.decompiler.Scope;
import jode.decompiler.TabbedPrintWriter;
import jode.expr.Operator;
import jode.expr.ThisOperator;
import jode.type.ClassInterfacesType;
import jode.type.NullType;
import jode.type.Type;

public abstract class FieldOperator
extends Operator {
    MethodAnalyzer methodAnalyzer;
    boolean staticFlag;
    Reference ref;
    Type classType;

    public int getPriority() {
        return 950;
    }

    public void updateSubTypes() {
        if (!this.staticFlag) {
            this.subExpressions[0].setType(Type.tSubType(this.classType));
        }
    }

    public void updateType() {
        this.updateParentType(this.getFieldType());
    }

    public boolean isStatic() {
        return this.staticFlag;
    }

    public ClassInfo getClassInfo() {
        if (this.classType instanceof ClassInterfacesType) {
            return ((ClassInterfacesType)this.classType).getClassInfo();
        }
        return null;
    }

    public FieldAnalyzer getField() {
        ClassInfo classInfo = this.getClassInfo();
        if (classInfo != null) {
            ClassAnalyzer classAnalyzer = this.methodAnalyzer.getClassAnalyzer();
            while (true) {
                if (classInfo == classAnalyzer.getClazz()) {
                    int n = classAnalyzer.getFieldIndex(this.ref.getName(), Type.tType(this.ref.getType()));
                    if (n >= 0) {
                        return classAnalyzer.getField(n);
                    }
                    return null;
                }
                if (classAnalyzer.getParent() == null) {
                    return null;
                }
                if (classAnalyzer.getParent() instanceof MethodAnalyzer) {
                    classAnalyzer = ((MethodAnalyzer)classAnalyzer.getParent()).getClassAnalyzer();
                    continue;
                }
                if (!(classAnalyzer.getParent() instanceof ClassAnalyzer)) break;
                classAnalyzer = (ClassAnalyzer)classAnalyzer.getParent();
            }
            throw new AssertError("Unknown parent");
        }
        return null;
    }

    public String getFieldName() {
        return this.ref.getName();
    }

    public Type getFieldType() {
        return Type.tType(this.ref.getType());
    }

    private static FieldInfo getFieldInfo(ClassInfo classInfo, String string, String string2) {
        while (classInfo != null) {
            FieldInfo fieldInfo = classInfo.findField(string, string2);
            if (fieldInfo != null) {
                return fieldInfo;
            }
            ClassInfo[] classInfoArray = classInfo.getInterfaces();
            int n = 0;
            while (n < classInfoArray.length) {
                fieldInfo = FieldOperator.getFieldInfo(classInfoArray[n], string, string2);
                if (fieldInfo != null) {
                    return fieldInfo;
                }
                ++n;
            }
            classInfo = classInfo.getSuperclass();
        }
        return null;
    }

    public FieldInfo getFieldInfo() {
        ClassInfo classInfo = this.ref.getClazz().charAt(0) == '[' ? ClassInfo.javaLangObject : TypeSignature.getClassInfo(this.ref.getClazz());
        return FieldOperator.getFieldInfo(classInfo, this.ref.getName(), this.ref.getType());
    }

    /*
     * Unable to fully structure code
     */
    public boolean needsCast(Type var1_1) {
        if (var1_1 instanceof NullType) {
            return true;
        }
        if (!(var1_1 instanceof ClassInterfacesType) || !(this.classType instanceof ClassInterfacesType)) {
            return false;
        }
        var2_2 = ((ClassInterfacesType)this.classType).getClassInfo();
        var3_3 = ((ClassInterfacesType)var1_1).getClassInfo();
        var4_4 = var2_2.findField(this.ref.getName(), this.ref.getType());
        block0: while (var4_4 == null) {
            var5_5 = var2_2.getInterfaces();
            var6_7 = 0;
            while (var6_7 < var5_5.length) {
                var4_4 = var5_5[var6_7].findField(this.ref.getName(), this.ref.getType());
                if (var4_4 != null) break block0;
                ++var6_7;
            }
            if ((var2_2 = var2_2.getSuperclass()) == null) {
                return false;
            }
            var4_4 = var2_2.findField(this.ref.getName(), this.ref.getType());
        }
        if (Modifier.isPrivate(var4_4.getModifiers())) {
            return var3_3 != var2_2;
        }
        if ((var4_4.getModifiers() & 5) != 0 || (var5_6 = var2_2.getName().lastIndexOf(46)) != -1 && var5_6 == var3_3.getName().lastIndexOf(46) && var3_3.getName().startsWith(var2_2.getName().substring(0, var5_6))) ** GOTO lbl32
        return true;
lbl-1000:
        // 1 sources

        {
            var5_5 = var3_3.getFields();
            var6_7 = 0;
            while (var6_7 < var5_5.length) {
                if (var5_5[var6_7].getName().equals(this.ref.getName())) {
                    return true;
                }
                ++var6_7;
            }
            var3_3 = var3_3.getSuperclass();
lbl32:
            // 2 sources

            ** while (var2_2 != var3_3 && var2_2 != null)
        }
lbl33:
        // 1 sources

        return false;
    }

    public InnerClassInfo getOuterClassInfo(ClassInfo classInfo) {
        InnerClassInfo[] innerClassInfoArray;
        if (classInfo != null && (innerClassInfoArray = classInfo.getOuterClasses()) != null) {
            return innerClassInfoArray[0];
        }
        return null;
    }

    public void fillDeclarables(Collection collection) {
        ClassInfo classInfo = this.getClassInfo();
        InnerClassInfo innerClassInfo = this.getOuterClassInfo(classInfo);
        ClassAnalyzer classAnalyzer = this.methodAnalyzer.getClassAnalyzer(classInfo);
        if ((Options.options & 4) != 0 && innerClassInfo != null && innerClassInfo.outer == null && innerClassInfo.name != null && classAnalyzer != null && classAnalyzer.getParent() == this.methodAnalyzer) {
            classAnalyzer.fillDeclarables(collection);
            collection.add(classAnalyzer);
        }
        super.fillDeclarables(collection);
    }

    public void dumpExpression(TabbedPrintWriter tabbedPrintWriter) throws IOException {
        boolean bl = !this.staticFlag && this.subExpressions[0] instanceof ThisOperator;
        String string = this.ref.getName();
        if (this.staticFlag) {
            if (!this.classType.equals(Type.tClass(this.methodAnalyzer.getClazz())) || this.methodAnalyzer.findLocal(string) != null) {
                tabbedPrintWriter.printType(this.classType);
                tabbedPrintWriter.breakOp();
                tabbedPrintWriter.print(".");
            }
            tabbedPrintWriter.print(string);
        } else if (this.needsCast(this.subExpressions[0].getType().getCanonic())) {
            tabbedPrintWriter.print("(");
            tabbedPrintWriter.startOp(0, 1);
            tabbedPrintWriter.print("(");
            tabbedPrintWriter.printType(this.classType);
            tabbedPrintWriter.print(") ");
            tabbedPrintWriter.breakOp();
            this.subExpressions[0].dumpExpression(tabbedPrintWriter, 700);
            tabbedPrintWriter.endOp();
            tabbedPrintWriter.print(")");
            tabbedPrintWriter.breakOp();
            tabbedPrintWriter.print(".");
            tabbedPrintWriter.print(string);
        } else {
            if (bl) {
                ThisOperator thisOperator = (ThisOperator)this.subExpressions[0];
                Scope scope = tabbedPrintWriter.getScope(thisOperator.getClassInfo(), 1);
                if (scope == null || tabbedPrintWriter.conflicts(string, scope, 3)) {
                    thisOperator.dumpExpression(tabbedPrintWriter, 950);
                    tabbedPrintWriter.breakOp();
                    tabbedPrintWriter.print(".");
                } else if (tabbedPrintWriter.conflicts(string, scope, 4) || this.getField() == null && tabbedPrintWriter.conflicts(string, null, 13)) {
                    thisOperator.dumpExpression(tabbedPrintWriter, 950);
                    tabbedPrintWriter.breakOp();
                    tabbedPrintWriter.print(".");
                }
            } else {
                this.subExpressions[0].dumpExpression(tabbedPrintWriter, 950);
                tabbedPrintWriter.breakOp();
                tabbedPrintWriter.print(".");
            }
            tabbedPrintWriter.print(string);
        }
    }

    public FieldOperator(MethodAnalyzer methodAnalyzer, boolean bl, Reference reference) {
        super(Type.tType(reference.getType()));
        this.methodAnalyzer = methodAnalyzer;
        this.staticFlag = bl;
        this.classType = Type.tType(reference.getClazz());
        this.ref = reference;
        if (bl) {
            methodAnalyzer.useType(this.classType);
        }
        this.initOperands(bl ? 0 : 1);
    }
}

