/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.key.passwd.swing;

import de.schlichtherle.key.passwd.swing.OpenKeyFeedback;
import de.schlichtherle.key.passwd.swing.PasswdOrKeyFilePanel;
import de.schlichtherle.key.passwd.swing.PromptingKeyProviderUI;
import de.schlichtherle.swing.EnhancedPanel;
import de.schlichtherle.swing.event.PanelEvent;
import de.schlichtherle.swing.event.PanelListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class OpenKeyPanel
extends EnhancedPanel {
    private static final String CLASS_NAME = "de/schlichtherle/key/passwd/swing/OpenKeyPanel".replace('/', '.');
    private static final ResourceBundle resources = ResourceBundle.getBundle(CLASS_NAME);
    private final Color defaultForeground;
    private JComponent extraDataUI;
    private OpenKeyFeedback feedback;
    private JCheckBox changeKeyRequested;
    private JLabel error;
    private JPasswordField passwd;
    private JLabel passwdLong;
    private PasswdOrKeyFilePanel passwdOrKeyFilePanel;
    private EnhancedPanel passwdPanel;
    private JLabel passwdShort;
    private JTextPane resourceID;

    public OpenKeyPanel() {
        this.initComponents();
        this.defaultForeground = this.resourceID.getForeground();
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                OpenKeyPanel.this.setError(null);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                OpenKeyPanel.this.setError(null);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                OpenKeyPanel.this.setError(null);
            }
        };
        this.passwd.getDocument().addDocumentListener(documentListener);
        this.passwdOrKeyFilePanel.pathname.getDocument().addDocumentListener(documentListener);
    }

    private Font getBoldFont() {
        return this.resourceID.getFont().deriveFont(1);
    }

    public void setResourceID(String string) {
        String string2 = PromptingKeyProviderUI.lastResourceID;
        if (!string2.equals(string) && !"".equals(string2)) {
            this.resourceID.setForeground(Color.RED);
        } else {
            this.resourceID.setForeground(this.defaultForeground);
        }
        this.resourceID.setText(string);
        PromptingKeyProviderUI.lastResourceID = string;
    }

    public String getResourceID() {
        return this.resourceID.getText();
    }

    public String getError() {
        return this.error.getText();
    }

    public void setError(String string) {
        this.error.setText(string);
    }

    public Object getOpenKey() {
        this.setError(null);
        if (this.passwdOrKeyFilePanel.useKeyFile.isSelected()) {
            Document document = this.passwdOrKeyFilePanel.pathname.getDocument();
            try {
                return PromptingKeyProviderUI.readKeyFile(document.getText(0, document.getLength()));
            }
            catch (BadLocationException badLocationException) {
                throw new AssertionError((Object)badLocationException);
            }
            catch (EOFException eOFException) {
                this.setError(resources.getString("keyFile.eofException"));
                return null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.setError(resources.getString("keyFile.fileNotFoundException"));
                return null;
            }
            catch (IOException iOException) {
                this.setError(resources.getString("keyFile.ioException"));
                return null;
            }
        }
        return this.passwd.getPassword();
    }

    public void setKeyChangeRequested(boolean bl) {
        this.changeKeyRequested.setSelected(bl);
    }

    public boolean isKeyChangeRequested() {
        return this.changeKeyRequested.isSelected();
    }

    public JComponent getExtraDataUI() {
        return this.extraDataUI;
    }

    public void setExtraDataUI(JComponent jComponent) {
        if (this.extraDataUI == jComponent) {
            return;
        }
        if (this.extraDataUI != null) {
            this.remove(this.extraDataUI);
        }
        if (jComponent != null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(15, 0, 0, 0);
            this.add((Component)jComponent, gridBagConstraints);
        }
        this.extraDataUI = jComponent;
        this.revalidate();
    }

    public OpenKeyFeedback getFeedback() {
        return this.feedback;
    }

    public void setFeedback(OpenKeyFeedback openKeyFeedback) {
        this.feedback = openKeyFeedback;
    }

    private void initComponents() {
        this.passwdPanel = new EnhancedPanel();
        this.passwdShort = new JLabel();
        this.passwd = new JPasswordField();
        this.passwdLong = new JLabel();
        this.resourceID = new JTextPane();
        this.passwdOrKeyFilePanel = new PasswdOrKeyFilePanel();
        this.changeKeyRequested = new JCheckBox();
        this.error = new JLabel();
        this.passwdPanel.setLayout(new GridBagLayout());
        this.passwdPanel.addPanelListener(new PanelListener(){

            public void ancestorWindowShown(PanelEvent panelEvent) {
                OpenKeyPanel.this.passwdPanelAncestorWindowShown(panelEvent);
            }

            public void ancestorWindowHidden(PanelEvent panelEvent) {
            }
        });
        this.passwdShort.setLabelFor(this.passwd);
        this.passwdShort.setText(resources.getString("passwdShort"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.passwdPanel.add((Component)this.passwdShort, gridBagConstraints);
        this.passwd.setPreferredSize(new Dimension(150, 23));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.passwdPanel.add((Component)this.passwd, gridBagConstraints);
        this.setLayout(new GridBagLayout());
        this.passwdLong.setLabelFor(this.resourceID);
        this.passwdLong.setText(resources.getString("passwdLong"));
        this.passwdLong.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.passwdLong, gridBagConstraints);
        this.resourceID.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.resourceID.setEditable(false);
        this.resourceID.setFont(this.getBoldFont());
        this.resourceID.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        this.add((Component)this.resourceID, gridBagConstraints);
        this.passwdOrKeyFilePanel.setPasswdPanel(this.passwdPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.passwdOrKeyFilePanel, gridBagConstraints);
        this.changeKeyRequested.setText(resources.getString("changePasswdRequested"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.add((Component)this.changeKeyRequested, gridBagConstraints);
        this.error.setForeground(Color.red);
        this.error.setName("error");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.add((Component)this.error, gridBagConstraints);
    }

    private void passwdPanelAncestorWindowShown(PanelEvent panelEvent) {
        OpenKeyFeedback openKeyFeedback = this.getFeedback();
        if (openKeyFeedback != null) {
            openKeyFeedback.setPanel(this);
            openKeyFeedback.run();
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                OpenKeyPanel.this.passwd.selectAll();
                OpenKeyPanel.this.passwd.requestFocusInWindow();
            }
        });
    }
}

