/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.key.passwd.swing;

import de.schlichtherle.key.passwd.swing.CreateKeyFeedback;
import de.schlichtherle.key.passwd.swing.PasswdOrKeyFilePanel;
import de.schlichtherle.key.passwd.swing.PromptingKeyProviderUI;
import de.schlichtherle.key.passwd.swing.WeakKeyException;
import de.schlichtherle.swing.EnhancedPanel;
import de.schlichtherle.swing.event.PanelEvent;
import de.schlichtherle.swing.event.PanelListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.zip.Deflater;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class CreateKeyPanel
extends EnhancedPanel {
    private static final String CLASS_NAME;
    private static final ResourceBundle resources;
    private static int MIN_PASSWD_LEN;
    private final Color defaultForeground;
    private JComponent extraDataUI;
    private CreateKeyFeedback feedback;
    private JLabel error;
    private JPasswordField newPasswd1;
    private JPasswordField newPasswd2;
    private JLabel newPasswdLong;
    private EnhancedPanel newPasswdPanel;
    private JLabel newPasswdShort1;
    private JLabel newPasswdShort2;
    private PasswdOrKeyFilePanel passwdOrKeyFilePanel;
    private JTextPane resourceID;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CreateKeyPanel() {
        this.initComponents();
        this.defaultForeground = this.resourceID.getForeground();
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                CreateKeyPanel.this.setError(null);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                CreateKeyPanel.this.setError(null);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                CreateKeyPanel.this.setError(null);
            }
        };
        this.newPasswd1.getDocument().addDocumentListener(documentListener);
        this.newPasswd2.getDocument().addDocumentListener(documentListener);
        this.passwdOrKeyFilePanel.pathname.getDocument().addDocumentListener(documentListener);
    }

    private Font getBoldFont() {
        Font font = this.resourceID.getFont();
        return new Font(font.getName(), 1, font.getSize());
    }

    public String getResourceID() {
        return this.resourceID.getText();
    }

    public void setResourceID(String string) {
        String string2 = PromptingKeyProviderUI.lastResourceID;
        if (!string2.equals(string) && !"".equals(string2)) {
            this.resourceID.setForeground(Color.RED);
        } else {
            this.resourceID.setForeground(this.defaultForeground);
        }
        this.resourceID.setText(string);
        PromptingKeyProviderUI.lastResourceID = string;
    }

    public Object getCreateKey() {
        try {
            char[] cArray;
            if (this.passwdOrKeyFilePanel.useKeyFile.isSelected()) {
                byte[] byArray;
                Document document = this.passwdOrKeyFilePanel.pathname.getDocument();
                try {
                    byArray = PromptingKeyProviderUI.readKeyFile(document.getText(0, document.getLength()));
                }
                catch (EOFException eOFException) {
                    this.setError(resources.getString("keyFile.eofException"));
                    return null;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.setError(resources.getString("keyFile.fileNotFoundException"));
                    return null;
                }
                catch (IOException iOException) {
                    this.setError(resources.getString("keyFile.ioException"));
                    return null;
                }
                this.checkKeyFileCreateKey(byArray);
                return byArray;
            }
            char[] cArray2 = this.newPasswd1.getPassword();
            if (Arrays.equals(cArray2, cArray = this.newPasswd2.getPassword())) {
                Arrays.fill(cArray, '\u0000');
                this.checkPasswdCreateKey(cArray2);
                return cArray2;
            }
            this.setError(resources.getString("passwdNoMatch"));
            return null;
        }
        catch (BadLocationException badLocationException) {
            throw new AssertionError((Object)badLocationException);
        }
        catch (WeakKeyException weakKeyException) {
            this.setError(weakKeyException.getLocalizedMessage());
            return null;
        }
    }

    public void resetCreateKey() {
        this.resetPasswd();
        this.setError(null);
    }

    public void resetPasswd() {
        this.newPasswd1.setText(null);
        this.newPasswd2.setText(null);
    }

    protected void checkKeyFileCreateKey(byte[] byArray) throws WeakKeyException {
        Deflater deflater = new Deflater();
        deflater.setInput(byArray);
        deflater.finish();
        if (!$assertionsDisabled && deflater.getTotalOut() != 0) {
            throw new AssertionError();
        }
        int n = deflater.deflate(new byte[byArray.length * 2]);
        if (!$assertionsDisabled && deflater.getTotalOut() != n) {
            throw new AssertionError();
        }
        deflater.end();
        if (n < 64) {
            throw new WeakKeyException(resources, "keyFile.badEntropy");
        }
    }

    protected void checkPasswdCreateKey(char[] cArray) throws WeakKeyException {
        if (cArray.length < MIN_PASSWD_LEN) {
            throw new WeakKeyException(resources, "passwd.tooShort", new Integer(MIN_PASSWD_LEN));
        }
    }

    public String getError() {
        return this.error.getText();
    }

    public void setError(String string) {
        this.error.setText(string);
    }

    public JComponent getExtraDataUI() {
        return this.extraDataUI;
    }

    public void setExtraDataUI(JComponent jComponent) {
        if (this.extraDataUI == jComponent) {
            return;
        }
        if (this.extraDataUI != null) {
            this.remove(this.extraDataUI);
        }
        if (jComponent != null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(15, 0, 0, 0);
            this.add((Component)jComponent, gridBagConstraints);
        }
        this.extraDataUI = jComponent;
        this.revalidate();
    }

    public CreateKeyFeedback getFeedback() {
        return this.feedback;
    }

    public void setFeedback(CreateKeyFeedback createKeyFeedback) {
        this.feedback = createKeyFeedback;
    }

    private void initComponents() {
        this.newPasswdPanel = new EnhancedPanel();
        this.newPasswdShort1 = new JLabel();
        this.newPasswd1 = new JPasswordField();
        this.newPasswdShort2 = new JLabel();
        this.newPasswd2 = new JPasswordField();
        this.newPasswdLong = new JLabel();
        this.resourceID = new JTextPane();
        this.passwdOrKeyFilePanel = new PasswdOrKeyFilePanel();
        this.error = new JLabel();
        this.newPasswdPanel.setLayout(new GridBagLayout());
        this.newPasswdPanel.addPanelListener(new PanelListener(){

            public void ancestorWindowShown(PanelEvent panelEvent) {
                CreateKeyPanel.this.newPasswdPanelAncestorWindowShown(panelEvent);
            }

            public void ancestorWindowHidden(PanelEvent panelEvent) {
            }
        });
        this.newPasswdShort1.setLabelFor(this.newPasswd1);
        this.newPasswdShort1.setText(resources.getString("newPasswdShort1"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.newPasswdPanel.add((Component)this.newPasswdShort1, gridBagConstraints);
        this.newPasswd1.setPreferredSize(new Dimension(150, 23));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.newPasswdPanel.add((Component)this.newPasswd1, gridBagConstraints);
        this.newPasswdShort2.setLabelFor(this.newPasswd2);
        this.newPasswdShort2.setText(resources.getString("newPasswdShort2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.newPasswdPanel.add((Component)this.newPasswdShort2, gridBagConstraints);
        this.newPasswd2.setPreferredSize(new Dimension(150, 23));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.newPasswdPanel.add((Component)this.newPasswd2, gridBagConstraints);
        this.setLayout(new GridBagLayout());
        this.newPasswdLong.setLabelFor(this.resourceID);
        this.newPasswdLong.setText(resources.getString("newPasswdLong"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.newPasswdLong, gridBagConstraints);
        this.resourceID.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.resourceID.setEditable(false);
        this.resourceID.setFont(this.getBoldFont());
        this.resourceID.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        this.add((Component)this.resourceID, gridBagConstraints);
        this.passwdOrKeyFilePanel.setPasswdPanel(this.newPasswdPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.passwdOrKeyFilePanel, gridBagConstraints);
        this.error.setForeground(Color.red);
        this.error.setName("error");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.add((Component)this.error, gridBagConstraints);
    }

    private void newPasswdPanelAncestorWindowShown(PanelEvent panelEvent) {
        CreateKeyFeedback createKeyFeedback = this.getFeedback();
        if (createKeyFeedback != null) {
            createKeyFeedback.setPanel(this);
            createKeyFeedback.run();
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                CreateKeyPanel.this.newPasswd1.selectAll();
                CreateKeyPanel.this.newPasswd2.selectAll();
                CreateKeyPanel.this.newPasswd1.requestFocusInWindow();
            }
        });
    }

    static {
        $assertionsDisabled = !CreateKeyPanel.class.desiredAssertionStatus();
        CLASS_NAME = "de/schlichtherle/key/passwd/swing/CreateKeyPanel".replace('/', '.');
        resources = ResourceBundle.getBundle(CLASS_NAME);
        MIN_PASSWD_LEN = 6;
    }
}

