/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.zip;

import de.schlichtherle.io.InputArchiveMetaData;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.InputArchive;
import de.schlichtherle.io.archive.zip.Zip32Entry;
import de.schlichtherle.io.rof.ReadOnlyFile;
import de.schlichtherle.io.util.Path;
import de.schlichtherle.util.zip.ZipEntry;
import de.schlichtherle.util.zip.ZipFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.zip.ZipException;

public class Zip32InputArchive
extends ZipFile
implements InputArchive {
    private InputArchiveMetaData metaData;

    public Zip32InputArchive(ReadOnlyFile readOnlyFile, String string, boolean bl, boolean bl2) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        super(readOnlyFile, string, bl, bl2);
    }

    protected ZipEntry createZipEntry(String string) {
        return new Zip32Entry(Path.normalize(string, '/'));
    }

    public int getNumArchiveEntries() {
        return super.size();
    }

    public Enumeration getArchiveEntries() {
        return super.entries();
    }

    public ArchiveEntry getArchiveEntry(String string) {
        return (Zip32Entry)super.getEntry(string);
    }

    public InputStream getInputStream(ArchiveEntry archiveEntry, ArchiveEntry archiveEntry2) throws IOException {
        return super.getInputStream((Zip32Entry)archiveEntry, !(archiveEntry2 instanceof Zip32Entry));
    }

    public InputArchiveMetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(InputArchiveMetaData inputArchiveMetaData) {
        this.metaData = inputArchiveMetaData;
    }
}

