/*
 * Decompiled with CFR 0.152.
 */
package jarxplorer.parser;

import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantValue;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.Utility;

public class MyField {
    private String name = "";
    private String modifiers = "";
    private String signature = "";
    private String value = "";

    public MyField(Field field) {
        this.modifiers = Utility.accessToString(field.getAccessFlags());
        this.signature = Utility.signatureToString(field.getSignature());
        this.name = field.getName();
        this.setValue(field);
    }

    public String getModifiers() {
        return this.modifiers;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    private void setValue(Field field) {
        StringBuffer stringBuffer = new StringBuffer();
        ConstantValue constantValue = field.getConstantValue();
        Attribute[] attributeArray = field.getAttributes();
        int n = field.getAttributes().length;
        if (constantValue != null) {
            stringBuffer.append(constantValue);
            for (int i = 0; i < n; ++i) {
                Attribute attribute = attributeArray[i];
                if (attribute instanceof ConstantValue) continue;
                stringBuffer.append(" [" + attribute.toString() + "]");
            }
        }
        this.value = stringBuffer.toString().replace("\"", "");
    }

    public String dump() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Name: " + this.getName() + "\n");
        stringBuffer.append("Modifiers: " + this.getModifiers() + "\n");
        stringBuffer.append("Signature: " + this.getSignature() + "\n");
        stringBuffer.append("Value: " + this.getValue() + "\n");
        return stringBuffer.toString();
    }
}

