/*
 * Decompiled with CFR 0.152.
 */
package jarxplorer.gui.tree;

import jarxplorer.gui.tree.PropertiesTableCellRender;
import jarxplorer.helpers.Utilities;
import jarxplorer.model.ClassNode;
import jarxplorer.model.ConstructorNode;
import jarxplorer.model.FieldNode;
import jarxplorer.model.MethodNode;
import jarxplorer.model.MyTreeNode;
import jarxplorer.model.PropertiesTableModel;
import jarxplorer.parser.MyClass;
import jarxplorer.parser.MyField;
import jarxplorer.parser.MyMethod;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableColumn;

public class PropertiesPanel
extends JFrame {
    String title;
    String description;

    public PropertiesPanel(MyTreeNode myTreeNode) {
        JTable jTable;
        Object object;
        JLabel jLabel = new JLabel("Properties");
        jLabel.setBackground(Color.lightGray);
        jLabel.setText(" Properties");
        jLabel.setOpaque(true);
        this.add((Component)jLabel, "North");
        String string = myTreeNode.getType();
        if (string.equals("FieldNode")) {
            object = ((FieldNode)myTreeNode).getField();
            jTable = new JTable(new PropertiesTableModel((MyField)object));
            this.title = ((MyField)object).getName();
            this.description = this.getDescription((MyField)object);
        } else if (string.equals("ClassNode")) {
            object = ((ClassNode)myTreeNode).getMyClass();
            jTable = new JTable(new PropertiesTableModel((MyClass)object));
            this.title = ((MyClass)object).getName() + ".class";
            this.description = this.getDescription((MyClass)object);
        } else if (string.equals("MethodNode")) {
            object = ((MethodNode)myTreeNode).getMethod();
            jTable = new JTable(new PropertiesTableModel((MyMethod)object, false));
            this.title = ((MyMethod)object).getName();
            this.description = this.getDescription((MyMethod)object);
        } else {
            object = ((ConstructorNode)myTreeNode).getMethod();
            jTable = new JTable(new PropertiesTableModel((MyMethod)object, true));
            this.title = ((MyMethod)object).getName();
            this.description = this.getDescription((MyMethod)object);
        }
        jTable.setGridColor(Color.lightGray);
        jTable.setIntercellSpacing(new Dimension(5, 5));
        object = jTable.getColumnModel().getColumn(0);
        TableColumn tableColumn = jTable.getColumnModel().getColumn(1);
        ((TableColumn)object).setCellRenderer(new PropertiesTableCellRender());
        tableColumn.setCellRenderer(new PropertiesTableCellRender());
        this.add((Component)jTable, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JLabel jLabel2 = new JLabel(this.description);
        jLabel2.setOpaque(true);
        Border border = BorderFactory.createEmptyBorder(2, 2, 0, 0);
        jLabel2.setBorder(border);
        jPanel.add((Component)jLabel2, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        JButton jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertiesPanel.this.dispose();
            }
        });
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "South");
        this.add((Component)jPanel, "South");
        Utilities utilities = new Utilities();
        this.setTitle(this.title + " - Properties");
        URL uRL = ClassLoader.getSystemResource("jarxplorer/icons/viewmag.png");
        this.setIconImage(new ImageIcon(uRL).getImage());
        this.setSize(utilities.getFrameWidth() - 50, utilities.getFrameHeight() - 50);
        this.setResizable(true);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
    }

    private String getDescription(MyClass myClass) {
        return "<html><b>" + myClass.getName() + ".class</b></html>";
    }

    private String getDescription(MyField myField) {
        String string = "<html><b>" + myField.getName() + "</b><br>" + myField.getModifiers() + " " + myField.getSignature() + " " + myField.getName() + "</html>";
        return string;
    }

    private String getDescription(MyMethod myMethod) {
        String string = myMethod.getModifiers() + " " + myMethod.getReturnType() + " " + myMethod.getName() + " " + myMethod.getSignature();
        if (myMethod.getExceptions() != null && myMethod.getExceptions().length() > 0) {
            string = string + " throws " + myMethod.getExceptions();
        }
        String string2 = "<html><b>" + myMethod.getName() + "</b><br>" + string + "</html>";
        return string2;
    }
}

