/*
 * Decompiled with CFR 0.152.
 */
package jarxplorer.gui.tree;

import jarxplorer.gui.tree.GuiManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;

public class DropJarListener
implements DropTargetListener {
    GuiManager uiManager;

    public DropJarListener(GuiManager guiManager) {
        this.uiManager = guiManager;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isDragAcceptable(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isDragAcceptable(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        dropTargetDropEvent.acceptDrop(1);
        Transferable transferable = dropTargetDropEvent.getTransferable();
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        try {
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                Object object;
                DataFlavor dataFlavor = dataFlavorArray[i];
                if (dataFlavor.equals(DataFlavor.javaFileListFlavor)) {
                    object = (List)transferable.getTransferData(dataFlavor);
                    String string = ((File)object.get(0)).getAbsolutePath();
                    if (string.toLowerCase().trim().endsWith(".jar")) {
                        this.uiManager.jarDropped(string);
                        dropTargetDropEvent.dropComplete(true);
                        continue;
                    }
                    dropTargetDropEvent.dropComplete(false);
                    continue;
                }
                if (!dataFlavor.equals(DataFlavor.stringFlavor)) continue;
                object = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                if (((String)object).toLowerCase().trim().endsWith(".jar")) {
                    this.uiManager.jarDropped(new URL((String)object).getPath());
                    dropTargetDropEvent.dropComplete(true);
                    continue;
                }
                dropTargetDropEvent.dropComplete(false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean isDragAcceptable(DropTargetDragEvent dropTargetDragEvent) {
        boolean bl = (dropTargetDragEvent.getDropAction() & 3) != 0;
        Transferable transferable = dropTargetDragEvent.getTransferable();
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        try {
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                DataFlavor dataFlavor = dataFlavorArray[i];
                if (dataFlavor.equals(DataFlavor.javaFileListFlavor)) {
                    List list = (List)transferable.getTransferData(dataFlavor);
                    String string = ((File)list.get(0)).getAbsolutePath();
                    return string.toLowerCase().trim().endsWith(".jar") && bl;
                }
                if (!dataFlavor.equals(DataFlavor.stringFlavor)) continue;
                String string = (String)transferable.getTransferData(dataFlavor);
                return string.toLowerCase().trim().endsWith(".jar") && bl;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return false;
    }

    private boolean validateDrop(String string, boolean bl) {
        return string.toLowerCase().trim().endsWith(".jar") && bl;
    }
}

