/*
 * Decompiled with CFR 0.152.
 */
package jarxplorer.gui.decompiler;

import jarxplorer.gui.decompiler.Jode;
import jarxplorer.gui.decompiler.JodeExceptionHandler;
import jarxplorer.gui.decompiler.TextAreaPopupMenu;
import jarxplorer.gui.tree.IconFactory;
import jarxplorer.helpers.Preference;
import jarxplorer.helpers.SwingWorker;
import jarxplorer.helpers.Utilities;
import jarxplorer.model.ClassNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import jode.decompiler.ProgressListener;
import sdoc.Gutter;
import sdoc.SyntaxSupport;

public class SingletonCodePanel
extends JFrame
implements ProgressListener {
    private JTabbedPane tabPanel;
    private static SingletonCodePanel singletonCodePanel;
    private JPanel progressBarPanel;
    private JProgressBar progressBar;
    private JMenuBar menuBar;
    private JMenu file;
    private JMenuItem save;
    private JMenuItem close;
    private JMenuItem closeAll;
    private JMenuItem exit;
    private ArrayList<String> memory = new ArrayList();

    private SingletonCodePanel() {
        Utilities utilities = new Utilities();
        this.tabPanel = new JTabbedPane();
        this.tabPanel.setTabLayoutPolicy(1);
        this.setTitle("Jar Explorer");
        URL uRL = ClassLoader.getSystemResource("jarxplorer/icons/viewmag.png");
        this.setIconImage(new ImageIcon(uRL).getImage());
        this.setSize(utilities.getFrameWidth() + 200, utilities.getFrameHeight() + 50);
        this.setResizable(true);
        this.setLocation(utilities.getScreenWidth() / 2 - 200, utilities.getScreenHeigth() / 2 - 200);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabPanel, "Center");
        this.add((Component)this.buildProgressBarPanel(), "South");
        this.setJMenuBar(this.buildMenu());
        this.disabledMenu();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SingletonCodePanel.singletonCodePanel = null;
                SingletonCodePanel.this.dispose();
            }
        });
        this.setAlwaysOnTop(Preference.getPreference().isAlwaysOnTop());
        this.toFront();
    }

    public static SingletonCodePanel getSingletonCodePanel() {
        if (singletonCodePanel == null) {
            singletonCodePanel = new SingletonCodePanel();
        }
        return singletonCodePanel;
    }

    public static void alwaysOnTop(boolean bl) {
        if (singletonCodePanel != null) {
            singletonCodePanel.setAlwaysOnTop(bl);
        }
    }

    public void addTabWorker(final ClassNode classNode, final SingletonCodePanel singletonCodePanel) {
        SwingWorker swingWorker = new SwingWorker(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object construct() {
                Class<SingletonCodePanel> clazz = SingletonCodePanel.class;
                synchronized (SingletonCodePanel.class) {
                    String string = classNode.toString();
                    String string2 = string.substring(0, string.indexOf(".class")) + ".java";
                    Thread.setDefaultUncaughtExceptionHandler(new JodeExceptionHandler(singletonCodePanel, string2));
                    singletonCodePanel.setVisible(true);
                    SingletonCodePanel.this.enabledProgressPanel();
                    Jode jode = new Jode(classNode.getPath(), singletonCodePanel);
                    String string3 = jode.decompile();
                    SingletonCodePanel.this.addTab(string2, string3);
                    SingletonCodePanel.this.disabledProgressPanel();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return null;
                }
            }

            public void finished() {
            }
        };
        swingWorker.start();
    }

    public void addTab(String string, String string2) {
        if (!this.memory.contains(string)) {
            this.tabPanel.insertTab(string, IconFactory.getInstance().getIcon("FileJava"), this.buildTextAreaPanel(string2), string, 0);
            this.tabPanel.setSelectedIndex(0);
            this.memory.add(string);
            this.enabledMenu();
        }
        this.toFront();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogTab(String string, String string2) {
        Class<JodeExceptionHandler> clazz = JodeExceptionHandler.class;
        synchronized (JodeExceptionHandler.class) {
            if (!this.memory.contains(string)) {
                JTextArea jTextArea = new JTextArea();
                jTextArea.setFont(new Font("Dialog", 1, 10));
                jTextArea.setEditable(false);
                jTextArea.setText("Error decompiling " + string2 + System.getProperty("line.separator"));
                jTextArea.addMouseListener(new TextAreaPopupMenu(jTextArea));
                JScrollPane jScrollPane = new JScrollPane(jTextArea);
                this.tabPanel.addTab(string, IconFactory.getInstance().getIcon("Error"), jScrollPane, string);
                this.tabPanel.setSelectedIndex(this.tabPanel.getTabCount() - 1);
                this.memory.add(string);
                this.enabledMenu();
            } else {
                int n = this.tabPanel.indexOfTab("Error ");
                JScrollPane jScrollPane = (JScrollPane)this.tabPanel.getComponentAt(n);
                JTextArea jTextArea = (JTextArea)jScrollPane.getViewport().getComponent(0);
                jTextArea.append("Error decompiling " + string2 + System.getProperty("line.separator"));
            }
            this.toFront();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private JPanel buildTextAreaPanel(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createLineBorder(new Color(255, 255, 255), 2));
        JTextArea jTextArea = new JTextArea();
        SyntaxSupport syntaxSupport = SyntaxSupport.getInstance();
        syntaxSupport.setPrintMarginWidth(80);
        syntaxSupport.addSupport(1001, jTextArea);
        jTextArea.getDocument().putProperty("tabSize", 8);
        jTextArea.setSelectionColor(new Color(184, 207, 229));
        jTextArea.setText(string);
        jTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        Gutter gutter = new Gutter(jTextArea, jScrollPane);
        jScrollPane.setRowHeaderView(new Gutter(jTextArea, jScrollPane));
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JMenuBar buildMenu() {
        this.menuBar = new JMenuBar();
        this.file = new JMenu("File");
        this.save = new JMenuItem("Save");
        this.save.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File file = SingletonCodePanel.this.showFileChooser();
                if (file != null) {
                    SingletonCodePanel.this.saveFile(file);
                }
            }
        });
        this.close = new JMenuItem("Close");
        this.close.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SingletonCodePanel.this.tabPanel.getTabCount() > 0) {
                    String string = SingletonCodePanel.this.tabPanel.getTitleAt(SingletonCodePanel.this.tabPanel.getSelectedIndex());
                    SingletonCodePanel.this.memory.remove(string);
                    SingletonCodePanel.this.tabPanel.remove(SingletonCodePanel.this.tabPanel.getSelectedIndex());
                }
                if (SingletonCodePanel.this.tabPanel.getTabCount() == 0) {
                    SingletonCodePanel.this.disabledMenu();
                }
            }
        });
        this.closeAll = new JMenuItem("Close all");
        this.closeAll.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.closeAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SingletonCodePanel.this.closeAllTabs();
            }
        });
        this.exit = new JMenuItem("Exit");
        this.exit.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SingletonCodePanel.this.closeAllTabs();
                SingletonCodePanel.this.dispose();
                SingletonCodePanel.singletonCodePanel = null;
            }
        });
        this.file.add(this.save);
        this.file.add(this.close);
        this.file.add(this.closeAll);
        this.file.add(new JSeparator());
        this.file.add(this.exit);
        this.menuBar.add(this.file);
        return this.menuBar;
    }

    private void saveFile(File file) {
        JPanel jPanel = (JPanel)this.tabPanel.getSelectedComponent();
        JScrollPane jScrollPane = (JScrollPane)jPanel.getComponent(0);
        JTextArea jTextArea = (JTextArea)jScrollPane.getViewport().getComponent(0);
        String string = jTextArea.getText();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(string.getBytes());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private File showFileChooser() {
        JFileChooser jFileChooser = new JFileChooser();
        String string = this.tabPanel.getTitleAt(this.tabPanel.getSelectedIndex());
        File file = new File(string);
        jFileChooser.setSelectedFile(file);
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            File file2 = jFileChooser.getSelectedFile();
            return file2;
        }
        return null;
    }

    private JPanel buildProgressBarPanel() {
        this.progressBarPanel = new JPanel();
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        this.progressBarPanel.setLayout(new BorderLayout());
        this.progressBarPanel.setBorder(BorderFactory.createLineBorder(new Color(255, 255, 255), 2));
        this.progressBarPanel.add((Component)this.progressBar, "Center");
        return this.progressBarPanel;
    }

    public void updateProgress(double d, String string) {
        this.progressBar.setValue((int)(d * 100.0));
    }

    private void disabledMenu() {
        this.save.setEnabled(false);
        this.close.setEnabled(false);
        this.closeAll.setEnabled(false);
    }

    private void enabledMenu() {
        this.save.setEnabled(true);
        this.close.setEnabled(true);
        this.closeAll.setEnabled(true);
    }

    private void closeAllTabs() {
        this.memory.clear();
        this.disabledMenu();
        this.tabPanel.removeAll();
    }

    public void enabledProgressPanel() {
        this.progressBar.setValue(0);
        this.progressBarPanel.setVisible(true);
        this.repaint();
    }

    public void disabledProgressPanel() {
        this.progressBarPanel.setVisible(false);
        this.repaint();
    }
}

