/* *******************************************************
 * 
 * name:          StripeLayout.java
 * 
 * description:   Layout manager that sets up the components
 *                in lines
 *
 * Author:        Florian Bomers
 *
 * (c) 1997       JaWavedit-Team
 *                JaWavedit@bome.com
 *
 ********************************************************* */

import java.awt.*;

/**
 * A Layout-manager that displays the added components
 * in lines. The width of this layout is determined by
 * the widest component that was added. The height of
 * each stripe is the preferred height of the
 * respective component.<BR>
 * See CreateTones.java for an example.
 */
public class StripeLayout implements LayoutManager {

  public StripeLayout() {
  }

  public void addLayoutComponent(String name, Component comp) {
  }
  /**
  * enleve le layout.
  * @param Component comp) {
  * @see
  * @return
  */
  public void removeLayoutComponent(Component comp) {
  }
  /**
  * calcul les dimensions du layout.
  * @param boolean preferred pour utilisation des dimensions preferees
  * @return
  */
  private Dimension calcSize(Container parent,boolean preferred) {
    
    Dimension dim = new Dimension(0, 0);
    int nmembers=parent.getComponentCount();
    Dimension d;
    for (int i = 0 ; i < nmembers ; i++) {
      Component m = parent.getComponent(i);
      if (m.isVisible()) {
        if (preferred)
          d=m.getPreferredSize();
        else
          d=m.getMinimumSize();
        
        if (dim.width<d.width) dim.width=d.width;
        dim.height += d.height;
      }
    }
    Insets insets = parent.getInsets();
    dim.width += insets.left + insets.right;
    dim.height += insets.top + insets.bottom;
    return dim;
  }

  /**
  * retourne les dimensions preferees pour le layout.
  * compte tenu de la taille des composants
  * Les places dans le container cible
  * @param target le composant a appliquer sur le layout
  */
  public Dimension preferredLayoutSize(Container target) {
    return calcSize(target,true);
  }
/**
  * retourne les dimensions minimales pour le layout.
  * compte tenu de la taille des composants.
  * Les places dans le container cible
  * @param target le composant a appliquer sur le layout
  * * @see #preferredLayoutSize
  */

  public Dimension minimumLayoutSize(Container target) {
    return calcSize(target,false);
  }

  /**
  * application du layout sur le container.
  * @param target le composant a appliquer sur le layout
  */
  public void layoutContainer(Container target) {
    // insanity check,
    Insets insets = target.getInsets();
    
    int x = insets.left;
    int y = insets.top;

    int width=target.getSize().width;
    int maxY=target.getSize().height-insets.bottom;

    int nmembers=target.getComponentCount();
    for (int i = 0 ; i < nmembers && y < maxY ; i++) {
      Component m = target.getComponent(i);
      if (m.isVisible()) {
        m.setBounds(x, y, width, m.getPreferredSize().height);
        y+=m.getSize().height;
      }
    }
  }
  
  
}