@echo off
rem  Batch to run JaWavedit on Windows systems.
rem .
rem  1. Commandline options
rem     -Dmodule.path=[path] : Specifies an additional path to
rem        a directory with modules. e.g.:
rem        javaw -Dmodule.path=C:\ JaWavedit %1
rem        The module directory must be named JWModules, ie
rem        C:\JWModules
rem     -Dtest.debug=[on / off] : Debug mode on or off. Debug
rem        mode will print additional informations and errors
rem        to standard out. This might get handy when testing
rem        own modules and JaWavedit does not load them correctly.
rem        For this, you need to use java instead of javaw, to
rem        have a terminal window (the dos box) where the messages
rem        appear. Example:
rem        java -Dtest.debug=on JaWavedit %1
rem     -mx[Number]m : Sets maximum memory that can be used by
rem        JaWavedit. Especially when undo is enabled, JaWavedit
rem        might need a lot of memory  (default: 16 MB).
rem        [Number] is in megabytes.
rem        Example: set to 48MB: 
rem        javaw -mx48m JaWavedit %1
rem .
rem  2. Loading of modules
rem     JaWavedit looks for modules (in sub-directory JWModules)
rem     in these directories in this order:
rem     - module.path when given in command line (see above)
rem     - $HOME , homedir of user (this is set by javaw to:
rem       Windows 95: install path of JDK (eg C:\jdk1.1.4\ )
rem       Windows NT: root of NT installation drive (eg D:\ )
rem     - ./ , the path from where JaWavedit_run was executed
rem     - the user-defined path (in $HOME/.JaWavedit.conf)
rem       this is not implemented yet
rem     It loads all valid modules that are found.
rem .
rem  3. Configuration file
rem     The configuration file .JaWavedit.conf is stored
rem     in the $HOME directory (see above).
rem     It shouldn't be modified by hand.
rem .
rem  4. What is "javaw" and "jrew" ?
rem     this is a virtual machine for Windows that doesn't
rem     use a dos box. Consequently, you may specify as
rem     options of the icon you created on the desktop 
rem     (see readme.txt how to install an icon) 
rem     "execute iconic" and "close automatically when 
rem     finished". To get the options, click with right on
rem     the icon and choose "Properties".
rem .
rem  5. If you use the Java(tm) Runtime Environment
rem     you should activate the apropriate section (see below)
rem     or use the apropriate .bat
rem .   
rem  6. Anymore questions ? 
rem     mail to: boemers@rumms.uni-mannheim.de
rem .

rem using JDK
rem set CLASSPATH=.;JaWavedit.jar
rem javaw JaWavedit %1

rem using JRE
jrew -mx32m -cp .;JaWavedit.jar JaWavedit %1
