/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class IniFile {
    private static String filename = null;
    private static Properties props = null;
    private static Vector listeners = new Vector();

    protected static boolean save() {
        if (filename != null && props != null && !((Hashtable)props).isEmpty()) {
            FileOutputStream fileOutputStream;
            try {
                fileOutputStream = new FileOutputStream(filename);
            }
            catch (IOException iOException) {
                return false;
            }
            return IniFile.save(fileOutputStream);
        }
        return false;
    }

    protected static boolean save(OutputStream outputStream) {
        if (filename != null && props != null) {
            if (!((Hashtable)props).isEmpty()) {
                props.save(outputStream, "Configuration file for JaWavedit. Do not change !");
            }
            return true;
        }
        return false;
    }

    private static boolean load() {
        if (filename != null) {
            FileInputStream fileInputStream;
            try {
                fileInputStream = new FileInputStream(filename);
            }
            catch (IOException iOException) {
                return false;
            }
            return IniFile.load(fileInputStream);
        }
        return false;
    }

    private static boolean load(InputStream inputStream) {
        if (filename != null) {
            IniFile.checkProps();
            try {
                props.load(inputStream);
            }
            catch (IOException iOException) {
                return false;
            }
            return true;
        }
        return false;
    }

    public static String getProperty(String string, String string2) {
        if (Globals.inApplet) {
            String string3 = Globals.applet.getParameter(string);
            if (string3 != null && string3 != "") {
                return string3;
            }
            return string2;
        }
        try {
            return System.getProperty(string, string2);
        }
        catch (Throwable throwable) {
            return string2;
        }
    }

    protected static String read(String string, String string2, String string3) {
        if (Globals.inApplet) {
            String string4 = Globals.applet.getParameter(String.valueOf(string) + "." + string2);
            if (string4 != null && string4 != "") {
                return string4;
            }
            return string3;
        }
        IniFile.checkProps();
        return props.getProperty(String.valueOf(string) + "." + string2, string3);
    }

    protected static void write(String string, String string2, String string3) {
        if (Globals.inApplet) {
            return;
        }
        IniFile.checkProps();
        ((Hashtable)props).put(String.valueOf(string) + "." + string2, string3);
    }

    public static String readString(String string, String string2, String string3) {
        return IniFile.read(string, string2, string3);
    }

    public static void writeString(String string, String string2, String string3) {
        IniFile.write(string, string2, string3);
        IniFile.sendEvent(string, string2, string3, 0, false);
    }

    public static int readInteger(String string, String string2, int n) {
        try {
            return Integer.valueOf(IniFile.read(string, string2, String.valueOf(n)));
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static void writeInteger(String string, String string2, int n) {
        IniFile.write(string, string2, String.valueOf(n));
        IniFile.sendEvent(string, string2, null, n, false);
    }

    public static boolean readBool(String string, String string2, boolean bl) {
        boolean bl2 = bl;
        String string3 = IniFile.read(string, string2, bl ? "true" : "false");
        if (string3.equalsIgnoreCase("true")) {
            bl2 = true;
        } else if (string3.equalsIgnoreCase("false")) {
            bl2 = false;
        }
        return bl2;
    }

    public static void writeBool(String string, String string2, boolean bl) {
        IniFile.write(string, string2, bl ? "true" : "false");
        IniFile.sendEvent(string, string2, null, 0, bl);
    }

    protected static void setFilename(String string) {
        filename = string;
    }

    private static void checkProps() {
        if (Globals.inApplet) {
            return;
        }
        if (props == null) {
            props = new Properties();
            try {
                if (filename != null) {
                    IniFile.load();
                    return;
                }
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    public static void addIniListener(IniListener iniListener) {
        listeners.addElement(iniListener);
    }

    public static void removeIniListener(IniListener iniListener) {
        listeners.removeElement(iniListener);
    }

    private static void sendEvent(String string, String string2, String string3, int n, boolean bl) {
        int n2 = 0;
        while (n2 < listeners.size()) {
            ((IniListener)listeners.elementAt(n2)).iniChange(string, string2, string3, n, bl);
            ++n2;
        }
    }
}

