/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;

public class EditFrame
extends Frame
implements WindowListener,
ActionListener,
ItemListener,
KeyListener,
JWListener,
IniListener,
HintFrame,
ModuleFrame {
    public static final int NEW = 1;
    public static final int OPEN = 2;
    public static final int SAVE = 3;
    public static final int UNDO = 4;
    public static final int CUT = 5;
    public static final int COPY = 6;
    public static final int PASTE = 7;
    public static final int PASTEMIX = 8;
    public static final int ZOOMIN = 9;
    public static final int ZOOMOUT = 10;
    public static final int ZOOMALL = 11;
    public static final int EXIT = 12;
    public static final int HELP = 13;
    protected static final String JarName = "JaWavedit.jar";
    protected static String JarPath = Loader.findFile("JaWavedit.jar");
    protected static final String imageDir = "images";
    protected static String imagePath = EditFrame.getImagePath();
    protected static String aboutFile = "jawavedit.gif";
    protected static final String helpDir = "help";
    protected static String helpFile = String.valueOf(Lang.getStr(1002)) + ".txt";
    protected static String helpPath = EditFrame.getHelpPath();
    protected static String EtatIdleText = Lang.getStr(1001);
    protected static final String MCP_TITLE = "Master Control Panel";
    protected static final String BACKGROUND_IMAGE = "splash.gif";
    protected ZoomGraph zoomGraph;
    protected McP mcp;
    protected WaveFile wf;
    protected Player player;
    protected Undo undo;
    protected MsgDlg msgDlg;
    protected HintWindow hintWindow;
    protected static Aide helpWindow = null;
    private Panel PBottom;
    private Panel PEtat;
    private Panel PPlayer;
    private Label Etat;
    private Panel PInfos;
    private Panel PInfoLabels;
    private Label LInfo1;
    private Label LInfo2;
    protected MenuBar MenuPrincipal;
    protected Menu MFichier;
    private MenuItem MNew;
    private MenuItem MNewInstance;
    private MenuItem MQuitter;
    private MenuItem MOuvrir;
    private MenuItem MEnregistrer;
    private MenuItem MEnregistrerSous;
    private MenuItem MRevert;
    private MenuItem MFormat;
    protected Menu MEditeur;
    private MenuItem MUndo;
    private MenuItem MCut;
    private MenuItem MCopy;
    private MenuItem MPaste;
    private MenuItem MPasteMix;
    private MenuItem MFrequency;
    protected Menu MModules;
    protected Menu MSelection;
    private MenuItem MSelNone;
    private MenuItem MSelAll;
    private MenuItem MGauche;
    private MenuItem MEnsemble;
    private MenuItem MDroite;
    private MenuItem MSelToEnd;
    private MenuItem MSelToStart;
    protected Menu MZoom;
    private MenuItem MZoomIn;
    private MenuItem MZoomOut;
    private MenuItem MZoomAll;
    protected Menu MView;
    private MenuItem MPlayer;
    private MenuItem MDebugWindow;
    protected Menu MOptions;
    private CheckboxMenuItem MEnableUndo;
    private Menu MLanguage;
    private CheckboxMenuItem[] MLanguages;
    private Menu MModuleOptions;
    protected Menu MAPropos;
    private MenuItem MAProposJaWavedit;
    private MenuItem MAide;
    private Panel PNorth;
    protected Toolbar toolbar;
    protected String TitleText;
    private int instanceNr;

    /*
     * Exception decompiling
     */
    public EditFrame() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Attempt to fetch element 0 from constant pool
         *     at org.benf.cfr.reader.entities.constantpool.ConstantPool.getEntry(ConstantPool.java:155)
         *     at org.benf.cfr.reader.entities.constantpool.ConstantPool.getUTF8Entry(ConstantPool.java:164)
         *     at org.benf.cfr.reader.bytecode.analysis.variables.VariableNamerHinted.getName(VariableNamerHinted.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.lvalue.LocalVariable.<init>(LocalVariable.java:34)
         *     at org.benf.cfr.reader.bytecode.analysis.variables.VariableFactory.localVariable(VariableFactory.java:81)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.mkRetrieve(Op02WithProcessedDataAndRefs.java:935)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:983)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public EditFrame(int n, int n2) {
        this.TitleText = String.valueOf(Globals.name) + " " + Globals.version + " ";
        this.instanceNr = 0;
        this.hintWindow = new HintWindow(this);
        this.hintWindow.setEnabled(true);
        this.undo = new Undo();
        this.undo.addJWListener(this);
        Edit.addJWListener(this);
        IniFile.addIniListener(this);
        this.msgDlg = new MsgDlg(this, Globals.name, Lang.getStr(4), Lang.getStr(5), Lang.getStr(0), Lang.getStr(1));
        if (helpWindow == null) {
            helpWindow = new Aide(String.valueOf(helpPath) + helpFile);
        }
        this.zoomGraph = new ZoomGraph(String.valueOf(imagePath) + BACKGROUND_IMAGE);
        this.zoomGraph.BGauche.addListener(this);
        this.zoomGraph.BGauche.setHintWindow(this.hintWindow, Lang.getStr(1003));
        this.zoomGraph.BDroite.addListener(this);
        this.zoomGraph.BDroite.setHintWindow(this.hintWindow, Lang.getStr(1004));
        this.zoomGraph.BEnsemble.addListener(this);
        this.zoomGraph.BEnsemble.setHintWindow(this.hintWindow, Lang.getStr(1005));
        this.player = new Player();
        this.player.addWaveTrackerListener(this.zoomGraph);
        this.player.addWaveStreamListener(this.zoomGraph);
        WaveFileBase.NOT_SUPPORTED_S = Lang.getStr(1054);
        WaveFileBase.IS_CORRUPT_S = Lang.getStr(1055);
        WaveFileBase.ERROR_OPENING_S = Lang.getStr(1056);
        WaveFileBase.ERROR_SAVING_S = Lang.getStr(1057);
        WaveFileBase.NOT_CREATE = Lang.getStr(1032);
        WaveFileBase.NEITHER_WAV_AU_S = Lang.getStr(1058);
        WaveFile.OPERATION_CANCELLED = Lang.getStr(32);
        this.wf = new WaveFile(this, this.player);
        this.wf.setSFTName(String.valueOf(Globals.name) + " " + Globals.version);
        this.Etat = new Label(EtatIdleText);
        this.Etat.setAlignment(0);
        this.PEtat = new Panel();
        this.PEtat.setLayout(new BorderLayout());
        this.PEtat.add("South", this.Etat);
        this.PBottom = new Panel();
        this.PBottom.setLayout(new BorderLayout());
        this.PBottom.add("South", this.PEtat);
        this.setUpInfos();
        this.PBottom.add("North", this.PInfos);
        this.PNorth = new Panel();
        this.PNorth.setLayout(new BorderLayout());
        this.PNorth.add("North", new HoriLine());
        this.setUpToolbar();
        this.PNorth.add("Center", this.toolbar);
        this.setUpMenus();
        this.setClipboardEnabled(Edit.getValid());
        ((Component)this).setBackground(Color.lightGray);
        this.setLayout(new BorderLayout());
        this.add("Center", this.zoomGraph);
        this.add("South", this.PBottom);
        this.add("North", this.PNorth);
        this.pack();
        if (n > 0 && n2 > 0) {
            ((Component)this).setSize(n, n2);
        }
        this.addWindowListener(this);
        this.addKeyListener(this);
        this.setInfos();
        this.zoomGraph.afficheSel();
        this.zoomGraph.afficheZoom();
        McP.ScrollerName[0] = Lang.getStr(1040);
        McP.ScrollerName[1] = Lang.getStr(1041);
        McP.ScrollerName[2] = Lang.getStr(1042);
        McP.S_REWIND = Lang.getStr(1043);
        McP.S_PLAY = Lang.getStr(1044);
        McP.S_FORWARD = Lang.getStr(1045);
        McP.S_PAUSE = Lang.getStr(1046);
        McP.S_STOP = Lang.getStr(1047);
        McP.S_LOOP = Lang.getStr(1048);
        this.mcp = new McP((Frame)this, MCP_TITLE, this.player, imagePath);
        ((Component)this.mcp).setBounds(this.getLocation().x + this.getSize().width + 10, this.getLocation().y, this.mcp.getSize().width, this.mcp.getSize().height);
        this.mcp.show();
    }

    protected void setUpMenus() {
        this.MenuPrincipal = new MenuBar();
        this.MFichier = new Menu(Lang.getStr(6));
        this.MNew = new MenuItem(Lang.getStr(7));
        this.MNew.addActionListener(this);
        this.MOuvrir = new MenuItem(Lang.getStr(8));
        this.MOuvrir.addActionListener(this);
        this.MEnregistrer = new MenuItem(Lang.getStr(9));
        this.MEnregistrer.addActionListener(this);
        this.MEnregistrerSous = new MenuItem(Lang.getStr(10));
        this.MEnregistrerSous.addActionListener(this);
        this.MRevert = new MenuItem(Lang.getStr(13));
        this.MRevert.addActionListener(this);
        this.MFormat = new MenuItem(Lang.getStr(1006));
        this.MFormat.addActionListener(this);
        this.MNewInstance = new MenuItem(Lang.getStr(14));
        this.MNewInstance.addActionListener(this);
        this.MQuitter = new MenuItem(Lang.getStr(15));
        this.MQuitter.addActionListener(this);
        this.MFichier.add(this.MNew);
        this.MFichier.add(this.MOuvrir);
        this.MFichier.add(this.MEnregistrer);
        this.MFichier.add(this.MEnregistrerSous);
        this.MFichier.add(this.MRevert);
        this.MFichier.add(new MenuItem("-"));
        this.MFichier.add(this.MFormat);
        this.MFichier.add(this.MNewInstance);
        this.MFichier.add(new MenuItem("-"));
        this.MFichier.add(this.MQuitter);
        this.MenuPrincipal.add(this.MFichier);
        this.MEditeur = new Menu(Lang.getStr(16));
        this.MUndo = new MenuItem(Lang.getStr(17));
        this.MUndo.addActionListener(this);
        this.MUndo.setEnabled(false);
        this.MCut = new MenuItem(Lang.getStr(18));
        this.MCut.addActionListener(this);
        this.MCopy = new MenuItem(Lang.getStr(19));
        this.MCopy.addActionListener(this);
        this.MPaste = new MenuItem(Lang.getStr(20));
        this.MPaste.addActionListener(this);
        this.MPasteMix = new MenuItem(Lang.getStr(1007));
        this.MPasteMix.addActionListener(this);
        this.MEditeur.add(this.MUndo);
        this.MEditeur.add(new MenuItem("-"));
        this.MEditeur.add(this.MCut);
        this.MEditeur.add(this.MCopy);
        this.MEditeur.add(this.MPaste);
        this.MEditeur.add(this.MPasteMix);
        this.MenuPrincipal.add(this.MEditeur);
        this.MModules = new Menu(Lang.getStr(1008));
        this.MenuPrincipal.add(this.MModules);
        this.MSelection = new Menu(Lang.getStr(22));
        this.MSelNone = new MenuItem(Lang.getStr(23));
        this.MSelNone.addActionListener(this);
        this.MSelAll = new MenuItem(Lang.getStr(24));
        this.MSelAll.addActionListener(this);
        this.MGauche = new MenuItem(Lang.getStr(1009));
        this.MGauche.addActionListener(this);
        this.MEnsemble = new MenuItem(Lang.getStr(1011));
        this.MEnsemble.addActionListener(this);
        this.MDroite = new MenuItem(Lang.getStr(1010));
        this.MDroite.addActionListener(this);
        this.MSelToEnd = new MenuItem(Lang.getStr(1013));
        this.MSelToEnd.addActionListener(this);
        this.MSelToStart = new MenuItem(Lang.getStr(1012));
        this.MSelToStart.addActionListener(this);
        this.MSelection.add(this.MSelNone);
        this.MSelection.add(this.MSelAll);
        this.MSelection.add(new MenuItem("-"));
        this.MSelection.add(this.MGauche);
        this.MSelection.add(this.MEnsemble);
        this.MSelection.add(this.MDroite);
        this.MSelection.add(new MenuItem("-"));
        this.MSelection.add(this.MSelToEnd);
        this.MSelection.add(this.MSelToStart);
        this.MenuPrincipal.add(this.MSelection);
        this.MZoom = new Menu(Lang.getStr(1014));
        this.MZoomIn = new MenuItem(Lang.getStr(1015));
        this.MZoomIn.addActionListener(this);
        this.MZoomOut = new MenuItem(Lang.getStr(1016));
        this.MZoomOut.addActionListener(this);
        this.MZoomAll = new MenuItem(Lang.getStr(1017));
        this.MZoomAll.addActionListener(this);
        this.MZoom.add(this.MZoomIn);
        this.MZoom.add(this.MZoomOut);
        this.MZoom.add(this.MZoomAll);
        this.MenuPrincipal.add(this.MZoom);
        this.MView = new Menu(Lang.getStr(25));
        this.MPlayer = new MenuItem(MCP_TITLE);
        this.MPlayer.addActionListener(this);
        this.MView.add(this.MPlayer);
        this.MDebugWindow = new MenuItem("Debug");
        this.MDebugWindow.addActionListener(this);
        this.MView.add(this.MDebugWindow);
        this.MenuPrincipal.add(this.MView);
        this.MOptions = new Menu(Lang.getStr(45));
        this.MEnableUndo = new CheckboxMenuItem(Lang.getStr(1018), true);
        this.MEnableUndo.addItemListener(this.undo);
        this.MOptions.add(this.MEnableUndo);
        this.MLanguage = new Menu(Lang.getStr(47));
        this.MLanguages = new CheckboxMenuItem[LangBase.getLangCount()];
        int n = 0;
        while (n < LangBase.getLangCount()) {
            this.MLanguages[n] = new CheckboxMenuItem(LangBase.getLangName(n), n == LangBase.getLangIndex());
            if (Globals.inApplet) {
                this.MLanguages[n].setEnabled(false);
            } else {
                this.MLanguages[n].addItemListener(this);
            }
            this.MLanguage.add(this.MLanguages[n]);
            ++n;
        }
        this.MOptions.add(this.MLanguage);
        this.MModuleOptions = new Menu(Lang.getStr(1008));
        this.MOptions.add(this.MModuleOptions);
        this.MenuPrincipal.add(this.MOptions);
        this.MAPropos = new Menu(Lang.getStr(26));
        this.MAide = new MenuItem(Lang.getStr(27));
        this.MAide.addActionListener(this);
        this.MAProposJaWavedit = new MenuItem(String.valueOf(Lang.getStr(28)) + " " + Globals.name);
        this.MAProposJaWavedit.addActionListener(this);
        this.MAPropos.add(this.MAide);
        this.MAPropos.add(this.MAProposJaWavedit);
        this.MenuPrincipal.add(this.MAPropos);
        this.setMenuBar(this.MenuPrincipal);
    }

    protected void setUpToolbar() {
        this.toolbar = new Toolbar(String.valueOf(imagePath) + "toolbg.gif");
        this.toolbar.addButton(String.valueOf(imagePath) + "new.gif", 1, 2, this, this.hintWindow, Lang.getStr(7));
        this.toolbar.addButton(String.valueOf(imagePath) + "open.gif", 2, 2, this, this.hintWindow, Lang.getStr(8));
        this.toolbar.addButton(String.valueOf(imagePath) + "save.gif", 3, 2, this, this.hintWindow, Lang.getStr(9));
        this.toolbar.addSeparator();
        this.toolbar.addButton(String.valueOf(imagePath) + "undo.gif", 4, 2, this, this.hintWindow, Lang.getStr(17));
        this.toolbar.addButton(String.valueOf(imagePath) + "cut.gif", 5, 2, this, this.hintWindow, Lang.getStr(18));
        this.toolbar.addButton(String.valueOf(imagePath) + "copy.gif", 6, 2, this, this.hintWindow, Lang.getStr(19));
        this.toolbar.addButton(String.valueOf(imagePath) + "paste.gif", 7, 2, this, this.hintWindow, Lang.getStr(20));
        this.toolbar.addButton(String.valueOf(imagePath) + "pastemix.gif", 8, 2, this, this.hintWindow, Lang.getStr(1007));
        this.toolbar.addSeparator();
        this.toolbar.addButton(String.valueOf(imagePath) + "zoomin.gif", 9, 2, this, this.hintWindow, Lang.getStr(1015));
        this.toolbar.addButton(String.valueOf(imagePath) + "zoomout.gif", 10, 2, this, this.hintWindow, Lang.getStr(1016));
        this.toolbar.addButton(String.valueOf(imagePath) + "zoomall.gif", 11, 2, this, this.hintWindow, Lang.getStr(1017));
        this.toolbar.addSeparator();
        this.toolbar.addButton(String.valueOf(imagePath) + "exit.gif", 12, 2, this, this.hintWindow, Lang.getStr(1021));
        this.toolbar.addButton(String.valueOf(imagePath) + "help.gif", 13, 2, this, this.hintWindow, Lang.getStr(26));
        this.toolbar.setRound(true);
    }

    protected void setUpInfos() {
        this.PInfos = new Panel();
        this.PInfos.setLayout(new BorderLayout());
        this.PInfoLabels = new Panel();
        this.PInfoLabels.setLayout(new FlowLayout(0, 0, 0));
        this.LInfo1 = new Label("Stereo, 44100Hz, 16bit ..");
        this.LInfo2 = new Label(String.valueOf(Lang.getStr(1022)) + ": 00000000000 " + Lang.getStr(1023) + " 00:00:000 m:s:ms");
        this.PInfoLabels.add(this.LInfo1);
        this.PInfoLabels.add(this.LInfo2);
        this.PInfos.add("Center", this.PInfoLabels);
        this.PInfos.add("North", new HoriLine());
        this.PInfos.add("South", new HoriLine());
    }

    public void init() {
        this.init(null);
    }

    public void init(String string) {
        ModulePack.init(this, (ModuleFrame)JaWavedit.getPrevInstance(this));
        if (string != null) {
            this.charger(string);
        }
    }

    public void destroy() {
        this.undo.removeJWListener(this);
        Edit.removeJWListener(this);
        IniFile.removeIniListener(this);
    }

    public Label getStatusLabel() {
        return this.Etat;
    }

    public Menu getModuleMenu() {
        return this.MModules;
    }

    public Menu getModuleOptionsMenu() {
        return this.MModuleOptions;
    }

    public Vector getInstances() {
        return JaWavedit.getInstances();
    }

    public HintWindow getHintWindow() {
        return this.hintWindow;
    }

    private void setInfos() {
        String string = this.instanceNr > 0 ? String.valueOf(this.TitleText) + " <" + this.instanceNr + ">" : this.TitleText;
        string = String.valueOf(string) + " - " + this.wf.extractFileName();
        if (this.wf.getChanged()) {
            string = String.valueOf(string) + " *";
        }
        this.setTitle(string);
        this.LInfo1.setText(String.valueOf(this.wf.isMono() ? "Mono" : "Stereo") + ", " + this.wf.getFrequency() + "Hz, " + this.wf.getResolution() + "bit");
        long l = this.wf.samplesToMs(this.wf.getSize());
        this.LInfo2.setText(String.valueOf(Lang.getStr(1022)) + ": " + this.wf.getSize() + Lang.getStr(1023) + " " + l / 60000L + ":" + l % 60000L / 1000L + ":" + l % 1000L + "m:s:ms");
    }

    public void setInstanceNr(int n) {
        if (this.instanceNr != n) {
            this.instanceNr = n;
            this.setInfos();
            if (n != 0) {
                this.mcp.setTitle("<" + n + ">" + MCP_TITLE);
                return;
            }
            this.mcp.setTitle(MCP_TITLE);
        }
    }

    protected boolean saveQuestion() {
        if (this.wf.getChanged()) {
            String[] stringArray = new String[]{StringTool.sprintf(Lang.getStr(29), this.wf.extractFileName())};
            int n = this.msgDlg.show(stringArray, 11);
            if (n == 1) {
                this.Enregistrer(true);
            }
            return n != 8;
        }
        return true;
    }

    public void NewClick() {
        if (!this.saveQuestion()) {
            return;
        }
        this.undo.delBuffer();
        this.wf.createNew();
        this.FormatClick();
        this.wf.setChanged(false);
        this.zoomGraph.WaveChange(this.wf.getLeftWave(), this.wf.getRightWave());
    }

    protected void charger(String string) {
        if (!this.saveQuestion()) {
            return;
        }
        try {
            this.Etat.setText(Lang.getStr(30));
            this.undo.delBuffer();
            this.zoomGraph.initWave(this.wf.getLeftWave(), this.wf.getRightWave());
            this.wf.createNew();
            if (string == null) {
                this.wf.load();
            } else {
                this.wf.load(string);
            }
            if (!this.wf.isEmpty()) {
                this.Etat.setText(StringTool.sprintf(Lang.getStr(33), this.wf.getName()));
                this.mcp.setEnsemble();
            } else {
                this.Etat.setText(Lang.getStr(32));
            }
        }
        catch (Throwable throwable) {
            this.errorHandler(throwable, Lang.getStr(8));
            this.wf.createNew();
        }
        this.zoomGraph.initWave(this.wf.getLeftWave(), this.wf.getRightWave());
        this.setInfos();
    }

    protected void Enregistrer(boolean bl) {
        try {
            if (bl && !this.FormatClick()) {
                return;
            }
            this.Etat.setText(Lang.getStr(31));
            if (bl) {
                this.wf.saveAs();
            } else {
                this.wf.save();
            }
            this.Etat.setText(StringTool.sprintf(Lang.getStr(34), this.wf.getName()));
        }
        catch (Throwable throwable) {
            this.errorHandler(throwable, Lang.getStr(9));
        }
        this.setInfos();
    }

    public boolean FormatClick() {
        SaveD saveD = null;
        try {
            saveD = new SaveD((Frame)this, this.wf);
            ((Component)saveD).setVisible(true);
            if (saveD.annulle) {
                throw new Exception(Lang.getStr(32));
            }
            saveD.dispose();
            Thread.currentThread();
            Thread.yield();
            this.show();
            this.requestFocus();
        }
        catch (Throwable throwable) {
            this.errorHandler(throwable, Lang.getStr(1006));
            this.setInfos();
            return false;
        }
        this.setInfos();
        return true;
    }

    private void CloseClick() {
        if (!this.saveQuestion()) {
            return;
        }
        if (this.player.isPlaying()) {
            this.player.stop();
        }
        while (this.player.isPlaying()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.mcp.dispose();
        this.hintWindow.dispose();
        JaWavedit.kill(this);
    }

    private boolean store(String string) {
        if (this.undo.getEnabled()) {
            try {
                this.Etat.setText(Lang.getStr(39));
                this.Etat.invalidate();
                this.undo.store(this.wf, this.zoomGraph.getSelection(), this.zoomGraph.getZoom(), string);
                this.Etat.setText(String.valueOf(this.MUndo.getLabel()) + " " + Lang.getStr(37) + ".");
            }
            catch (Throwable throwable) {
                this.errorHandler(throwable, Lang.getStr(39));
                String[] stringArray = new String[]{Lang.getStr(41), Lang.getStr(42), Lang.getStr(43)};
                return this.msgDlg.show(stringArray, 11) == 1;
            }
        }
        return true;
    }

    private void UndoClick() {
        if (this.undo.getValid()) {
            try {
                this.undo.undo(this.wf, this.zoomGraph.getSelection(), this.zoomGraph.getZoom());
                this.zoomGraph.WaveChange(this.wf.getLeftWave(), this.wf.getRightWave());
                this.Etat.setText(String.valueOf(this.MUndo.getLabel()) + " " + Lang.getStr(37) + ".");
            }
            catch (Throwable throwable) {
                this.errorHandler(throwable, this.MUndo.getLabel());
            }
        } else {
            this.Etat.setText(Lang.getStr(44));
        }
        this.setInfos();
    }

    private void CutClick() {
        if (this.store(this.MCut.getLabel())) {
            try {
                Edit.cut(this.wf, this.zoomGraph.getSelection());
                this.zoomGraph.WaveChange(this.wf.getLeftWave(), this.wf.getRightWave());
                this.Etat.setText(String.valueOf(this.MCut.getLabel()) + " " + Lang.getStr(37) + ".");
            }
            catch (Throwable throwable) {
                this.errorHandler(throwable, this.MCut.getLabel());
            }
        }
        this.setInfos();
    }

    private void CopyClick() {
        try {
            Edit.copy(this.wf, this.zoomGraph.getSelection());
            this.Etat.setText(String.valueOf(this.MCopy.getLabel()) + " " + Lang.getStr(37) + ".");
            return;
        }
        catch (Throwable throwable) {
            this.errorHandler(throwable, this.MCopy.getLabel());
            return;
        }
    }

    private void PasteClick() {
        if (this.store(this.MPaste.getLabel())) {
            try {
                int n = Edit.paste(this.wf, this.zoomGraph.getSelection());
                this.zoomGraph.WaveChange(this.wf.getLeftWave(), this.wf.getRightWave(), n);
                this.Etat.setText(String.valueOf(this.MPaste.getLabel()) + " " + Lang.getStr(37) + ".");
            }
            catch (Throwable throwable) {
                this.errorHandler(throwable, this.MPaste.getLabel());
            }
        }
        this.setInfos();
    }

    private void PasteMixClick() {
        if (this.store(this.MPasteMix.getLabel())) {
            try {
                int n = Edit.pasteMix(this.wf, this.zoomGraph.getSelection());
                this.zoomGraph.WaveChange(this.wf.getLeftWave(), this.wf.getRightWave(), n);
                this.Etat.setText(String.valueOf(this.MPasteMix.getLabel()) + " " + Lang.getStr(37) + ".");
            }
            catch (Throwable throwable) {
                this.errorHandler(throwable, this.MPasteMix.getLabel());
            }
        }
        this.setInfos();
    }

    private void setUndoEnabled(String string, boolean bl) {
        this.MUndo.setLabel(String.valueOf(Lang.getStr(17)) + string);
        this.MUndo.setEnabled(bl);
    }

    private void setClipboardEnabled(boolean bl) {
        this.MPaste.setEnabled(bl);
        this.MPasteMix.setEnabled(bl);
    }

    private void ModuleClick(MenuItem menuItem) {
        Selection selection = this.zoomGraph.getSelection();
        Zoom zoom = this.zoomGraph.getZoom();
        int n = this.wf.getLeftWave().length;
        if (this.store(String.valueOf(Lang.getStr(1030)) + " " + menuItem.getLabel())) {
            if (this.wf.isEmpty()) {
                this.wf.createNew();
            }
            try {
                ModulePack.execute(menuItem, this, new ModuleContext(this, this.wf, selection));
            }
            catch (Throwable throwable) {
                this.errorHandler(throwable, "Module " + menuItem.getLabel());
            }
            this.zoomGraph.WaveChange(this.wf.getLeftWave(), this.wf.getRightWave());
            if (n < this.wf.getLeftWave().length) {
                this.zoomGraph.setZoom(zoom.start, zoom.end + (this.wf.getLeftWave().length - n));
            }
            this.setInfos();
        }
    }

    public void GaucheClick() {
        this.zoomGraph.setGauche();
        this.mcp.setGauche();
    }

    public void EnsembleClick() {
        this.zoomGraph.setEnsemble();
        this.mcp.setEnsemble();
    }

    public void DroiteClick() {
        this.zoomGraph.setDroite();
        this.mcp.setDroite();
    }

    private void LanguageClick(int n) {
        String[] stringArray;
        int n2 = LangBase.getLangIndex(IniFile.readString("Options", "Language", LangBase.getLangName()));
        if (n != n2 && this.msgDlg.show(stringArray = new String[]{Lang.getStr(1053)}, 12) == 4) {
            IniFile.writeString("Options", "Language", LangBase.getLangName(n));
            n2 = n;
        }
        int n3 = 0;
        while (n3 < this.MLanguages.length) {
            this.MLanguages[n3].setState(n3 == n2);
            ++n3;
        }
    }

    public void HelpClick(int n) {
        if (helpWindow != null) {
            helpWindow.showAide(n);
        }
    }

    private void aboutClick() {
        AboutDialog aboutDialog = new AboutDialog((Frame)this, String.valueOf(Lang.getStr(28)) + " " + Globals.name, String.valueOf(imagePath) + aboutFile);
        ((Component)aboutDialog).setVisible(true);
    }

    public void PlayClick() {
        if (!this.wf.isEmpty()) {
            this.player.play(this.zoomGraph.getSelection());
            return;
        }
        this.Etat.setText(Lang.getStr(1032));
    }

    public void LoopClick() {
        if (!this.wf.isEmpty()) {
            this.player.loop(this.zoomGraph.getSelection());
            return;
        }
        this.Etat.setText(Lang.getStr(1032));
    }

    public void StopClick() {
        if (!this.wf.isEmpty()) {
            this.player.stop();
        }
    }

    public void PauseClick() {
        if (!this.wf.isEmpty() && this.player.isPlaying()) {
            this.player.pause();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof MenuItem) {
            if (object == this.MNew) {
                this.NewClick();
                return;
            }
            if (object == this.MOuvrir) {
                this.charger(null);
                return;
            }
            if (object == this.MEnregistrer) {
                this.Enregistrer(false);
                return;
            }
            if (object == this.MEnregistrerSous) {
                this.Enregistrer(true);
                return;
            }
            if (object == this.MRevert) {
                this.charger(this.wf.getName());
                return;
            }
            if (object == this.MFormat) {
                this.FormatClick();
                return;
            }
            if (object == this.MNewInstance) {
                JaWavedit.newInstance();
                return;
            }
            if (object == this.MQuitter) {
                this.CloseClick();
                return;
            }
            if (object == this.MUndo) {
                this.UndoClick();
                return;
            }
            if (object == this.MCut) {
                this.CutClick();
                return;
            }
            if (object == this.MCopy) {
                this.CopyClick();
                return;
            }
            if (object == this.MPaste) {
                this.PasteClick();
                return;
            }
            if (object == this.MPasteMix) {
                this.PasteMixClick();
                return;
            }
            if (object == this.MSelAll) {
                this.zoomGraph.selectAll();
                return;
            }
            if (object == this.MSelNone) {
                this.zoomGraph.selectNone();
                return;
            }
            if (object == this.MSelToStart) {
                this.zoomGraph.selectToBegin();
                return;
            }
            if (object == this.MSelToEnd) {
                this.zoomGraph.selectToEnd();
                return;
            }
            if (object == this.MZoomAll) {
                this.zoomGraph.zoomAll();
                return;
            }
            if (object == this.MZoomIn) {
                this.zoomGraph.zoomInSel();
                return;
            }
            if (object == this.MZoomOut) {
                this.zoomGraph.zoomOut();
                return;
            }
            if (object == this.MGauche) {
                this.GaucheClick();
                return;
            }
            if (object == this.MDroite) {
                this.DroiteClick();
                return;
            }
            if (object == this.MEnsemble) {
                this.EnsembleClick();
                return;
            }
            if (object == this.MPlayer) {
                this.mcp.show();
                return;
            }
            if (object == this.MDebugWindow) {
                Globals.showDebugWindow();
                return;
            }
            if (object == this.MAProposJaWavedit) {
                this.aboutClick();
                return;
            }
            if (object == this.MAide) {
                this.HelpClick(0);
                return;
            }
            if (ModulePack.isExecuteModule((MenuItem)object)) {
                this.ModuleClick((MenuItem)object);
                return;
            }
            ModulePack.handleMenu(this, (MenuItem)object);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n = 0;
        while (n < LangBase.getLangCount()) {
            if (itemEvent.getItemSelectable() == this.MLanguages[n]) {
                this.LanguageClick(n);
                return;
            }
            ++n;
        }
    }

    public void JWEventPerformed(JWEvent jWEvent) {
        Toolkit toolkit = null;
        EventQueue eventQueue = null;
        try {
            toolkit = this.getToolkit();
            if (toolkit != null) {
                eventQueue = toolkit.getSystemEventQueue();
            }
        }
        catch (Exception exception) {}
        if (jWEvent.getSource() == this.zoomGraph.BGauche) {
            this.GaucheClick();
            return;
        }
        if (jWEvent.getSource() == this.zoomGraph.BDroite) {
            this.DroiteClick();
            return;
        }
        if (jWEvent.getSource() == this.zoomGraph.BEnsemble) {
            this.EnsembleClick();
            return;
        }
        switch (jWEvent.getID()) {
            case 1: {
                this.NewClick();
                return;
            }
            case 2: {
                if (eventQueue != null) {
                    eventQueue.postEvent(new ActionEvent(this.MOuvrir, 1001, ""));
                    return;
                }
                this.charger(null);
                return;
            }
            case 3: {
                this.Enregistrer(false);
                return;
            }
            case 4: {
                this.UndoClick();
                return;
            }
            case 5: {
                this.CutClick();
                return;
            }
            case 6: {
                this.CopyClick();
                return;
            }
            case 7: {
                this.PasteClick();
                return;
            }
            case 8: {
                this.PasteMixClick();
                return;
            }
            case 9: {
                this.zoomGraph.zoomInSel();
                return;
            }
            case 10: {
                this.zoomGraph.zoomOut();
                return;
            }
            case 11: {
                this.zoomGraph.zoomAll();
                return;
            }
            case 12: {
                if (eventQueue != null) {
                    eventQueue.postEvent(new ActionEvent(this.MQuitter, 1001, ""));
                    return;
                }
                this.CloseClick();
                return;
            }
            case 13: {
                this.HelpClick(0);
                return;
            }
            case 1000: {
                this.setUndoEnabled(jWEvent.getSParam() != "" ? " " + jWEvent.getSParam() : "", jWEvent.getBParam());
                return;
            }
            case 1001: {
                this.setClipboardEnabled(jWEvent.getBParam());
                return;
            }
        }
    }

    public void iniChange(String string, String string2, String string3, int n, boolean bl) {
        if (string.equals("Options") && string2.equals("Language")) {
            int n2 = LangBase.getLangIndex(string3);
            int n3 = 0;
            while (n3 < this.MLanguages.length) {
                this.MLanguages[n3].setState(n3 == n2);
                ++n3;
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 116 && !this.wf.isEmpty()) {
            this.zoomGraph.WaveChange(this.wf.getLeftWave(), this.wf.getRightWave());
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.CloseClick();
    }

    private static String getImagePath() {
        if (Globals.inApplet) {
            return "images/";
        }
        if (!IniFile.getProperty("test", "no").equals("no")) {
            return String.valueOf(Globals.userDir) + imageDir + Globals.fs;
        }
        return "Jar://" + JarPath + "/" + imageDir + "/";
    }

    private static String getHelpPath() {
        String string = String.valueOf(Globals.userDir) + helpDir + Globals.fs;
        if (Globals.inApplet) {
            return string;
        }
        if (!IniFile.getProperty("test", "no").equals("no")) {
            return string;
        }
        return "Jar://" + JarPath + "/" + helpDir + "/";
    }

    private void errorHandler(Throwable throwable, String string) {
        if (string == null) {
            string = "";
        }
        if (throwable != null && throwable.getMessage() != null && throwable.getMessage().length() > 4) {
            this.Etat.setText(String.valueOf(string) + ": " + throwable.getMessage());
        } else if (throwable != null) {
            this.Etat.setText(String.valueOf(string) + ": " + throwable.toString());
        } else {
            this.Etat.setText("Error in " + string);
        }
        Globals.debugOut(throwable, string);
    }
}

