/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.JSerial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jSyncManager.JSerial.SerialDataBitException;
import org.jSyncManager.JSerial.SerialGrabException;
import org.jSyncManager.JSerial.SerialHandshakingException;
import org.jSyncManager.JSerial.SerialInitializationException;
import org.jSyncManager.JSerial.SerialParityException;
import org.jSyncManager.JSerial.SerialPeer;
import org.jSyncManager.JSerial.SerialReleaseException;
import org.jSyncManager.JSerial.SerialSpeedException;
import org.jSyncManager.JSerial.SerialStopBitException;

public class SerialInterface {
    public static final int NOPARITY = 20;
    public static final int ODDPARITY = 21;
    public static final int EVENPARITY = 22;
    public static final int MARKPARITY = 23;
    public static final int SPACEPARITY = 24;
    private SerialPeer peer;
    private InputStream in;
    private OutputStream out;

    public SerialInterface(byte port) throws SerialInitializationException, SerialSpeedException, SerialDataBitException, SerialParityException, SerialStopBitException, SerialGrabException {
        this(port, 9600, 8, 20, 1, true);
    }

    public SerialInterface(byte port, int speed) throws SerialInitializationException, SerialSpeedException, SerialDataBitException, SerialParityException, SerialStopBitException, SerialGrabException {
        this(port, speed, 8, 20, 1, true);
    }

    public SerialInterface(byte port, int speed, int databits, int parity, int stopbits, boolean status) throws SerialInitializationException, SerialSpeedException, SerialDataBitException, SerialParityException, SerialStopBitException, SerialGrabException {
        this.peer = new SerialPeer(port);
        if (status) {
            this.peer.grabPort();
        }
        this.peer.setSpeed(speed);
        this.peer.setDataBits(databits);
        this.peer.setParity(parity - 20);
        this.peer.setStopBits(stopbits - 1);
        this.in = new InputStream(){

            public int read() throws IOException {
                return SerialInterface.this.peer.getChar();
            }
        };
        this.out = new OutputStream(){

            public void write(int b) throws IOException {
                SerialInterface.this.peer.putChar(b);
            }
        };
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public static String getPlatformName() {
        return SerialPeer.getPlatformName();
    }

    public static String getPeerVersion() {
        return SerialPeer.getVersion();
    }

    public byte getCurrentPort() {
        return this.peer.getPort();
    }

    public int getCurrentSpeed() {
        return this.peer.getSpeed();
    }

    public void setCurrentSpeed(int speed) throws SerialSpeedException {
        this.peer.setSpeed(speed);
    }

    public int getCurrentDatabits() {
        return this.peer.getDataBits();
    }

    public void setCurrentDatabits(int databits) throws SerialDataBitException {
        this.peer.setDataBits(databits);
    }

    public int getCurrentParity() {
        return this.peer.getParity();
    }

    public void setCurrentParity(int parity) throws SerialParityException {
        this.peer.setParity(parity);
    }

    public int getCurrentStopbits() {
        return this.peer.getStopBits();
    }

    public void setCurrentStopbits(int stopbits) throws SerialStopBitException {
        this.peer.setStopBits(stopbits);
    }

    public SerialPeer getPeer() {
        return this.peer;
    }

    public void releasePort() throws SerialReleaseException {
        this.peer.releasePort();
    }

    public void grabPort() throws SerialGrabException {
        this.peer.grabPort();
    }

    public boolean isReleased() {
        return this.peer.portStatus();
    }

    protected void finalize() throws Throwable {
        try {
            this.releasePort();
        }
        catch (SerialReleaseException serialReleaseException) {
            // empty catch block
        }
    }

    public void setRTSCTS(boolean state) throws SerialHandshakingException {
        this.peer.setRTSCTS(state);
    }

    public void setDSRDTR(boolean state) throws SerialHandshakingException {
        this.peer.setDSRDTR(state);
    }

    public void setXONXOFF(boolean state) throws SerialHandshakingException {
        this.peer.setXONXOFF(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transmitBreak(long length) {
        this.peer.startBreak();
        SerialInterface serialInterface = this;
        synchronized (serialInterface) {
            try {
                this.wait(length);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.peer.stopBreak();
    }

    public boolean getRTSCTSState() {
        return this.peer.getRTSCTSState();
    }

    public boolean getDSRDTRState() {
        return this.peer.getDSRDTRState();
    }

    public boolean getXONXOFFState() {
        return this.peer.getXONXOFFState();
    }
}

