/*
 * This file is part of JPhotoAlbum.
 * Copyright 2003 Jari Karjala <jpkware.com> & Tarja Hakala <hakalat.net>
 *
 * @version $Id: JPhotoExif.java,v 1.1.1.1 2004/05/21 18:24:59 jkarjala Exp $
 */
package fi.iki.jka;

import java.io.Serializable;

import com.drew.metadata.exif.ExifDirectory;

public class JPhotoExif implements Serializable {
    public int width = -1;
    public int height = -1;
    public String aperture = "";
    public String exposureTime = "";
    public String exposureBias = "";
    public String iso = "";
    public String date = "";

    public JPhotoExif() {
        // For unmarshall only
    }
    
    public JPhotoExif(ExifDirectory dir) {
        if (dir==null)
            return;
        
        try {
            if (dir.containsTag(ExifDirectory.TAG_EXIF_IMAGE_WIDTH))
                width = dir.getInt(ExifDirectory.TAG_EXIF_IMAGE_WIDTH);
            
            if (dir.containsTag(ExifDirectory.TAG_EXIF_IMAGE_HEIGHT))
                height = dir.getInt(ExifDirectory.TAG_EXIF_IMAGE_HEIGHT);
            
            aperture = dir.getDescription(ExifDirectory.TAG_FNUMBER);
            if (aperture==null)
                aperture = "";
            if (aperture.length()>0 && aperture.charAt(0)!='F')
                aperture = "F"+aperture;
                
            exposureTime = dir.getDescription(ExifDirectory.TAG_EXPOSURE_TIME);
            if (exposureTime==null)
                exposureTime = "";
            if (exposureTime.length()>0 && exposureTime.indexOf('s')<0)
                exposureTime += "s";

            exposureBias = dir.getDescription(ExifDirectory.TAG_EXPOSURE_BIAS);
            if (exposureBias==null || exposureBias.equals("0"))
                exposureBias = "";
            
            date = dir.getDescription(ExifDirectory.TAG_DATETIME);
            if (date==null)
                date = "";
            
            iso = dir.getDescription(ExifDirectory.TAG_ISO_EQUIVALENT);
            if (iso!=null && iso.charAt(0)!='I')
                iso = "ISO"+iso;
            else
                iso = "";
            
        } catch (Exception e) {
            System.out.println("Cannot set Exif:"+e);
        }
    }

    public String toString() {
        if (aperture.length()==0 || exposureTime.length()==0)
            return "No Exif";
        return width+" x "+height
            + ", "+date  
            + ", "+aperture
            + ", "+exposureTime
            + (exposureBias.length()>0 ? ", "+exposureBias : "" )
            + (iso.length()>0 ? ", "+iso : "");
    }
}
