/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.jka;

import com.drew.metadata.exif.ExifDirectory;
import java.io.Serializable;

public class JPhotoExif
implements Serializable {
    public int width = -1;
    public int height = -1;
    public String aperture = "";
    public String exposureTime = "";
    public String exposureBias = "";
    public String iso = "";
    public String date = "";

    public JPhotoExif() {
    }

    public JPhotoExif(ExifDirectory dir) {
        if (dir == null) {
            return;
        }
        try {
            if (dir.containsTag(40962)) {
                this.width = dir.getInt(40962);
            }
            if (dir.containsTag(40963)) {
                this.height = dir.getInt(40963);
            }
            this.aperture = dir.getDescription(33437);
            if (this.aperture == null) {
                this.aperture = "";
            }
            if (this.aperture.length() > 0 && this.aperture.charAt(0) != 'F') {
                this.aperture = "F" + this.aperture;
            }
            this.exposureTime = dir.getDescription(33434);
            if (this.exposureTime == null) {
                this.exposureTime = "";
            }
            if (this.exposureTime.length() > 0 && this.exposureTime.indexOf(115) < 0) {
                this.exposureTime = String.valueOf(this.exposureTime) + "s";
            }
            this.exposureBias = dir.getDescription(37380);
            if (this.exposureBias == null || this.exposureBias.equals("0")) {
                this.exposureBias = "";
            }
            this.date = dir.getDescription(306);
            if (this.date == null) {
                this.date = "";
            }
            this.iso = dir.getDescription(34855);
            this.iso = this.iso != null && this.iso.charAt(0) != 'I' ? "ISO" + this.iso : "";
        }
        catch (Exception e) {
            System.out.println("Cannot set Exif:" + e);
        }
    }

    public String toString() {
        if (this.aperture.length() == 0 || this.exposureTime.length() == 0) {
            return "No Exif";
        }
        return String.valueOf(this.width) + " x " + this.height + ", " + this.date + ", " + this.aperture + ", " + this.exposureTime + (this.exposureBias.length() > 0 ? ", " + this.exposureBias : "") + (this.iso.length() > 0 ? ", " + this.iso : "");
    }
}

