/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.xerces.utils.regex.RegularExpression;
import org.apache.xerces.validators.datatype.AbstractDatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;

public class FloatDatatypeValidator
extends AbstractDatatypeValidator {
    private Locale fLocale = null;
    private DatatypeValidator fBaseValidator = null;
    private float[] fEnumFloats = null;
    private String fPattern = null;
    private float fMaxInclusive = Float.POSITIVE_INFINITY;
    private float fMaxExclusive = Float.POSITIVE_INFINITY;
    private float fMinInclusive = Float.NEGATIVE_INFINITY;
    private float fMinExclusive = Float.NEGATIVE_INFINITY;
    private int fFacetsDefined = 0;
    private boolean isMaxExclusiveDefined = false;
    private boolean isMaxInclusiveDefined = false;
    private boolean isMinExclusiveDefined = false;
    private boolean isMinInclusiveDefined = false;
    private DatatypeMessageProvider fMessageProvider = new DatatypeMessageProvider();
    private RegularExpression fRegex = null;

    public FloatDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public FloatDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        if (datatypeValidator != null) {
            this.setBasetype(datatypeValidator);
        }
        if (hashtable != null) {
            Object object;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string;
                object = (String)enumeration.nextElement();
                if (((String)object).equals("pattern")) {
                    this.fFacetsDefined += 8;
                    this.fPattern = (String)hashtable.get(object);
                    if (this.fPattern == null) continue;
                    this.fRegex = new RegularExpression(this.fPattern, "X");
                    continue;
                }
                if (((String)object).equals("enumeration")) {
                    this.fFacetsDefined += 16;
                    continue;
                }
                if (((String)object).equals("maxInclusive")) {
                    this.fFacetsDefined += 32;
                    string = null;
                    try {
                        string = (String)hashtable.get(object);
                        this.fMaxInclusive = Float.valueOf(string).floatValue();
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidDatatypeFacetException(this.getErrorString(5, 0, new Object[]{string, object}));
                    }
                }
                if (((String)object).equals("maxExclusive")) {
                    this.fFacetsDefined += 64;
                    string = null;
                    try {
                        string = (String)hashtable.get(object);
                        this.fMaxExclusive = Float.valueOf(string).floatValue();
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidDatatypeFacetException(this.getErrorString(5, 0, new Object[]{string, object}));
                    }
                }
                if (((String)object).equals("minInclusive")) {
                    this.fFacetsDefined += 128;
                    string = null;
                    try {
                        string = (String)hashtable.get(object);
                        this.fMinInclusive = Float.valueOf(string).floatValue();
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidDatatypeFacetException(this.getErrorString(5, 0, new Object[]{string, object}));
                    }
                }
                if (((String)object).equals("minExclusive")) {
                    this.fFacetsDefined += 256;
                    string = null;
                    try {
                        string = (String)hashtable.get(object);
                        this.fMinExclusive = Float.valueOf(string).floatValue();
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidDatatypeFacetException(this.getErrorString(5, 0, new Object[]{string, object}));
                    }
                }
                throw new InvalidDatatypeFacetException(this.getErrorString(1, 0, null));
            }
            this.isMaxExclusiveDefined = (this.fFacetsDefined & 0x40) != 0;
            this.isMaxInclusiveDefined = (this.fFacetsDefined & 0x20) != 0;
            this.isMinExclusiveDefined = (this.fFacetsDefined & 0x100) != 0;
            boolean bl2 = this.isMinInclusiveDefined = (this.fFacetsDefined & 0x80) != 0;
            if (this.isMaxExclusiveDefined && this.isMaxInclusiveDefined) {
                throw new InvalidDatatypeFacetException("It is an error for both maxInclusive and maxExclusive to be specified for the same datatype.");
            }
            if (this.isMinExclusiveDefined && this.isMinInclusiveDefined) {
                throw new InvalidDatatypeFacetException("It is an error for both minInclusive and minExclusive to be specified for the same datatype.");
            }
            if (this.isMaxExclusiveDefined && this.isMinExclusiveDefined && this.fMaxExclusive <= this.fMinExclusive) {
                throw new InvalidDatatypeFacetException("maxExclusive value ='" + this.fMaxExclusive + "'must be > than minExclusive value ='" + this.fMinExclusive + "'. ");
            }
            if (this.isMaxInclusiveDefined && this.isMinInclusiveDefined && this.fMaxInclusive < this.fMinInclusive) {
                throw new InvalidDatatypeFacetException("maxInclusive value ='" + this.fMaxInclusive + "'must be >= than minInclusive value ='" + this.fMinInclusive + "'. ");
            }
            if (this.isMaxExclusiveDefined && this.isMinInclusiveDefined && this.fMaxExclusive <= this.fMinInclusive) {
                throw new InvalidDatatypeFacetException("maxExclusive value ='" + this.fMaxExclusive + "'must be > than minInclusive value ='" + this.fMinInclusive + "'. ");
            }
            if (this.isMaxInclusiveDefined && this.isMinExclusiveDefined && this.fMaxInclusive <= this.fMinExclusive) {
                throw new InvalidDatatypeFacetException("maxInclusive value ='" + this.fMaxInclusive + "'must be > than minExclusive value ='" + this.fMinExclusive + "'. ");
            }
            if ((this.fFacetsDefined & 0x10) != 0 && (object = (Vector)hashtable.get("enumeration")) != null) {
                this.fEnumFloats = new float[((Vector)object).size()];
                int n = 0;
                while (n < ((Vector)object).size()) {
                    try {
                        this.fEnumFloats[n] = Float.valueOf((String)((Vector)object).elementAt(n)).floatValue();
                        this.boundsCheck(this.fEnumFloats[n]);
                    }
                    catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                        throw new InvalidDatatypeFacetException(this.getErrorString(8, 0, new Object[]{((Vector)object).elementAt(n)}));
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (((Vector)object).elementAt(n).equals("INF")) {
                            this.fEnumFloats[n] = Float.POSITIVE_INFINITY;
                        }
                        if (((Vector)object).elementAt(n).equals("-INF")) {
                            this.fEnumFloats[n] = Float.NEGATIVE_INFINITY;
                        }
                        if (((Vector)object).elementAt(n).equals("NaN")) {
                            this.fEnumFloats[n] = Float.NaN;
                        }
                        throw new InvalidDatatypeFacetException(this.getErrorString(5, 0, new Object[]{((Vector)object).elementAt(n), "enumeration"}));
                    }
                    ++n;
                }
            }
        }
    }

    private void boundsCheck(float f) throws InvalidDatatypeValueException {
        String string;
        boolean bl = false;
        boolean bl2 = false;
        String string2 = this.fMaxExclusive != Float.MAX_VALUE ? Float.toString(this.fMaxExclusive) : (string = this.fMaxInclusive != Float.MAX_VALUE ? Float.toString(this.fMaxInclusive) : "");
        String string3 = this.fMinExclusive != Float.MIN_VALUE ? Float.toString(this.fMinExclusive) : (this.fMinInclusive != Float.MIN_VALUE ? Float.toString(this.fMinInclusive) : "");
        String string4 = "";
        String string5 = "";
        if (this.isMaxInclusiveDefined) {
            bl2 = f <= this.fMaxInclusive;
            string = Float.toString(this.fMaxInclusive);
            if (string != null) {
                string5 = "<=";
            } else {
                string = "";
            }
        } else if (this.isMaxExclusiveDefined) {
            bl2 = f < this.fMaxExclusive;
            string = Float.toString(this.fMaxExclusive);
            if (string != null) {
                string5 = "<";
            } else {
                string = "";
            }
        } else {
            boolean bl3 = bl2 = !this.isMaxInclusiveDefined && !this.isMaxExclusiveDefined;
        }
        if (this.isMinInclusiveDefined) {
            bl = f >= this.fMinInclusive;
            string3 = Float.toString(this.fMinInclusive);
            if (string3 != null) {
                string4 = "<=";
            } else {
                string3 = "";
            }
        } else if (this.isMinExclusiveDefined) {
            bl = f > this.fMinExclusive;
            string3 = Float.toString(this.fMinExclusive);
            if (string3 != null) {
                string4 = "<";
            } else {
                string3 = "";
            }
        } else {
            boolean bl4 = bl = !this.isMinInclusiveDefined && !this.isMinExclusiveDefined;
        }
        if (!bl || !bl2) {
            throw new InvalidDatatypeValueException(this.getErrorString(9, 0, new Object[]{Float.toString(f), string3, string, string4, string5}));
        }
    }

    protected void checkContentEnum(String string, Object object, Vector vector) throws InvalidDatatypeValueException {
        if (this.fBaseValidator != null) {
            ((FloatDatatypeValidator)this.fBaseValidator).checkContentEnum(string, object, vector);
        }
        if (!((this.fFacetsDefined & 8) == 0 || this.fRegex != null && this.fRegex.matches(string))) {
            throw new InvalidDatatypeValueException("Value'" + string + "does not match regular expression facet" + this.fPattern);
        }
        float f = 0.0f;
        try {
            f = Float.valueOf(string).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            if (string.equals("INF")) {
                f = Float.POSITIVE_INFINITY;
            }
            if (string.equals("-INF")) {
                f = Float.NEGATIVE_INFINITY;
            }
            if (string.equals("NaN")) {
                f = Float.NaN;
            }
            throw new InvalidDatatypeValueException(this.getErrorString(18, 0, new Object[]{string}));
        }
        if (vector != null) {
            int n = vector.size();
            float[] fArray = new float[n];
            int n2 = 0;
            try {
                while (n2 < n) {
                    fArray[n2] = Float.valueOf((String)vector.elementAt(n2)).floatValue();
                    ++n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (vector.elementAt(n2).equals("INF")) {
                    fArray[n2] = Float.POSITIVE_INFINITY;
                }
                if (vector.elementAt(n2).equals("-INF")) {
                    fArray[n2] = Float.NEGATIVE_INFINITY;
                }
                if (vector.elementAt(n2).equals("NaN")) {
                    fArray[n2] = Float.NaN;
                }
                throw new InvalidDatatypeValueException(this.getErrorString(8, 0, new Object[]{vector.elementAt(n2)}));
            }
            this.enumCheck(f, fArray);
        }
        this.boundsCheck(f);
        if ((this.fFacetsDefined & 0x10) != 0) {
            this.enumCheck(f, this.fEnumFloats);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }

    public int compare(String string, String string2) {
        try {
            Float f = Float.valueOf(string);
            Float f2 = Float.valueOf(string2);
            return f.compareTo(f2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private void enumCheck(float f, float[] fArray) throws InvalidDatatypeValueException {
        int n = 0;
        while (n < fArray.length) {
            if (f == fArray[n]) {
                return;
            }
            ++n;
        }
        throw new InvalidDatatypeValueException(this.getErrorString(10, 0, new Object[]{new Float(f)}));
    }

    private String getErrorString(int n, int n2, Object[] objectArray) {
        try {
            return this.fMessageProvider.createMessage(this.fLocale, n, n2, objectArray);
        }
        catch (Exception exception) {
            return "Illegal Errorcode " + n2;
        }
    }

    private void setBasetype(DatatypeValidator datatypeValidator) {
        this.fBaseValidator = datatypeValidator;
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    public Object validate(String string, Object object) throws InvalidDatatypeValueException {
        this.checkContentEnum(string, object, null);
        return null;
    }
}

